package com.bizvane.appletservice.common;

import com.bizvane.utils.responseinfo.ResponseData;

/**
 * @author yifei
 * @since 2022/7/31
 */
public class Result<T> extends ResponseData<T> {
    private static final long serialVersionUID = -117262504288364093L;

    private Long total;
    private boolean success;

    public Result() {
    }

    public static <T> Result<T> newResult() {
        return new Result();
    }

    public static <T> Result<T> success(T data, Long total) {
        Result<T> result = newResult();
        result.setData(data);
        result.setTotal(total);
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> success(T data) {
        Result<T> result = newResult();
        result.setData(data);
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> success() {
        Result<T> result = newResult();
        result.setSuccess(true);
        return result;
    }

    public static <T> Result<T> failure(String message) {
        Result<T> result = newResult();
        result.setMessage(message);
        result.setSuccess(false);
        return result;
    }

    public static <T> Result<T> failure(Integer errorCode, String message) {
        Result<T> result = newResult();
        result.setCode(errorCode);
        result.setMessage(message);
        result.setSuccess(false);
        return result;
    }

    public static <T> Result<T> failure(T t, Integer errorCode, String message) {
        Result<T> result = newResult();
        result.setData(t);
        result.setCode(errorCode);
        result.setMessage(message);
        result.setSuccess(false);
        return result;
    }

    public void setTotal(final Long total) {
        this.total = total;
    }

    public void setSuccess(final boolean success) {
        this.success = success;
    }

    public Long getTotal() {
        return this.total;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public String toString() {
        return "Result(total=" + this.getTotal() + ", success=" + this.isSuccess() + ")";
    }
}
