package com.bizvane.appletservice.interfaces;


import com.bizvane.appletservice.models.bo.WxPayLevelBO;
import com.bizvane.appletservice.models.vo.CreateGitfCardOrderVo;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.centerstageservice.models.po.WxPayConfigPo;
import com.bizvane.members.facade.models.MbrLevelModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * @ClassName WxPayService
 * @DescriptTion :
 * @Auther: wd
 * @Date :2018/12/10 11:08
 */
public interface WxPayService {
    //微信支付
    Map<String, String> createRecharge(CreateRechargeVO vo, WxPayConfigPo configPo);

    Map<String, String> createGiftCardOrder(CreateGitfCardOrderVo vo, WxPayConfigPo configPo);

    //支付回调
    String callback(HttpServletRequest req, HttpServletResponse res);


    Map<String, String> createPayLevelRecharge(MbrLevelModel levelModel, WxPayLevelBO wxPayLevelBO);

    String payLevelCallBack(HttpServletRequest request,HttpServletResponse response);

    /**
     * 获取扫码的门店id
     * @param memberCode
     * @return
     */
    Long getSysStoreId(String memberCode);

    /**
     * 付费卡等级调用基础服务微信支付
     * @param levelModel
     * @param wxPayLevelBO
     * @return
     */
    Map<String, String> createPayLevelRechargeNew(MbrLevelModel levelModel, WxPayLevelBO wxPayLevelBO);

    //积分充值支付
    Map<String, String> createIntegralRecharge(CreateRechargeVO vo, WxPayConfigPo configPo);
}
