package com.bizvane.appletservice.models.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

public class MemberInfoModelBo {
    private static final long serialVersionUID = -7718431512626549518L;
    @ApiModelProperty(
            value = "会员id",
            name = "mbrMemberId"
    )

    private Long mbrMemberId;
    @ApiModelProperty(
            value = "会员code",
            name = "memberCode"
    )
    private String memberCode;
    @ApiModelProperty(
            value = "会员线上卡号",
            name = "cardNo"
    )
    private String cardNo;
    @ApiModelProperty(
            value = "会员线下卡号",
            name = "offlineCardNo"
    )
    private String offlineCardNo;
    @ApiModelProperty(
            value = "会员姓名",
            name = "name"
    )
    private String name;
    @ApiModelProperty(
            value = "会员手机号",
            name = "phone"
    )
    private String phone;
    @ApiModelProperty(
            value = "会员身份证号",
            name = "idCard"
    )
    private String idCard;
    @ApiModelProperty(
            value = "会员性别",
            name = "gender"
    )
    private String gender;
    @ApiModelProperty(
            value = "会员生日",
            name = "birthday"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date birthday;
    @ApiModelProperty(
            value = "冗余生日时间格式，月日",
            name = "birthdayMd"
    )
    private String birthdayMd;
    @ApiModelProperty(
            value = "会员省份",
            name = "province"
    )
    private String province;
    @ApiModelProperty(
            value = "会员城市",
            name = "city"
    )
    private String city;
    @ApiModelProperty(
            value = "会员区县",
            name = "county"
    )
    private String county;
    @ApiModelProperty(
            value = "会员详细地址",
            name = "address"
    )
    private String address;
    @ApiModelProperty(
            value = "会员邮件",
            name = "email"
    )
    private String email;
    @ApiModelProperty(
            value = "会员头像",
            name = "headPortraits"
    )
    private String headPortraits;
    @ApiModelProperty(
            value = "会员卡条形码",
            name = "barCode"
    )
    private String barCode;
    @ApiModelProperty(
            value = "会员体系id",
            name = "memberSysId"
    )
    private Long memberSysId;
    @ApiModelProperty(
            value = "企业id",
            name = "sysCompanyId"
    )
    private Long sysCompanyId;
    @ApiModelProperty(
            value = "品牌id",
            name = "brandId"
    )
    private Long brandId;
    @ApiModelProperty(
            value = "erpId",
            name = "erpId"
    )
    private String erpId;
    @ApiModelProperty(
            value = "开卡时间",
            name = "openCardTime"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            locale = "zh",
            timezone = "GMT+8"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date openCardTime;
    @ApiModelProperty(
            value = "绑卡时间",
            name = "bindCardTime"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            locale = "zh",
            timezone = "GMT+8"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date bindCardTime;
    @ApiModelProperty(
            value = "有效期",
            name = "effectiveTime"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            locale = "zh",
            timezone = "GMT+8"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date effectiveTime;
    @ApiModelProperty(
            value = "开卡渠道id",
            name = "openCardChannelId"
    )
    private Long openCardChannelId;
    @ApiModelProperty(
            value = "全渠道会员卡ids",
            name = "allChannelIds"
    )
    private String allChannelIds;
    @ApiModelProperty(
            value = "推广渠道",
            name = "generalizeChannel"
    )
    private String generalizeChannel;
    @ApiModelProperty(
            value = "开卡导购id",
            name = "openCardGuideId"
    )
    private Long openCardGuideId;
    @ApiModelProperty(
            value = "线下归属经销商id",
            name = "offlineDealerAttributionId"
    )
    private Long offlineDealerAttributionId;
    @ApiModelProperty(
            value = "开卡门店id",
            name = "openCardStoreId"
    )
    private Long openCardStoreId;
    @ApiModelProperty(
            value = "服务门店id",
            name = "serviceStoreId"
    )
    private Long serviceStoreId;
    @ApiModelProperty(
            value = "服务导购id",
            name = "serviceGuideId"
    )
    private Long serviceGuideId;
    @ApiModelProperty(
            value = "活跃门店",
            name = "activeStore"
    )
    private String activeStore;
    @ApiModelProperty(
            value = "微信openId",
            name = "wxOpenId"
    )
    private String wxOpenId;
    @ApiModelProperty(
            value = "微信UnionId",
            name = "wxUnionId"
    )
    private String wxUnionId;
    @ApiModelProperty(
            value = "微信公众号Id",
            name = "wxPublicId"
    )
    private Long wxPublicId;
    @ApiModelProperty(
            value = "会员等级Id",
            name = "levelId"
    )
    private Long levelId;
    @ApiModelProperty(
            value = "会员等级名称",
            name = "levelName"
    )
    private String levelName;
    @ApiModelProperty(
            value = "会员标签names",
            name = "labelNames"
    )
    private String labelNames;
    @ApiModelProperty(
            value = "会员标签Ids",
            name = "labelIds"
    )
    private String labelIds;
    @ApiModelProperty(
            value = "扩展属性Ids",
            name = "extendIds"
    )
    private String extendIds;
    @ApiModelProperty(
            value = "累计可用积分",
            name = "countIntegral"
    )
    private String countIntegral;
    @ApiModelProperty(
            value = "分销状态",
            name = "distributionState"
    )
    private Integer distributionState;
    @ApiModelProperty(
            value = "分销创建人",
            name = "distributionCreateName"
    )
    private String distributionCreateName;
    @ApiModelProperty(
            value = "分销会员创建时间",
            name = "distributionCreateTime"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            locale = "zh",
            timezone = "GMT+8"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date distributionCreateTime;
    @ApiModelProperty(
            value = "分销状态修改人",
            name = "distributionModifiedName"
    )
    private String distributionModifiedName;
    @ApiModelProperty(
            value = "分销状态修改时间",
            name = "distributionModifiedTime"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            locale = "zh",
            timezone = "GMT+8"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date distributionModifiedTime;
    @ApiModelProperty(
            name = "cardStatus",
            value = "绑卡状态：1绑卡、2未帮卡"
    )
    private Integer cardStatus;
    @ApiModelProperty(
            name = "firstLandingCheck",
            value = "是否首次登录"
    )
    private Integer firstLandingCheck;
    @ApiModelProperty(
            value = "线下品牌code",
            name = "offlineBrandCode",
            required = false,
            example = "线下品牌code"
    )
    private String offlineBrandCode;
    @ApiModelProperty(
            value = "开卡导购线下code",
            name = "openCardGuideCode",
            required = false,
            example = "开卡导购线下code"
    )
    private String openCardGuideCode;
    @ApiModelProperty(
            value = "线下经销商",
            name = "offlineDealerAttributionCode",
            required = false,
            example = "线下经销商"
    )
    private String offlineDealerAttributionCode;
    @ApiModelProperty(
            value = "线下归属经销商name",
            name = "dealerAttributionName",
            required = false,
            example = "线下归属经销商name"
    )
    private String dealerAttributionName;
    @ApiModelProperty(
            value = "开卡店铺线下code",
            name = "openCardStoreCode",
            required = false,
            example = "开卡店铺线下code"
    )
    private String openCardStoreCode;
    @ApiModelProperty(
            value = "服务门店线下code",
            name = "serviceStoreCode",
            required = false,
            example = "服务门店线下code"
    )
    private String serviceStoreCode;
    @ApiModelProperty(
            value = "服务导购线下code",
            name = "serviceGuideCode",
            required = false,
            example = "服务导购线下code"
    )
    private String serviceGuideCode;
    @ApiModelProperty(
            value = "线下等级code",
            name = "offlineLevelCode",
            required = false,
            example = "线下等级code"
    )
    private String offlineLevelCode;
    @ApiModelProperty(
            value = "累计收入的总积分",
            name = "countIntegral",
            example = "累计收入的总积分"
    )
    private Integer addUpIntegral;
    @ApiModelProperty(
            value = "即将到期积分",
            name = "aboutExpireIntegral",
            example = "即将到期积分"
    )
    private Integer aboutExpireIntegral;
    @ApiModelProperty(
            value = "即将到期时间",
            name = "aboutExpireTime",
            example = "即将到期时间"
    )
    private Date aboutExpireTime;
    @ApiModelProperty(
            value = "线下更新时间",
            name = "offlineUpdateDate",
            example = "线下更新时间"
    )
    private Date offlineUpdateDate;
    @ApiModelProperty(
            value = "已过期积分",
            name = "pastDueIntegral",
            example = "已过期积分"
    )
    private Integer pastDueIntegral;
    @ApiModelProperty(
            value = "已消耗积分",
            name = "consumeIntegral",
            example = "已消耗积分"
    )
    private Integer consumeIntegral;
    @ApiModelProperty(
            value = "冻结积分",
            name = "consumeIntegral",
            example = "冻结积分"
    )
    private Integer freezeIntegral;
    @ApiModelProperty(
            value = "积分兑换券次数",
            name = "consumeIntegral",
            example = "冻结积分"
    )
    private Integer integralExchangeTicketCount;
    @ApiModelProperty(
            value = "线下企业code",
            name = "companyCode",
            example = "线下企业code"
    )
    private String offlineCompanyCode;
    @ApiModelProperty(
            value = "省份code",
            name = "provinceCode",
            example = "省份code"
    )
    private String provinceCode;
    @ApiModelProperty(
            value = "市code",
            name = "cityCode",
            example = "市code"
    )
    private String cityCode;
    @ApiModelProperty(
            value = "区code",
            name = "consumeIntegral",
            example = "已消耗积分"
    )
    private String countyCode;
    @ApiModelProperty(
            value = "折扣计算方式: 0=就低原则;1=折上折原则",
            name = "discountMethod"
    )
    private Integer discountMethod;
    @ApiModelProperty(
            value = "会员折扣",
            name = "memberDiscount"
    )
    private Integer memberDiscount;
    @ApiModelProperty(
            value = "折上折",
            name = "additionalDiscount"
    )
    private Integer additionalDiscount;
    @ApiModelProperty(
            value = "积分计算规则:1=向上取整;2=四舍五入;3=向下取整",
            name = "calculateRule"
    )
    private Integer calculateRule;
    @ApiModelProperty(
            value = "最后一次ES更新数据的时间",
            name = "lastEsTime"
    )
    private Date lastEsTime;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getMbrMemberId() {
        return mbrMemberId;
    }

    public void setMbrMemberId(Long mbrMemberId) {
        this.mbrMemberId = mbrMemberId;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getOfflineCardNo() {
        return offlineCardNo;
    }

    public void setOfflineCardNo(String offlineCardNo) {
        this.offlineCardNo = offlineCardNo;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getBirthdayMd() {
        return birthdayMd;
    }

    public void setBirthdayMd(String birthdayMd) {
        this.birthdayMd = birthdayMd;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCounty() {
        return county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getHeadPortraits() {
        return headPortraits;
    }

    public void setHeadPortraits(String headPortraits) {
        this.headPortraits = headPortraits;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public Long getMemberSysId() {
        return memberSysId;
    }

    public void setMemberSysId(Long memberSysId) {
        this.memberSysId = memberSysId;
    }

    public Long getSysCompanyId() {
        return sysCompanyId;
    }

    public void setSysCompanyId(Long sysCompanyId) {
        this.sysCompanyId = sysCompanyId;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getErpId() {
        return erpId;
    }

    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    public Date getOpenCardTime() {
        return openCardTime;
    }

    public void setOpenCardTime(Date openCardTime) {
        this.openCardTime = openCardTime;
    }

    public Date getBindCardTime() {
        return bindCardTime;
    }

    public void setBindCardTime(Date bindCardTime) {
        this.bindCardTime = bindCardTime;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Long getOpenCardChannelId() {
        return openCardChannelId;
    }

    public void setOpenCardChannelId(Long openCardChannelId) {
        this.openCardChannelId = openCardChannelId;
    }

    public String getAllChannelIds() {
        return allChannelIds;
    }

    public void setAllChannelIds(String allChannelIds) {
        this.allChannelIds = allChannelIds;
    }

    public String getGeneralizeChannel() {
        return generalizeChannel;
    }

    public void setGeneralizeChannel(String generalizeChannel) {
        this.generalizeChannel = generalizeChannel;
    }

    public Long getOpenCardGuideId() {
        return openCardGuideId;
    }

    public void setOpenCardGuideId(Long openCardGuideId) {
        this.openCardGuideId = openCardGuideId;
    }

    public Long getOfflineDealerAttributionId() {
        return offlineDealerAttributionId;
    }

    public void setOfflineDealerAttributionId(Long offlineDealerAttributionId) {
        this.offlineDealerAttributionId = offlineDealerAttributionId;
    }

    public Long getOpenCardStoreId() {
        return openCardStoreId;
    }

    public void setOpenCardStoreId(Long openCardStoreId) {
        this.openCardStoreId = openCardStoreId;
    }

    public Long getServiceStoreId() {
        return serviceStoreId;
    }

    public void setServiceStoreId(Long serviceStoreId) {
        this.serviceStoreId = serviceStoreId;
    }

    public Long getServiceGuideId() {
        return serviceGuideId;
    }

    public void setServiceGuideId(Long serviceGuideId) {
        this.serviceGuideId = serviceGuideId;
    }

    public String getActiveStore() {
        return activeStore;
    }

    public void setActiveStore(String activeStore) {
        this.activeStore = activeStore;
    }

    public String getWxOpenId() {
        return wxOpenId;
    }

    public void setWxOpenId(String wxOpenId) {
        this.wxOpenId = wxOpenId;
    }

    public String getWxUnionId() {
        return wxUnionId;
    }

    public void setWxUnionId(String wxUnionId) {
        this.wxUnionId = wxUnionId;
    }

    public Long getWxPublicId() {
        return wxPublicId;
    }

    public void setWxPublicId(Long wxPublicId) {
        this.wxPublicId = wxPublicId;
    }

    public Long getLevelId() {
        return levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    public String getLevelName() {
        return levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public String getLabelNames() {
        return labelNames;
    }

    public void setLabelNames(String labelNames) {
        this.labelNames = labelNames;
    }

    public String getLabelIds() {
        return labelIds;
    }

    public void setLabelIds(String labelIds) {
        this.labelIds = labelIds;
    }

    public String getExtendIds() {
        return extendIds;
    }

    public void setExtendIds(String extendIds) {
        this.extendIds = extendIds;
    }

    public String getCountIntegral() {
        return countIntegral;
    }

    public void setCountIntegral(String countIntegral) {
        this.countIntegral = countIntegral;
    }

    public Integer getDistributionState() {
        return distributionState;
    }

    public void setDistributionState(Integer distributionState) {
        this.distributionState = distributionState;
    }

    public String getDistributionCreateName() {
        return distributionCreateName;
    }

    public void setDistributionCreateName(String distributionCreateName) {
        this.distributionCreateName = distributionCreateName;
    }

    public Date getDistributionCreateTime() {
        return distributionCreateTime;
    }

    public void setDistributionCreateTime(Date distributionCreateTime) {
        this.distributionCreateTime = distributionCreateTime;
    }

    public String getDistributionModifiedName() {
        return distributionModifiedName;
    }

    public void setDistributionModifiedName(String distributionModifiedName) {
        this.distributionModifiedName = distributionModifiedName;
    }

    public Date getDistributionModifiedTime() {
        return distributionModifiedTime;
    }

    public void setDistributionModifiedTime(Date distributionModifiedTime) {
        this.distributionModifiedTime = distributionModifiedTime;
    }

    public Integer getCardStatus() {
        return cardStatus;
    }

    public void setCardStatus(Integer cardStatus) {
        this.cardStatus = cardStatus;
    }

    public Integer getFirstLandingCheck() {
        return firstLandingCheck;
    }

    public void setFirstLandingCheck(Integer firstLandingCheck) {
        this.firstLandingCheck = firstLandingCheck;
    }

    public String getOfflineBrandCode() {
        return offlineBrandCode;
    }

    public void setOfflineBrandCode(String offlineBrandCode) {
        this.offlineBrandCode = offlineBrandCode;
    }

    public String getOpenCardGuideCode() {
        return openCardGuideCode;
    }

    public void setOpenCardGuideCode(String openCardGuideCode) {
        this.openCardGuideCode = openCardGuideCode;
    }

    public String getOfflineDealerAttributionCode() {
        return offlineDealerAttributionCode;
    }

    public void setOfflineDealerAttributionCode(String offlineDealerAttributionCode) {
        this.offlineDealerAttributionCode = offlineDealerAttributionCode;
    }

    public String getDealerAttributionName() {
        return dealerAttributionName;
    }

    public void setDealerAttributionName(String dealerAttributionName) {
        this.dealerAttributionName = dealerAttributionName;
    }

    public String getOpenCardStoreCode() {
        return openCardStoreCode;
    }

    public void setOpenCardStoreCode(String openCardStoreCode) {
        this.openCardStoreCode = openCardStoreCode;
    }

    public String getServiceStoreCode() {
        return serviceStoreCode;
    }

    public void setServiceStoreCode(String serviceStoreCode) {
        this.serviceStoreCode = serviceStoreCode;
    }

    public String getServiceGuideCode() {
        return serviceGuideCode;
    }

    public void setServiceGuideCode(String serviceGuideCode) {
        this.serviceGuideCode = serviceGuideCode;
    }

    public String getOfflineLevelCode() {
        return offlineLevelCode;
    }

    public void setOfflineLevelCode(String offlineLevelCode) {
        this.offlineLevelCode = offlineLevelCode;
    }

    public Integer getAddUpIntegral() {
        return addUpIntegral;
    }

    public void setAddUpIntegral(Integer addUpIntegral) {
        this.addUpIntegral = addUpIntegral;
    }

    public Integer getAboutExpireIntegral() {
        return aboutExpireIntegral;
    }

    public void setAboutExpireIntegral(Integer aboutExpireIntegral) {
        this.aboutExpireIntegral = aboutExpireIntegral;
    }

    public Date getAboutExpireTime() {
        return aboutExpireTime;
    }

    public void setAboutExpireTime(Date aboutExpireTime) {
        this.aboutExpireTime = aboutExpireTime;
    }

    public Date getOfflineUpdateDate() {
        return offlineUpdateDate;
    }

    public void setOfflineUpdateDate(Date offlineUpdateDate) {
        this.offlineUpdateDate = offlineUpdateDate;
    }

    public Integer getPastDueIntegral() {
        return pastDueIntegral;
    }

    public void setPastDueIntegral(Integer pastDueIntegral) {
        this.pastDueIntegral = pastDueIntegral;
    }

    public Integer getConsumeIntegral() {
        return consumeIntegral;
    }

    public void setConsumeIntegral(Integer consumeIntegral) {
        this.consumeIntegral = consumeIntegral;
    }

    public Integer getFreezeIntegral() {
        return freezeIntegral;
    }

    public void setFreezeIntegral(Integer freezeIntegral) {
        this.freezeIntegral = freezeIntegral;
    }

    public Integer getIntegralExchangeTicketCount() {
        return integralExchangeTicketCount;
    }

    public void setIntegralExchangeTicketCount(Integer integralExchangeTicketCount) {
        this.integralExchangeTicketCount = integralExchangeTicketCount;
    }

    public String getOfflineCompanyCode() {
        return offlineCompanyCode;
    }

    public void setOfflineCompanyCode(String offlineCompanyCode) {
        this.offlineCompanyCode = offlineCompanyCode;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public Integer getDiscountMethod() {
        return discountMethod;
    }

    public void setDiscountMethod(Integer discountMethod) {
        this.discountMethod = discountMethod;
    }

    public Integer getMemberDiscount() {
        return memberDiscount;
    }

    public void setMemberDiscount(Integer memberDiscount) {
        this.memberDiscount = memberDiscount;
    }

    public Integer getAdditionalDiscount() {
        return additionalDiscount;
    }

    public void setAdditionalDiscount(Integer additionalDiscount) {
        this.additionalDiscount = additionalDiscount;
    }

    public Integer getCalculateRule() {
        return calculateRule;
    }

    public void setCalculateRule(Integer calculateRule) {
        this.calculateRule = calculateRule;
    }

    public Date getLastEsTime() {
        return lastEsTime;
    }

    public void setLastEsTime(Date lastEsTime) {
        this.lastEsTime = lastEsTime;
    }
}
