package com.bizvane.appletservice.models.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

public class AppletTaskWXBO {
    private Long taskId;
    private String taskCode;
    private String taskName;
    private Integer taskType;

    @Override
    public String toString() {
        return "AppletTaskWXBO{" +
                "taskId=" + taskId +
                ", taskCode='" + taskCode + '\'' +
                ", taskName='" + taskName + '\'' +
                ", taskType=" + taskType +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", rewarded=" + rewarded +
                ", taskProgress='" + taskProgress + '\'' +
                ", sourceType=" + sourceType +
                ", appletBrandFunctionBo=" + appletBrandFunctionBo +
                ", remaks=" + remaks +
                '}';
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd",
            locale = "zh",
            timezone = "GMT+8"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd"
    )
    private Date startTime;
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            locale = "zh",
            timezone = "GMT+8"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd"
    )
    private Date endTime;
    private Integer rewarded;
    private String taskProgress;
    private Integer sourceType;
    private AppletBrandFunctionBo appletBrandFunctionBo;
    private Integer remaks;
    private String templateCode;
    private String templateJson;

    private Long sysCompanyId;

    private Long sysBrandId;

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public String getTaskCode() {
        return this.taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getRewarded() {
        return this.rewarded;
    }

    public void setRewarded(Integer rewarded) {
        this.rewarded = rewarded;
    }

    public String getTaskProgress() {
        return this.taskProgress;
    }

    public void setTaskProgress(String taskProgress) {
        this.taskProgress = taskProgress;
    }

    public Integer getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public AppletBrandFunctionBo getAppletBrandFunctionBo() {
        return appletBrandFunctionBo;
    }

    public void setAppletBrandFunctionBo(AppletBrandFunctionBo appletBrandFunctionBo) {
        this.appletBrandFunctionBo = appletBrandFunctionBo;
    }

    public Integer getRemaks() {
        return remaks;
    }

    public void setRemaks(Integer remaks) {
        this.remaks = remaks;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateJson() {
        return templateJson;
    }

    public void setTemplateJson(String templateJson) {
        this.templateJson = templateJson;
    }

    public Long getSysCompanyId() {
        return sysCompanyId;
    }

    public void setSysCompanyId(Long sysCompanyId) {
        this.sysCompanyId = sysCompanyId;
    }

    public Long getSysBrandId() {
        return sysBrandId;
    }

    public void setSysBrandId(Long sysBrandId) {
        this.sysBrandId = sysBrandId;
    }
}
