package com.bizvane.appletservice.interfaces;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.models.bo.MktConvertCouponRecordBo;
import com.bizvane.appletservice.models.vo.*;
import com.bizvane.centerstageservice.models.po.WxPayConfigPo;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 积分商城
 *
 * @author gs
 * @date
 */
public interface IntegrationShopService {
    /**
     * 积分商城首页
     *
     * @param
     * @return
     **/
    ResponseData shopHomePage(String sysBrandId, String menberCode);

    ResponseData<ShopHomePageVo> getHomePageMemberInfo(String memberCode, Long sysBrandId);

    /**
     * 全部商品展示
     *
     * @param
     * @return
     **/
    ResponseData fullMerchandiseDisplay(AllMerchandiseVo allMerchandiseVo);

    /**
     * 商品详情
     *
     * @param
     * @return
     **/
    ResponseData commodityDetails(String hostId);

    /**
     * 分类商品入口
     *
     * @param
     * @return
     **/
    ResponseData classifiedGoods(classifiedGoodsVo classifiedGoodsVo);
    /**
     * 分类商品列表
     *
     * @param
     * @return
     **/
    ResponseData tailForClassifiedGoods(AllMerchandiseVo allMerchandiseVo);


    /**
     * 积分商城实物积分活动专题商品列表
     *
     * @param
     * @return
     **/
    ResponseData activitySubjectGoods(AllMerchandiseVo allMerchandiseVo);

    /**
     * 生成订单
     *
     * @param
     * @return
     **/
    ResponseData generateOrder(ConfirmGoodsVo confirmGoodsVo);


    /**
     * 生成订单
     *
     * @param
     * @return
     **/
    ResponseData generateOrderCheckLable(ConfirmGoodsVo confirmGoodsVo);

    /**
     * 效验订单生成
     *
     * @param
     * @return
     **/
    ResponseData inventoryStatus(ConfirmGoodsVo confirmGoodsVo);

    /**
     * 增加收货地址
     *
     * @param
     * @return
     **/
    ResponseData increaseReceivingAddress(UserAddressPutVo userAddressPutVo);

    /**
     * 编辑收货地址
     *
     * @param
     * @return
     **/
    ResponseData editReceivingAddress(UserAddressPutVo userAddressPutVo);

    /**
     * 删除收货地址
     *
     * @param
     * @return
     **/
    ResponseData eliminateReceivingAddress(UserAddressPutVo userAddressPutVo);

    /**
     * 地址查询
     *
     * @param
     * @return
     **/
    ResponseData  addressuery(String memberCode);

    /**
     * 订单列表
     *
     * @param
     * @param sysCompanyId
     * @return
     **/
    ResponseData<PageInfo<OrderVo>> fullOrderDisplay(Long sysCompanyId, String sysBrandId, String orderStatus, String memberCode, Integer pageNum, Integer pageSize);


    /**
     * (旧版)订单列表
     *
     * @param
     * @param sysCompanyId
     * @return
     **/
    ResponseData fullOrderDisplay(Long sysCompanyId, String sysBrandId, String orderStatus, String memberCode);

    /**
     * 查看订单
     *
     * @param
     * @return
     **/
    ResponseData viewOrder(String orderId);
    /**
     * 优惠券
     *
     * @param
     * @return
     **/
    ResponseData<PageInfo<MktConvertCouponRecordBo>> fullCouponDisplay(CouponRecordVO couponRecordVO);
    /**
     * 优惠券订单详情
     *
     * @param
     * @return
     **/
    ResponseData tailForFullCouponDisplay(Long convertCouponRecordId,String memberCode);


    /**
     * 获取积分
     *
     * @param
     * @return
     **/
    ResponseData integralAcquisition(String sysBrandId);

    /**
     * 门店自提
     *
     * @param
     * @return
     **/
    ResponseData storeSelfMention();
    /**
     * 物流公司列表
     *
     * @param
     * @return
     **/
    ResponseData logisticsCompanyGroup();
    /**
     * 查看物流
     *
     * @param
     * @return
     **/
    ResponseData displayLogistics(String companyCode,String num,String phone);

    /**
     * 申请退货提交
     *
     * @param
     * @return
     **/
    ResponseData applyeturnSubmission(ReturnGoodsVo returnGoodsVo);

    /**
     * 申请退货添加物流
     *
     * @param
     * @return
     **/
    ResponseData applyeturnNotSubmitted(RefundLogisticsVo refundLogisticsVo);
    /**
     * 获取退货说明
     *
     * @param
     * @return
     **/
    ResponseData instructions(String sysBrandId);

    /**
     * 获取基础配置
     * @param merchantId
     * @return
     */
    ResponseData getConfig(Integer merchantId) throws IOException;

    void setIntegralConfig2Redis(Map<String, Object> map, Integer merchantId) ;

    ResponseData getAllOrdersPages(int pageNum, int pageSize, Integer sysBrandId, String memberCode);

    /**
     * 支付
     * @param ordersId
     * @return
     */
    ResponseData  payment(Integer ordersId);

    /**
     * 支付券
     * @param convertCouponRecordId
     * @return
     */
    ResponseData  paymentWithCoupon(Integer convertCouponRecordId,String bizvaneSessionId);

    /**
     * 支付成功
     * @param convertCouponRecordId
     * @return
     */
    ResponseData  payCouponSuccess(Integer convertCouponRecordId);

    ResponseData getFeight(IntegralOrderFeightVO integralOrderFeightVO);

    ResponseData getIntegralClassifyQRCord(IntegralQRCodeRequestVO integralQRCodeRequestVO);
    /**
    * 获取首页轮播图,分类和券图
    * */
    ResponseData<ShopHomePageVo> getHomePageRotationChart(String sysBrandId, Long sysCompanyId,String memberCode);
    /**
     * 获取首页热门商品
     * */
    ResponseData<JSONObject> getHomePageHotCommodity(IntegralShopGetHomePageHotCommodityRequestVO requestVO);

    /**
     * 获取基础配置
     * @param merchantId
     * @return
     */
    WxPayConfigPo getPayConfig(Integer merchantId) ;

    List<MbrLevelModel> transformTwLevel(Long twCLubBrandId, List<MbrLevelModel> mbrLevelModelList);
}
