package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.AppletBtfBo;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.vo.AppletHomeMemberVo;
import com.bizvane.appletservice.models.vo.MemberBaseInfoVo;
import com.bizvane.appletservice.models.vo.MemberConsumptionInfoVo;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 会员中心
 *
 * @author gs
 */
public interface MemberCenterService {
    /**
     * 首页
     *
     * @param
     * @return
     */
    ResponseData<AppletBtfBo> getBtfRel(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request);

    /**
     * 首页轮播图
     * @param sysBrandId
     * @return
     */

    ResponseData<List<AppletResourcesPO>> getSlideImg(Long sysBrandId,HttpServletRequest request, HttpServletResponse response);

    /**
     * 首页模板样式
     * @param sysBrandId
     * @return
     */
    ResponseData<AppletBtfBo> getTemplateInfo(Long sysBrandId,HttpServletRequest request);

    ResponseData<AppletBtfBo> getHomePage(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request, HttpServletResponse response);

    /**
     * 获取会员基本信息
     * @param memberBaseInfoVo
     * @param request
     * @return
     */
    ResponseData<MemberBaseInfoVo> getMemberInfo(MemberBaseInfoVo memberBaseInfoVo, HttpServletRequest request);

    ResponseData processTraceForStore(String traceId, String memberCode, HttpServletRequest request);

    ResponseData<MemberConsumptionInfoVo> getConsumptionInfo(MemberResoucreBO memberResoucreBO);

    ResponseData<AppletHomeMemberVo> getMbrCardBasicInfo(MemberResoucreBO memberResoucreBO, Byte roundingMode, Integer appletVipPrivilegeVersion);
}
