package com.bizvane.appletservice.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zcc
 * @date 2021/9/23 15:30
 **/
@Data
public class MbrLevelBasicVo implements Serializable {

    /**
     * 等级id
     */
    @ApiModelProperty(value = "等级id",name = "mbrLevelId")
    private Long mbrLevelId;
    /**
     * 等级名
     */
    @ApiModelProperty(value = "等级名",name = "levelName")
    private String levelName;

    /**
     * 升级条件中-升级月数量
     */
    @ApiModelProperty(value = "升级条件中-升级月数量",name = "upMonthNum")
    private Integer upMonthNum;

    /**
     * 升级条件中-累计金额
     */
    @ApiModelProperty(value = "升级条件中-累计金额",name = "upGradeTotalmonetary")
    private BigDecimal upGradeTotalmonetary;

    /**
     * 升级条件中-单笔金额
     */
    @ApiModelProperty(value = "升级条件中-单笔金额",name = "upGradeSinglemonetary")
    private BigDecimal upGradeSinglemonetary;

    /**
     * 剩余升级累计金额
     */
    @ApiModelProperty(value = "剩余升级累计金额",name = "residueUpGradeTotalmonetary")
    private BigDecimal residueUpGradeTotalmonetary;

    /**
     * 会员累计消费金额
     */
    @ApiModelProperty(value = "会员累计消费金额",name = "mbrConsumeAllMoney")
    private BigDecimal mbrConsumeAllMoney;

    /**
     * 是否达到最高等级 0否 1 是
     */
    @ApiModelProperty(value = "是否达到最高等级 0否 1 是",name = "isHighestLevel")
    private Byte isHighestLevel = 0;

}
