package com.bizvane.appletservice.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class IntegralQRCodeRequestVO {
    @ApiModelProperty(
            value = "页面路径：必须是已经发布的小程序存在的页面（否则报错），例如 pages/index/index, 根路径前不要填加 /,不能携带参数（参数请放在scene字段里），如果不填写这个字段，默认跳主页面",
            name = "path",
            required = false,
            example = "pages/template01/coupon-scancode/main"
    )
    private String path;
    @ApiModelProperty(
            value = "参数：最大32个可见字符，只支持数字，大小写英文以及部分特殊字符：!#$&'()*+,/:;=?@-._~，其它字符请自行编码为合法字符（因不支持%，中文无法使用 urlencode 处理，请使用其他编码方式）",
            name = "scene",
            required = false
    )
    private String scene;

    @ApiModelProperty(
            value = "二维码宽度 默认：430px",
            name = "width",
            required = false
    )
    private Integer width;

    private Long sysBrandId;
}
