package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.bo.AppletLoginBo;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 会员信息
 *
 * @author gs
 */
public interface LoginService {

    /**
     * 根据BizsessionId获取memberCode
     * @param request
     * @return
     */
    String getMemberCode(HttpServletRequest request);

    /**
     * 根据BizsessionId获取memberCode
     * @return
     */
    String getMemberCode();

    /**
     * 获取登陆者的相关
     * @return
     */
    MemberResoucreBO getMemberResourceBO();

    /**
     * 登陆
     *
     * @param bo
     * @return
     */
    ResponseData<Map<String, Object>> login(AppletLoginBo bo);

    /**
     * 发送验证码
     *
     * @param phone
     * @return
     */
    ResponseData<Integer> sendVerificationCode(String phone, String sysBrandId);

    /**
     * 登录token 验证
     *
     * @param token
     * @return
     */
    ResponseData<Integer> loginToken(String token);

    /**
     * 中转接口
     *
     * @param
     * @return
     */
    ResponseData<AppletRefreshtoInterfaceBo> refreshtoInterface(String appId);

}
