package com.bizvane.appletservice.interfaces;



import com.bizvane.appletservice.models.*;

import java.util.List;


public interface UserService {
	
	//根据用户名查询个人信息
	public User queryByUserName(String userName);
	
	//根据验证码查询
    public Code queryByCodeNumber(Code code);
    
    //根据手机号码查询
  	public User queryByUserPhoneNumber(String userPhoneNumber);
  	
    //新增注册用户
  	public void addUserRegister(User user);
  	
    //新增权限
  	public void addUserRole(UserRole userRole);
  	
    //更新用户个人信息
  	public void updUserRegister(User user);
  	
    //根据用户Id进行查询
  	public User queryByUserId(Integer userId, Double lat, Double lnt);

  	//根据QQ唯一标识查询个人信息
	public User queryByUserQQ(String userQQ);

	//根据微信唯一标识查询个人信息
	public User queryByUserWechat(String userWechat);

	//新增一条验证码
    public void addSendCode(Code code);

    //定时清空CODE表数据库
    public void TRUNCATECODE();

	//找回密码
	public void updByUserPassword(User user);
    //搜索附近的人
	public List<User> queryLocalUser(Double minLat, Double minLng, Double maxLat, Double maxLng, Integer sex, Double lat, Double lng, Integer userId, Integer flag,
                                     Integer minAge, Integer maxAge);

	//首页搜索框查询用户信息
	public List<User> UserSearchBar(String userNikename);

	public void updUserLocation(User user);

	//个人资料变更
	public void updMyUser(User user);

	//查询印记信息
	public List<Imprint> queryImprint(Integer userId);

	//新增印记信息
	public void addImprint(Imprint imprint);

	//根据用户Id查询用户权限
	public UserRole queryUserRole(Integer userId);

	//绑定微信
	public void updByUserWechat(User user);

	//绑定QQ
	public void updByUserQQ(User user);

	//更新权限
	public void updUserRole(UserRole role);

	//绑定支付宝
	public void updByUserPayMent(User user);

	//查询用户总注册数
	public Integer queryUserCount();

	public List<User> queryAllUserCount(Integer start, Integer end);

	public List<User> queryUserFenYe(Integer userId, Integer start, Integer end, double latttud, double longitud);

	public List<User> queryFilterByMember(Integer userId, Integer start, Integer end, double latttud, double longitud);

	public List<User> queryFilterByMale(Integer userId, Integer start, Integer end, double latttud, double longitud, String userSex);

	//自定一附件人接口
	public List<User> SearchNearbyPeople(Integer userId, Integer start, Integer end, double latttud, double longitud, String userSex, String userAge, Integer lineFlag,
                                         String realeaseDate);

	public void delByuserId(Integer userId);

	public void updUserCount(User user);


	public void updUserStemar(User user);

	public void addUserStemar(User user);

	//新增不让谁看动态
	public void addNotDynamic(NotDynamic notDynamic);

	//查询不让谁看动态
	public NotDynamic queryNotDynamic(NotDynamic notDynamic);

	//删除不让谁看动态
	public void delNotDynamicId(Integer notDynamicId);

	//编辑用户信息
	public void updUserByCount(User user);

	public User queryByUserIdLike(User user);

	public void updByRedEnvelopePassWord(User user);

	public void updByWathSig(User user);

	public void updByTestUserQQ(User user);

	public User queryByUserTestOne(Integer userId);

	public void updMyByUserPicture(User user);

	public void updByUserOnline(User user);

    //根据用户Id进行查询
  	public List<User> queryNearbyDic(Integer userId, double lat, double lnt, String userSex);
  	
  	public List<User> queryByUserSexOne(Integer userId);
  	
  	public void addByLineFlag(User user);
  	
  	public void updByUserPhoneNumber(User user);
  	
  	public void updByUserJuli(User user);
  	
    public Integer queryByGiftReCordSD(Integer ReceiveGiftsId);
	
	public Integer queryByGiftReCordSC(Integer userId);
	
	public List<User> queryLineFlagCount(int lineFlag);

	public List<User> findAll();
	
	public int queryRoleId(int userId);
}
