package com.bizvane.appletservice.interfaces;



import com.bizvane.appletservice.models.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/***
 * 我的页面SERVICE
 * @author Administrator
 *
 */
public interface UserHomeService {
	
	    //查询收礼物信息
		public List<GiftRecord> queryGifRecord(Integer ReceiveGiftsId);
		
		//新增礼物信息
		public void addGifRecord(GiftRecord giftRecord);
		
		//查询礼物
		public List<Gift> queryGift(Integer start, Integer end);

		//新增收藏表情
		public void addExpression(Expression expression);

		//查询表情
		public List<Expression> queryExpression(Integer userId);

		//查询可提现礼物
		public List<GiftRecord> queryByGiftRecordSig(Integer ReceiveGiftsId);

		//查询可提现金额
		public Integer queryByGiftRecordThePrice(Integer ReceiveGiftsId);

		public Integer queryGiftRecordCount();

		public Integer queryGiftRecordThePriceCount();

		public void addGift(Gift gift);

		public void delGiftId(Integer giftId);

		public void updGift(Gift gift);

		public List<MemberCount> queryMemberCount();

		public void addMemberCount(MemberCount count);

		public void delMemberCount(Integer memberCountId);

		public void updMemberCount(MemberCount count);

		//查询单个表情
		public List<Expression> queryByExpression(Integer userId);

		public void updExpression(Expression expression);

		public int queryGiftCount();

		public List<CashTransactionRecord> queryRecordsOfConsumption(Integer start, Integer end);

		public int queryCountCashTransactionRecord();

		public List<CashTransactionRecord> queryByCashTransactionRecordUserId(double userId);

		//消费记录查询
		public List<CashTransactionRecord> queryPresentRecord(@Param("start") Integer start, @Param("end") Integer end, @Param("cashTransactionRecordType") String cashTransactionRecordType);

		public List<CashTransactionRecord> queryByPresentRecordUserId(CashTransactionRecord cashTransactionRecord);

		public int queryByPresentRecord();

		//查询拉黑信息
		public BlackList queryByBlackId(BlackList blackList);

		public double queryRechargeAmount(double userId);

		public double queryExpenditureAmount(double userId);

		public List<CashTransactionRecord> queryUserIdListCount(Integer userId);

		public List<CashTransactionRecord> queryUserIdListCountTwo(Integer userId);

		public List<CashTransactionRecord> queryListFastOne(CashTransactionRecord record);

		public List<Topic> queryTopicList(@Param("start") Integer start, @Param("end") Integer end);
		
		public void delByExpressionId(Integer expressionId);
		
		public Gift queryGiftName(String giftName);
		
		public Gift queryManGenterId(Integer giftId);
		
		public void delCasHtransaMangerId(Integer cashTransactionRecordId);
		
		public CashTransactionRecord quyerCashTransactionRecordOrde(String cashTransactionRecordOrde);
}
