package com.bizvane.appletservice.interfaces;


import com.bizvane.appletservice.models.*;

import java.util.List;

/***
 * 用户动态Service
 * @author Administrator
 *
 */
public interface UserDynamicService {
	
	    //查询每一个用户自己动态
		public List<Dynamic> queryDynamic(Integer userId);
		
		//根据话题推荐动态内容
		public List<Dynamic> queryByDynamicTopict(String dynamicTopict);
		
		//根据动态Id查询动态内容评价
		public List<Comment> queryComment(Integer dynamicId);
		
		//查询点赞信息
		public List<SpotfaBulous> querySpotfaBulous(Integer dynamicId);

		//首页搜索框查询动态表信息
		public List<Dynamic> DynamicSearchBar(String dynamicContent);

		//查询话题类型所有数据
		public List<Topic> queryTopic();

		//新增动态评价内容
		public void addComment(Comment comment);

		//新增用户动态信息
		public void addDynamic(Dynamic dynamic);

		//新增动态点赞信息
		public void addSpotfaBulous(SpotfaBulous spotfaBulous);

		//新增话题类型数据
		public void addTopic(Topic topic);

		//删除话题类型数据
        public void delTopic(Integer topicId);

        //更新话题类型数据
    	public void updTopic(Topic topic);

    	//根据用户Id查询所对应好友信息
    	public List<Friends> queryByfriendsId(Integer friendsId);

    	//新增好友关系
    	public void  addFriends(Friends friends);

    	//查询用户所关注信息
    	public List<Follow> queryFollowByFollowId(Integer followId);

    	//查询用户粉丝信息
    	public List<Follow> queryFollowByUserId(Integer userId);

    	//查询单个点赞信息
    	public SpotfaBulous queryOneSpotfaBulous(SpotfaBulous spotfaBulous);

    	//取消点赞信息
    	public void delDynamic(Integer spotfaBulousId);

    	//根据动态ID查询动态详情
    	public Dynamic queryByDynamicId(Integer dynamicId);

    	//查询单个用户关注信息
    	public Follow queryByfwSig(Follow follow);

    	//新增关注信息
    	public void addFollow(Follow follow);

    	//伪删除关注信息
    	public void updFollow(Follow follow);

    	//查询另外一个用户是否关注他
//    	public Follow queryFollowByUserId(Follow follow);

    	//新增动态评论点赞
    	public void addCommentSpotfaBulous(CommentSpotfaBulous commentSpotfaBulous);

    	//删除动态评论点赞信息
        public void delBycommentSpotfaBufousId(CommentSpotfaBulous commentSpotfaBulous);

        //查询动态评论点赞信息
    	public List<CommentSpotfaBulous> queryCommentSpotfaBulous(Integer commentId);

    	//查询评论点赞记录
    	public CommentSpotfaBulous queryOneCommentSpotfaBulous(CommentSpotfaBulous commentSpotfaBulous);

    	//取消关注接口
    	public void CancelFollow(Integer fwId);

        //查询好友关系信息
    	public Friends queryFriends(Friends friends);

    	//删除好友关系接口
    	public void  delFriends(Integer fwId);

    	public List<Dynamic> queryDynamicCount(Integer start, Integer end);

        public void delByDynamicId(Integer dynamicId);

        public int queryDynamicCountNumber();

        public void addBydynamicVideo(Dynamic dynamic);

        public List<Follow> queryFowllerBySig(Integer followId);

        public void updByFriendsName(Friends friends);

        public void updByFollowName(Follow follow);

    	public void updByFansName(Follow follow);

    	public List<Dynamic> queryDynamicByPeng(Integer userId);

    	public void updByDynamicSate(Dynamic dynamic);

    	public List<Dynamic> queryByDynamicOrant(Dynamic dynamic);

    	public List<Dynamic> queryDynamicFenYe(Integer userId, Integer start, Integer end);

    	public List<Dynamic> queryMyDynamicCount(Integer userId, Integer start, Integer end);
    	
    	public int queryMyRastTwoCount(Integer userId);
 
}
