package com.bizvane.appletservice.interfaces;


import com.bizvane.appletservice.models.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface PayMentService {
	
	        //新增黑名单
			public void addBlackList(BlackList blackList);
			
			//移除黑名单
			public void delBkltId(Integer bkltId);
			
			//查询车辆信息
			public List<Vehicle> queryVehicle(Integer userId);
			
			//新增车辆信息
			public void addVehicle(Vehicle vehicle);

			//删除车辆信息
			public void delVehicle(Integer vehicleId);

			//开通会员
			public void addMember(Member member);

			//查询会员信息
			public Member queryMember(Integer userId);

			//查询金额信息
			public Amount queryAmount(Integer userId);

			//更新金额
			public void updAmount(Amount amount);

			//新增用户现金交易记录
			public void addCashTransactionRecord(CashTransactionRecord record);

			//新增圈币金额信息
			public void addCircleCoin(CircleCoin circleCoin);

			//查询圈币金额信息
			public CircleCoin queryCircleCoin(Integer userId);

			//查询本月体现记录总金额
			public int queryAmountCount(Integer ReceiveGiftsId);

			//更新圈币金额信息
	        public void updCircleCoin(CircleCoin circleCoin);

	        //新增圈币交易记录信息
	    	public void addCircleCoinTransaction(CircleCoinTransaction transaction);

	    	//查询圈币交易记录信息
	    	public List<CircleCoinTransaction> queryCircleCoinTransaction(Integer userId);

	    	//查询本月收入和支出圈币余额总数
	    //	public CircleCoinTransaction queryByCircleCoinTransactionCount(String circleCoinTransactionDate,Integer userId,String circleCoinTransactionTypeCount);

	    	//新增访问信息
	    	public void addDataVisitor(DataVisitor dataVisitor);

	    	//查询是否添加访问信息
	    	public DataVisitor queryDataVisitor(DataVisitor dataVisitor);

	    	//查询被访问用户ID
	    	public List<DataVisitor> queryDataVisitorList(Integer dataVisitorId);

	    	//查询黑名单管理
	    	public List<BlackList> queryBlackList(Integer userId);

            public Integer querCountMember();

            public Integer queryCountAmount();

            public List<CashTransactionRecord> queryCashTransactionRecordCount();

        	public List<CashTransactionRecord> queryByCashTransactionRecordTyep();

        	//根据开发者AppId查询公钥、私钥、签名接口
        	public RasType queryRasType(String rasAppId);

        	//查询收入
        	public Integer queryCircleRechargeAmount(Integer userId);

        	//查询支出
        	public Integer queryCircleExpenditureAmount(Integer userId);

        	//新增金额信息
        	public void addAmount(Amount amount);

        	//查询可提现金额
        	public Integer queryByGiftRecordThePrice(Integer userId);

        	//更新体现礼物记录
        	public void updByGiftRecordId(Integer userId);

        	public Integer queryAmountRecThe(Integer userId);

        	public List<GiftRecord> queryGiftTheachAmount(Integer userId);

        	public List<GiftRecord> queryListType(Integer userId);

        	//新增消息免打扰
        	public void addDoNotDisturb(DoNotDisturb disturb);

        	//查询消息免打扰
        	public DoNotDisturb queryDoNotDisturb(DoNotDisturb disturb);

        	public void delDoNotDisturbId(DoNotDisturb doNotDisturbId);

        	public void delByMemberEndDate(String memberEndDate);

        	public void delByDvtId(Integer dvtId);

        	//续费会员
        	public void updByMemberId(Member member);

    		public List<CashTransactionRecord> queryManagementConsumption(@Param("start") Integer start, @Param("end") Integer end);

    		public void delBySupperId(DataVisitor dataVisitor);

    		public CashTransactionRecord queryManageCashTransactionRecord(CashTransactionRecord cashTransactionRecord);

    		public List<CashTransactionRecord> queryManagementPutForward(@Param("start") Integer start, @Param("end") Integer end, @Param("userId") Integer userId);
    		
    		public void updDvtId(DataVisitor dataVisitor);
    		
    		public void delBydataVisitorId(Integer dataVisitorId);
}
