package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface GroupService {

	        //新增群
			public void addGroup(Group group);
			
			//删除群
			public void delGroupId(String groupId);
			
			//查询群号
			public Group queryByGroupNumber(String groupNumber);
			
			//根据用户Id查询群Id
	    	public Group queryByUserId(Integer userId);
	    	
	    	//新增群人数
	    	public void addUserGroup(UserGroup group);
	    	
	    	//删除群人数
	    	public void delUserGroup(UserGroup group);
	    	
	    	//查询群人信息
	    	public List<UserGroup> queryUserGroup(String groupId);
	    	
	    	//编辑群资料
	    	public void updGroup(Group group);
	    	
	    	//修改群呢称
	    	public void updGroupName(Group group);
	    		
	    	//转让群
	    	public void TransferGroup(Group group);
	    	
	    	//根据用户Id查询加入群Id
	    	public List<UserGroup> queryByUserGroupId(UserGroup userGroup);
	    	
	    	//根据群Id查询群资料
	    	public Group queryByGroupId(String groupId);
	    	
	    	//修改群呢称
	    	public void updUserGroupName(UserGroup group);
	    	
	    	//新增群管理员
	    	public void addGroupAdminSig(UserGroup userGroup);
	    	
	    	//根据用户Id查询群Id
	    	public List<Group> queryCreateGroup(Integer userId);
	    	
	    	//根据群类型查询群信息
	    	public List<Group> queryByGroupType(String groupType);
	    	
	    	// 更新群人数
	    	public void updByGroupMemberNumber(Group group);
	    	
	    	//根据GROUPID进行查询群人员信息
	    	public List<UserGroup> queryUserGroupById(String groupId);
	    	
	    	//根据群号以及账号查询信息
	    	public Group queryGroupByIdOrNumber(Group group);
	    	
	    	//编辑群公告
	    	public void addGroupAnnouncement(GroupAnnouncement announcement);

	    	//修改群公告
	    	public void updGroupAnnouncement(GroupAnnouncement announcement);
	    	
	    	//删除群公告
	    	public void delGroupAnnouncementId(Integer GroupAnnouncementId);
	    	
	    	//查询群公告
	    	public List<GroupAnnouncement> queryGroupAnnouncement(String groupId);
	    	
	    	//退出群聊
	    	public void SignOutGroup(Integer userGroupId);
	    	
	    	public List<Group> queryByGroupCount(@Param("start") Integer start, @Param("end") Integer end);

	    	public List<Group> queryByGroupNameOrId(Group group);

	    	public int querByCOuntGroupId();

	    	//新增群隐身接口
	    	public void addByGroupStealth(Group group);

	    	//修改群隐身接口
	    	public void updByGroupStealth(Group group);

	    	public void updByAdiminSig(UserGroup group);

	    	public void updGroupSig(Group group);

	    	public Group queryGroupByUserId(String groupId);

	    	public List<Group> queryByGroupTypeOne(String groupType);

	    	public List<Group> queryByGroupAll(@Param("start") Integer start, @Param("end") Integer end);
	    	
	    	public GroupAnnouncement queryByGroupOneId(GroupAnnouncement announcement);
	    	
	    	//查询群公告详情
	    	public GroupAnnouncement queryByGroupAnnouncementId(Integer GroupAnnouncementId);
	    	
	    	public UserGroup queryUserGroupIdOne(UserGroup userGroup);
	    	
	    	//新增評論
	    	public void addAnnouncementCommt(AnnouncementCommt announcementCommt);
	    	
	    	//查詢評論
	    	public List<AnnouncementCommt> queryAnnouncementCommt(Integer GroupAnnouncementId);
	    	
	    	//查詢點贊
	    	public List<AnnouncementSpotfaBulous> querAnnouncementSpotfaBulous(Integer GroupAnnouncementId);
	    	
	    	//新增點贊
	    	public void addAnnouncementSpotfaBulous(AnnouncementSpotfaBulous announcementSpotfaBulous);
	    	
	    	//刪除點贊
	    	public void delAnnouncementSpotfaBulous(AnnouncementSpotfaBulous announcementSpotfaBulous);
	    	
	    	//查詢詳情
	    	public AnnouncementSpotfaBulous queryAnnouncementSpotfaBulousCount(AnnouncementSpotfaBulous announcementSpotfaBulous);
	    	
	    	//刪除
	    	public void delAnnouncementCommt(AnnouncementCommt announcementCommt);
	    	
	    	public void updGroupStart(Group group);
	    	
	    	public void updGroupQrCode(Group group);
	    	
	    	public void updGroupPrivate(Group group);
	    	
	    	public int queryCountNotPrivate();
}
