package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.bo.AppletLoginBo;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.Map;

/**
 * 会员信息
 * @author gs
 */
public interface LoginService {
    /**
     * 登陆
     *
     * @param bo
     * @return
     * */
    ResponseData<Map<String, Object>> login(AppletLoginBo bo);

    /**
     * 发送验证码
     *
     * @param phone
     * @return
     * */
    ResponseData<Integer> sendVerificationCode(String phone);
    /**
     * 登录token 验证
     *
     * @param token
     * @return
     * */
    ResponseData<Integer> loginToken(String token);
    /**
     * 中转接口
     *
     * @param
     * @return
     * */
    ResponseData<AppletRefreshtoInterfaceBo> refreshtoInterface(String appId);

}
