package com.bizvane.appletservice.models.bo;

import com.bizvane.appletservice.models.po.AppletVipPrivilegePO;
import com.bizvane.appletservice.models.vo.vg.VGClubMemberCardLevelResponseVO;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class AppletCardLevelPrivLegeBo implements Serializable {
    private static final long serialVersionUID = -7781874198944293766L;
    @ApiModelProperty(
            value = "微信头像",
            name = "wxHeadPortraits",
            example = "微信头像"
    )
    private String wxHeadPortraits;
    @ApiModelProperty(
            value = "微信昵称",
            name = "wxNick",
            example = "微信昵称"
    )
    private String wxNick;
    @ApiModelProperty(
            value = "会员可用积分",
            name = "countIntegral",
            example = "会员可用积分"
    )
    private String countIntegral;
    @ApiModelProperty(
            value = "会员卡等级名",
            name = "levelName",
            example = "会员卡等级名"
    )
    private String levelName;
    @ApiModelProperty(
            value = "会员等级id",
            name = "levelId",
            example = "会员等级id"
    )
    private Long levelId;
    @ApiModelProperty(
            value = "会员卡条形码",
            name = "barCode",
            example = "会员卡条形码"
    )
    private String barCode;
    @ApiModelProperty(
            value = "线上卡号",
            name = "cardNo",
            example = "线上卡号"
    )
    private String cardNo;
    @ApiModelProperty(
            value = "线下卡号",
            name = "offlineCardNo",
            example = "线下卡号"
    )
    private String offlineCardNo;
    @ApiModelProperty(
            value = "会员卡折扣",
            name = "memberDiscount",
            example = "会员卡折扣"
    )
    private String memberDiscount;
    @ApiModelProperty(
            value = "会员卡折上折",
            name = "additionalDiscount",
            example = "会员卡折上折"
    )

    //累计总积分
    private String additionalDiscount;

    //会员卡样式
    private String cardStyle;
    private String instructions;
    private Boolean isImg;
    private List<AppletVipPrivilegePO> appletVipPrivilegePOList;
    private Integer discountMethod;


    //会员等级是否支持升级，即前端百分比进度条是否显示
    private Boolean levelUpJudge;
    //会员等级到下级百分比
    private BigDecimal levelUpRate;
    //vg会员百分比列表
    private List<VGClubMemberCardLevelResponseVO> rateList;
    //vg 会员到期时间 ,如果为空，则该会员等级的keepLevelTime为空或者会员，认为该会员等级没有时效
    private Date keepLevelTime;
    //当前等级升级时间
    private Date levelUpTime;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getWxHeadPortraits() {
        return wxHeadPortraits;
    }

    public void setWxHeadPortraits(String wxHeadPortraits) {
        this.wxHeadPortraits = wxHeadPortraits;
    }

    public String getWxNick() {
        return wxNick;
    }

    public void setWxNick(String wxNick) {
        this.wxNick = wxNick;
    }

    public String getCountIntegral() {
        return countIntegral;
    }

    public void setCountIntegral(String countIntegral) {
        this.countIntegral = countIntegral;
    }

    public String getLevelName() {
        return levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public Long getLevelId() {
        return levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getOfflineCardNo() {
        return offlineCardNo;
    }

    public void setOfflineCardNo(String offlineCardNo) {
        this.offlineCardNo = offlineCardNo;
    }

    public String getMemberDiscount() {
        return memberDiscount;
    }

    public void setMemberDiscount(String memberDiscount) {
        this.memberDiscount = memberDiscount;
    }

    public String getAdditionalDiscount() {
        return additionalDiscount;
    }

    public void setAdditionalDiscount(String additionalDiscount) {
        this.additionalDiscount = additionalDiscount;
    }

    public String getCardStyle() {
        return cardStyle;
    }

    public void setCardStyle(String cardStyle) {
        this.cardStyle = cardStyle;
    }

    public List<AppletVipPrivilegePO> getAppletVipPrivilegePOList() {
        return appletVipPrivilegePOList;
    }

    public void setAppletVipPrivilegePOList(List<AppletVipPrivilegePO> appletVipPrivilegePOList) {
        this.appletVipPrivilegePOList = appletVipPrivilegePOList;
    }

    public String getInstructions() {
        return instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public Boolean getImg() {
        return isImg;
    }

    public void setImg(Boolean img) {
        isImg = img;
    }

    public Integer getDiscountMethod() {
        return discountMethod;
    }

    public void setDiscountMethod(Integer discountMethod) {
        this.discountMethod = discountMethod;
    }

    public Boolean getLevelUpJudge() {
        return levelUpJudge;
    }

    public void setLevelUpJudge(Boolean levelUpJudge) {
        this.levelUpJudge = levelUpJudge;
    }

    public List<VGClubMemberCardLevelResponseVO> getRateList() {
        return rateList;
    }

    public void setRateList(List<VGClubMemberCardLevelResponseVO> rateList) {
        this.rateList = rateList;
    }

    public Date getKeepLevelTime() {
        return keepLevelTime;
    }

    public void setKeepLevelTime(Date keepLevelTime) {
        this.keepLevelTime = keepLevelTime;
    }

    public BigDecimal getLevelUpRate() {
        return levelUpRate;
    }

    public void setLevelUpRate(BigDecimal levelUpRate) {
        this.levelUpRate = levelUpRate;
    }

    public Date getLevelUpTime() {
        return levelUpTime;
    }

    public void setLevelUpTime(Date levelUpTime) {
        this.levelUpTime = levelUpTime;
    }
}
