package com.bizvane.appletservice.rpc.vg;


import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletservice.models.po.AppletVipPrivilegePO;
import com.bizvane.mktcenterservice.models.vo.RedPacketSocketVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;
import java.util.Map;

@FeignClient(value = "${feign.client.applet.name}", path = "${feign.client.applet.path}/memberShipCardServiceRpc")
public interface MemberShipCardServiceRpc {
    /**
     * @param levelIdList
     * @return Map
     * @description 通过等级id列表返回等级id相关信息 openApi使用
     */
    @PostMapping("/getMemberShipCardMapByLevelIdList")
    Map<Long, AppletVipCartPO> getMemberShipCardByLevelId(@RequestBody List<Long> levelIdList);

    /**
     * @author Ngp
     * @date 2021/8/6
     * @description 通过卡id批量查询会员权益
     **/

    @PostMapping("/getVipPrivilegeListByCardIdList")
    Map<Long,List<AppletVipPrivilegePO>> getVipPrivilegeListByCardIdList(@RequestBody List<Long> cardIdList);
    /**
     * @author Ngp
     * @date 2021/8/6
     * @description 清除redis缓存
     **/
    @GetMapping("/clearVipPrivilegeListRedis")
    void clearVipPrivilegeListRedis(@RequestParam Long cardId);
}
