package com.bizvane.appletservice.rpc.vg;


import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.mktcenterservice.models.vo.RedPacketSocketVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.io.IOException;
import java.util.List;
import java.util.Map;

@FeignClient(value = "${feign.client.applet.name}", path = "${feign.client.applet.path}/memberShipCardServiceRpc")
public interface MemberShipCardServiceRpc {
    /**
     * @param levelIdList
     * @return Map
     * @description 通过等级id列表返回等级id相关信息 openApi使用
     */
    @PostMapping("/getMemberShipCardMapByLevelIdList")
    Map<Long, AppletVipCartPO> getMemberShipCardByLevelId(@RequestBody List<Long> levelIdList);
}
