package com.bizvane.appletservice.models.vo.questionnaire;

import com.bizvane.customized.facade.models.vo.questionnaire.SurveyQuestionnaireVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author yuantq
 * @date 2023/8/24
 */
@Data
public class QuestionnaireEvaluateRequestVO {

    private String orderNo;

    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    //订单时间
    private Date orderTime;

    private Long mktTaskId;

    private String templateCode;

    private String templateName;
    //导购ID
    private Integer guideId;
    //店铺名称
    private String storeName;
    //问卷提交类型：1.订单问卷，2.调查问卷任务，3.调查问卷模板
    private Integer questionnaireType;
    //1-微信 2-支付宝
    private Integer sourceType;
    //问卷答题明细
    private SurveyQuestionnaireVO surveyQuestionnaireVO;

}
