package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.bo.AppletVipCardBo;
import com.bizvane.appletservice.models.po.AppletVipPrivilegePO;
import com.bizvane.appletservice.models.vo.AppletBrandPrivilegeConfigVO;
import com.bizvane.appletservice.models.vo.AppletBrandVipPrivilegeVO;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * 会员特权
 *
 * @author gs
 */
public interface MemberPrivilegeService {
    /**
     * 获取品牌下的会员卡特权信息
     *
     * @param sysBrandId
     * @param appletVipPrivilegeVersion  小程序会员卡特权配置版本 默认 com.bizvane.appletserviceimpl.constant.Constant#APPLET_VIP_PRIVILEGE_VERSION_1
     * @return
     */
    ResponseData<List<AppletVipCardBo>> getMemberPrivilege(Byte roundingMode, Long sysBrandId, Integer appletVipPrivilegeVersion);
    /**
     * 根据等级 id 获取相对特权信息
     *
     * @param appletVipCardId
     * @return
     */
    @Deprecated
    ResponseData<List<AppletVipPrivilegePO>> getMemberPrivilegebyGrder(Long appletVipCardId);
    /**
     * 查看会员卡特权详情
     *
     * @param appletVipPrivilegeId
     * @return
     */
    @Deprecated
    ResponseData<List<AppletVipPrivilegePO>> getMemberPrivilegeAll(Long appletVipPrivilegeId);

    /**
     * 根据等级 id 获取相对特权信息
     *
     * @param sysBrandId
     * @param appletVipCardId
     * @param gradeId
     * @param version
     * @return
     */
    ResponseData<List<AppletBrandVipPrivilegeVO>> getMemberPrivilegebyGrderNew(Long sysBrandId, Long appletVipCardId, Long gradeId, Integer version);

    /**
     * 查看会员卡特权详情
     *
     * @param sysBrandId
     * @param appletVipPrivilegeId
     * @param version
     * @return
     */
    ResponseData<List<AppletBrandVipPrivilegeVO>> getMemberPrivilegeAllNew(Long sysBrandId, Long appletVipPrivilegeId, Integer version);

    /**
     * 查看会员卡特权列表新
     * @param sysBrandId
     * @return
     */
    ResponseData<List<AppletBrandPrivilegeConfigVO>> getMemberPrivilegeAllConfigList(Long sysBrandId);
}
