package com.bizvane.appletservice.rpc;

import com.bizvane.appletservice.models.bo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @ClassName CreateMembersCardServiceRpc
 * @DescriptTion :
 * @Auther: wd
 * @Date :2018/12/26 16:45
 */
@FeignClient(value = "${feign.client.applet.name}", path = "${feign.client.applet.path}/membersCard")
public interface CreateMembersCardServiceRpc {
    /**
     * 创建会员卡
     * @param createMembersCardBO
     * @return
     */
    @ApiOperation(value = "创建会员卡")
    @PostMapping("/createMembersCard")
    ResponseData<String> createMembersCard(CreateMembersCardBO createMembersCardBO);

    /**
     * 接口激活
     * @param wxInterfaceActivateBO
     * @return
     */
    @ApiOperation(value = "激活会员卡")
    @PostMapping("/interfaceActivate")
    ResponseData<String> interfaceActivate(WxInterfaceActivateBO wxInterfaceActivateBO);

    /**
     * 更新会员卡
     * @param updateMembersCardBO
     * @return
     */
    @ApiOperation(value = "更新会员卡")
    @PostMapping("/updateMembersCard")
    ResponseData<String> updateMembersCard(UpdateMembersCardBO updateMembersCardBO);

    /**
     * 生成二维码
     * @param generateQrCode
     * @return
     */
    @ApiOperation(value = "生成二维码")
    @PostMapping("/generateQrCode")
    ResponseData<String> generateQrCode(GenerateQrCode generateQrCode);

    /**
     * 更新会员积分
     * @param updateMemberInfo
     * @return
     */
    @ApiOperation(value = "更新会员积分")
    @PostMapping("/updateMemberIntegral")
    ResponseData<String> updateMemberIntegral(UpdateMemberInfo updateMemberInfo);

    String callback(HttpServletRequest req, HttpServletResponse res);
}
