/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.search.domain.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.bizvane.members.feign.model.vo.MbrMembersVO;
import com.bizvane.search.domain.model.entity.SysTaskPO;
import com.bizvane.search.domain.service.IExecuteSearchService;
import com.bizvane.search.domain.service.ISearchDomainService;
import com.bizvane.search.domain.service.ISqlVerificationService;
import com.bizvane.search.domain.service.ISysTaskService;
import com.bizvane.search.feign.model.BO.SearchParam;
import com.bizvane.utils.responseinfo.ResponseData;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SearchDomainServiceImpl
implements ISearchDomainService {
    private static final Logger log = LoggerFactory.getLogger(SearchDomainServiceImpl.class);
    @Autowired
    private ISqlVerificationService iSqlVerificationService;
    @Autowired
    private IExecuteSearchService executeSearchService;
    @Autowired
    private ISysTaskService sysTaskService;
    private static int maxRetries = 3;
    private static final int taskSuccess = 3;
    private static String cursor = "  temp_table  ";

    @Override
    public void initiateFirstGroupSearch(SearchParam param) {
        SysTaskPO insertTaskPO = new SysTaskPO();
        insertTaskPO.setTaskCode(param.getQueryBatchCode());
        insertTaskPO.setTaskType(3);
        insertTaskPO.setTaskName("\u5206\u7ec4\u67e5\u8be2");
        insertTaskPO.setStatus(1);
        insertTaskPO.setTaskCode(param.getUserCode());
        insertTaskPO.setCreateUserName(param.getUserName());
        insertTaskPO.setRemark("\u5206\u7ec4\u67e5\u8be2");
        insertTaskPO.setValid(true);
        this.sysTaskService.insertTask(insertTaskPO);
        this.asyncWriteTempTable(param);
    }

    @Override
    public ResponseData<List<MbrMembersVO>> executePagedSearch(SearchParam param) {
        int retryCount;
        log.info("executePagedSearch\uff1a{}", (Object)param);
        String executeSQL = param.getExecuteSQL().toLowerCase();
        ArrayList<MbrMembersVO> members = new ArrayList<MbrMembersVO>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String searchDay = dateFormat.format(new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String yesterday = dateFormat.format(calendar.getTime());
        long startTime = 0L;
        long endTime = 0L;
        executeSQL = this.buildSearchSql(executeSQL, searchDay, yesterday, param.getQueryBatchCode());
        if (param.getIsPaging().booleanValue()) {
            executeSQL = executeSQL + " and mbr_member_id > " + param.getLastMaxID() + " order by mbr_member_id asc   limit " + param.getPageNum() + " , " + param.getPageSize();
        }
        JSONArray results = new JSONArray();
        for (retryCount = 0; retryCount < maxRetries; ++retryCount) {
            try {
                startTime = System.currentTimeMillis();
                results = this.executeSearchService.executeSearch(executeSQL);
                endTime = System.currentTimeMillis();
                if (results != null) {
                    log.info("SQL\u67e5\u8be2\u7edf\u8ba1\u6761\u6570\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)(endTime - startTime));
                    break;
                }
                log.info("SQL\uff1a{} \u67e5\u8be2\u8fd4\u56de\u7a7a\u7ed3\u679c\u96c6", (Object)executeSQL);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u5931\u8d25\uff0c\u5c06\u57282\u79d2\u540e\u91cd\u8bd5");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    log.error("\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38: {}", (Object)ex.getMessage());
                }
            }
            break;
        }
        if (retryCount >= maxRetries) {
            log.error("sql\u67e5\u8be2\u5931\u8d25\uff0c\u5df2\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570: {}", (Object)executeSQL);
            return new ResponseData(-1, "sql\u67e5\u8be2\u5931\u8d25\uff0c\u5df2\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570");
        }
        for (int i = 0; i < results.size(); ++i) {
            Map map = results.getJSONObject(i).getInnerMap();
            MbrMembersVO mbrMembersVO = new MbrMembersVO();
            BeanUtils.copyProperties((Object)map, (Object)mbrMembersVO);
            members.add(mbrMembersVO);
        }
        return new ResponseData(members);
    }

    @Async
    public void asyncWriteTempTable(SearchParam param) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String searchDay = dateFormat.format(new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String yesterday = dateFormat.format(calendar.getTime());
        long startTime = 0L;
        long endTime = 0L;
        SysTaskPO updateTaskStartPO = new SysTaskPO();
        updateTaskStartPO.setTaskCode(param.getQueryBatchCode());
        updateTaskStartPO.setTaskType(3);
        updateTaskStartPO.setStartTime(LocalDateTime.now());
        this.sysTaskService.updateTask(updateTaskStartPO);
        StringBuilder insertSql = new StringBuilder("insert into ").append(cursor).append(param.getExecuteSQL().toLowerCase());
        insertSql.insert(insertSql.indexOf("select") + 6, "  " + searchDay + " , " + param.getQueryBatchCode() + " , ");
        log.info("SQL\u6267\u884cinsert\u8bed\u53e5\uff1a{}", (Object)insertSql);
        boolean result = false;
        int retryCount = 0;
        int rowsAffected = 0;
        while (!result && retryCount < maxRetries) {
            try {
                rowsAffected = this.executeSearchService.execInsert(insertSql.toString());
                result = true;
            }
            catch (Exception e) {
                result = false;
                log.error("\u6267\u884c\u63d2\u5165\u64cd\u4f5c\u65f6\u53d1\u751f\u5f02\u5e38: {}", (Object)e.getMessage());
            }
            if (result) continue;
            ++retryCount;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                log.error("\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38: {}", (Object)ex.getMessage());
            }
        }
        SysTaskPO updateTaskEndPO = new SysTaskPO();
        updateTaskEndPO.setTaskCode(param.getQueryBatchCode());
        updateTaskEndPO.setEndTime(LocalDateTime.now());
        updateTaskEndPO.setTotalRows(Long.valueOf(rowsAffected));
        updateTaskEndPO.setStatus(result ? 3 : 0);
        this.sysTaskService.updateTask(updateTaskEndPO);
    }

    public String buildSearchSql(String execSql, String searchDay, String yesterday, String queryBatchID) {
        return execSql.replaceAll("(\\w+\\.)", "").substring(0, execSql.indexOf("from") + 4) + cursor + "  where   search_day in  ('" + searchDay + "' ,'" + yesterday + "') and query_batch_id = '" + queryBatchID + "'";
    }
}

