/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.search.api.service;

import com.bizvane.members.feign.model.vo.MbrMembersVO;
import com.bizvane.search.domain.model.entity.SysTaskPO;
import com.bizvane.search.domain.service.IExecuteSearchService;
import com.bizvane.search.domain.service.ISearchDomainService;
import com.bizvane.search.domain.service.ISqlVerificationService;
import com.bizvane.search.domain.service.ISysTaskService;
import com.bizvane.search.feign.model.BO.SearchParam;
import com.bizvane.search.feign.model.BO.downgradeParam;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchService {
    private static final Logger log = LoggerFactory.getLogger(SearchService.class);
    @Autowired
    private ISqlVerificationService iSqlVerificationService;
    @Autowired
    private IExecuteSearchService executeSearchService;
    @Autowired
    private ISysTaskService sysTaskService;
    @Autowired
    private ISearchDomainService searchDomainService;
    private static int maxRetries = 3;
    private static final int taskSuccess = 3;
    private static String cursor = "  temp_table  ";

    public ResponseData<List<MbrMembersVO>> groupSearch(SearchParam param) {
        SysTaskPO taskData;
        log.info("groupSearch\uff1a{}", (Object)param);
        if (!this.iSqlVerificationService.sqlVerification(param.getExecuteSQL().toLowerCase())) {
            log.error("SQL\u9a8c\u8bc1\u5931\u8d25\uff0cSQL\u4e0d\u7b26\u5408\u89c4\u8303");
        }
        if ((taskData = this.sysTaskService.getGroupTaskStatus(param.getQueryBatchCode())) == null) {
            log.info("\u7b2c\u4e00\u6b21\u6267\u884c\u5206\u7ec4\u641c\u7d22\u4efb\u52a1\uff1a{} ", (Object)param);
            this.searchDomainService.initiateFirstGroupSearch(param);
            return new ResponseData(-1, "\u4efb\u52a1\u5df2\u63d0\u4ea4\u6267\u884c");
        }
        if (taskData.getStatus() == 0) {
            log.info("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{}", (Object)param);
            return new ResponseData(-1, "\u4efb\u52a1\u6267\u884c\u5931\u8d25");
        }
        if (taskData.getStatus() == 1 || taskData.getStatus() == 2) {
            log.info("\u4efb\u52a1\u6267\u884c\u4e2d\uff1a{}", (Object)param);
            return new ResponseData(-1, "\u4efb\u52a1\u6267\u884c\u4e2d");
        }
        if (taskData.getStatus() == 3) {
            return this.searchDomainService.executePagedSearch(param);
        }
        return new ResponseData(-1, "\u4efb\u52a1\u67e5\u8be2\u5f02\u5e38");
    }

    public ResponseData<Boolean> downgradeSearch(downgradeParam param) {
        this.searchDomainService.downgradeSearch(param);
        return new ResponseData(0, "\u6682\u65e0\u4efb\u52a1");
    }
}

