/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.search.api.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.search.domain.service.IExecuteSearchService;
import com.bizvane.search.domain.service.ISysTemplateSqlService;
import com.bizvane.search.feign.model.BO.ReportParam;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportService.class);
    @Autowired
    private ISysTemplateSqlService iSysTemplateSqlService;
    @Autowired
    private IExecuteSearchService executeSearchService;

    public ResponseData<JSONArray> reportSearch(ReportParam param) {
        log.info("reportSearch param:{}", (Object)param);
        String reportCode = param.getReportCode();
        if (reportCode == null || reportCode.isEmpty()) {
            log.info("reportCode is null or empty");
            return null;
        }
        String reportSql = this.iSysTemplateSqlService.getReportSql(reportCode).getSql();
        JSONObject dataJson = JSONObject.parseObject((String)param.getDataJSON());
        String replacedSql = ReportService.replaceSqlParameters((String)reportSql, (JSONObject)dataJson);
        JSONArray results = this.executeSearchService.executeSearch(replacedSql);
        return new ResponseData((Object)results);
    }

    private static String replaceSqlParameters(String sql, JSONObject params) {
        for (String key : params.keySet()) {
            sql = sql.replace("{" + key + "}", "'" + params.getString(key) + "'");
        }
        return sql;
    }
}

