/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.elasticsearch.entity.ESIndice;
import org.frameworkset.elasticsearch.entity.IndexField;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.util.ClassUtil;

public abstract class BuildTool {
    public static ESIndice buildESIndice(String line, SimpleDateFormat format) {
        StringBuilder token = new StringBuilder();
        ESIndice esIndice = new ESIndice();
        int k = 0;
        block12: for (int j = 0; j < line.length(); ++j) {
            char c = line.charAt(j);
            if (c != ' ') {
                token.append(c);
                continue;
            }
            if (token.length() == 0) continue;
            switch (k) {
                case 0: {
                    esIndice.setHealth(token.toString());
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 1: {
                    esIndice.setStatus(token.toString());
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 2: {
                    esIndice.setIndex(token.toString());
                    BuildTool.putGendate(esIndice, format);
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 3: {
                    esIndice.setUuid(token.toString());
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 4: {
                    esIndice.setPri(Integer.parseInt(token.toString()));
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 5: {
                    esIndice.setRep(Integer.parseInt(token.toString()));
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 6: {
                    esIndice.setDocsCcount(Long.parseLong(token.toString()));
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 7: {
                    esIndice.setDocsDeleted(Long.parseLong(token.toString()));
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 8: {
                    esIndice.setStoreSize(token.toString());
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
                case 9: {
                    esIndice.setPriStoreSize(token.toString());
                    token.setLength(0);
                    ++k;
                    continue block12;
                }
            }
        }
        esIndice.setPriStoreSize(token.toString());
        return esIndice;
    }

    public static void putGendate(ESIndice esIndice, SimpleDateFormat format) {
        int dsplit = esIndice.getIndex().lastIndexOf(45);
        try {
            if (dsplit > 0) {
                String date = esIndice.getIndex().substring(dsplit + 1);
                esIndice.setGenDate((Date)format.parseObject(date));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String buildGetDocumentRequest(String indexName, String indexType, String documentId, Map<String, Object> options) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(indexName).append("/").append(indexType).append("/");
        CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
        charEscapeUtil.writeString(documentId, true);
        if (options != null) {
            builder.append("?");
            Iterator<Map.Entry<String, Object>> iterable = options.entrySet().iterator();
            boolean first = true;
            while (iterable.hasNext()) {
                Map.Entry<String, Object> entry = iterable.next();
                if (first) {
                    builder.append(entry.getKey()).append("=").append(entry.getValue());
                    first = false;
                    continue;
                }
                builder.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return builder.toString();
    }

    public static void buildId(Object id, StringBuilder builder, boolean escape) {
        if (id instanceof String) {
            if (!escape) {
                builder.append("\"").append(id).append("\"");
            } else {
                builder.append("\"");
                CharEscapeUtil charEscapeUtil = new CharEscapeUtil((Writer)new BBossStringWriter(builder));
                charEscapeUtil.writeString((String)id, true);
                builder.append("\"");
            }
        } else {
            builder.append(id);
        }
    }

    public static void buildId(Object id, Writer writer, boolean escape) throws IOException {
        if (id instanceof String) {
            writer.write("\"");
            if (!escape) {
                writer.write((String)id);
            } else {
                CharEscapeUtil charEscapeUtil = new CharEscapeUtil(writer);
                charEscapeUtil.writeString((String)id, true);
            }
            writer.write("\"");
        } else {
            writer.write(String.valueOf(id));
        }
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, Object params, String action) throws IOException {
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(params.getClass());
        Object id = BuildTool.getId(params, beanInfo);
        Object parentId = BuildTool.getParentId(params, beanInfo);
        Object routing = BuildTool.getRouting(params, beanInfo);
        Object esRetryOnConflict = BuildTool.getEsRetryOnConflict(params, beanInfo);
        BuildTool.buildMeta(writer, indexType, indexName, params, action, id, parentId, routing, esRetryOnConflict);
    }

    public static void buildMetaWithDocIdKey(Writer writer, String indexType, String indexName, Map params, String action, String docIdKey, String parentIdKey) throws IOException {
        BuildTool.buildMetaWithDocIdKey(writer, indexType, indexName, params, action, docIdKey, parentIdKey, null);
    }

    public static void buildMetaWithDocIdKey(Writer writer, String indexType, String indexName, Map params, String action, String docIdKey, String parentIdKey, String routingKey) throws IOException {
        Object id = docIdKey != null ? params.get(docIdKey) : null;
        Object parentId = parentIdKey != null ? params.get(parentIdKey) : null;
        Object routing = routingKey != null ? params.get(routingKey) : null;
        BuildTool.buildMeta(writer, indexType, indexName, params, action, id, parentId, routing);
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, Object params, String action, Object id, Object parentId, Object routing) throws IOException {
        BuildTool.buildMeta(writer, indexType, indexName, params, action, id, parentId, routing, null);
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, Object params, String action, Object id, Object parentId, Object routing, Object esRetryOnConflict) throws IOException {
        if (id != null) {
            Object versionType;
            ClassUtil.PropertieDescription esVersionTypeProperty;
            Object version;
            ClassUtil.ClassInfo classInfo;
            ClassUtil.PropertieDescription esVersionProperty;
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            writer.write("\", \"_type\" : \"");
            writer.write(indexType);
            writer.write("\", \"_id\" : ");
            BuildTool.buildId(id, writer, true);
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId(parentId, writer, true);
            }
            if (routing != null) {
                writer.write(", \"_routing\" : ");
                BuildTool.buildId(routing, writer, true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if ((esVersionProperty = (classInfo = ClassUtil.getClassInfo(params.getClass())).getEsVersionProperty()) != null && (version = classInfo.getPropertyValue(params, esVersionProperty.getName())) != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if ((esVersionTypeProperty = classInfo.getEsVersionTypeProperty()) != null && (versionType = classInfo.getPropertyValue(params, esVersionTypeProperty.getName())) != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write(" } }\n");
        } else {
            Object versionType;
            ClassUtil.PropertieDescription esVersionTypeProperty;
            Object version;
            ClassUtil.ClassInfo classInfo;
            ClassUtil.PropertieDescription esVersionProperty;
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            writer.write("\", \"_type\" : \"");
            writer.write(indexType);
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId(parentId, writer, true);
            }
            if (routing != null) {
                writer.write(", \"_routing\" : ");
                BuildTool.buildId(routing, writer, true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if ((esVersionProperty = (classInfo = ClassUtil.getClassInfo(params.getClass())).getEsVersionProperty()) != null && (version = classInfo.getPropertyValue(params, esVersionProperty.getName())) != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if ((esVersionTypeProperty = classInfo.getEsVersionTypeProperty()) != null && (versionType = classInfo.getPropertyValue(params, esVersionTypeProperty.getName())) != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write("\" } }\n");
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, Object param, String action) throws IOException {
        if (param != null) {
            BuildTool.buildMeta(writer, indexType, indexName, param, action);
            if (!action.equals("update")) {
                SerialUtil.object2json(param, writer);
                writer.write("\n");
            } else {
                Object returnSource;
                Object esDocAsUpsert;
                ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(param.getClass());
                ClassUtil.PropertieDescription esDocAsUpsertProperty = classInfo.getEsDocAsUpsertProperty();
                ClassUtil.PropertieDescription esReturnSourceProperty = classInfo.getEsReturnSourceProperty();
                writer.write("{\"doc\":");
                SerialUtil.object2json(param, writer);
                if (esDocAsUpsertProperty != null && (esDocAsUpsert = classInfo.getPropertyValue(param, esDocAsUpsertProperty.getName())) != null) {
                    writer.write(",\"doc_as_upsert\":");
                    writer.write(String.valueOf(esDocAsUpsert));
                }
                if (esReturnSourceProperty != null && (returnSource = classInfo.getPropertyValue(param, esReturnSourceProperty.getName())) != null) {
                    writer.write(",\"_source\":");
                    writer.write(String.valueOf(returnSource));
                }
                writer.write("}\n");
            }
        }
    }

    public static void buildMeta(StringBuilder builder, String indexType, String indexName, Object params, String action) {
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(params.getClass());
        Object id = BuildTool.getId(params, beanInfo);
        Object parentId = BuildTool.getParentId(params, beanInfo);
        if (id != null) {
            builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\", \"_id\" : ");
            BuildTool.buildId(id, builder, true);
            if (parentId != null) {
                builder.append(",\"parent\":");
                BuildTool.buildId(parentId, builder, true);
            }
            builder.append(" } }\n");
        } else if (parentId == null) {
            builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\" } }\n");
        } else {
            builder.append("{ \"").append(action).append("\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\"");
            builder.append(",\"parent\":");
            BuildTool.buildId(parentId, builder, true);
            builder.append(" } }\n");
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, Map param, String action, String docIdKey, String parentIdKey) throws IOException {
        if (param != null) {
            BuildTool.buildMetaWithDocIdKey(writer, indexType, indexName, param, action, docIdKey, parentIdKey);
            if (!action.equals("update")) {
                SerialUtil.object2json(param, writer);
                writer.write("\n");
            } else {
                writer.write("{\"doc\":");
                SerialUtil.object2json(param, writer);
                writer.write("}\n");
            }
        }
    }

    public static void handleFields(Map<String, Object> subFileds, String fieldName, List<IndexField> fields) {
        if (subFileds == null || subFileds.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : subFileds.entrySet()) {
            IndexField indexField = BuildTool.buildIndexField(entry, fields, fieldName);
        }
    }

    public static Boolean parseBoolean(Object norms) {
        if (norms == null) {
            return null;
        }
        if (norms instanceof Boolean) {
            return (Boolean)norms;
        }
        if (norms instanceof Map) {
            return (Boolean)((Map)norms).get("enabled");
        }
        return null;
    }

    public static IndexField buildIndexField(Map.Entry<String, Object> field, List<IndexField> fields, String parentFieldName) {
        IndexField indexField = new IndexField();
        String fieldName = null;
        fieldName = parentFieldName != null ? parentFieldName + "." + field.getKey() : field.getKey();
        indexField.setFieldName(fieldName);
        Map fieldInfo = (Map)field.getValue();
        indexField.setType((String)fieldInfo.get("type"));
        indexField.setIgnoreAbove(ResultUtil.intValue(fieldInfo.get("ignore_above"), null));
        indexField.setAnalyzer((String)fieldInfo.get("analyzer"));
        indexField.setNormalizer((String)fieldInfo.get("normalizer"));
        indexField.setBoost((Integer)fieldInfo.get("boost"));
        indexField.setCoerce(BuildTool.parseBoolean(fieldInfo.get("coerce")));
        indexField.setCopyTo((String)fieldInfo.get("copy_to"));
        indexField.setDocValues(BuildTool.parseBoolean(fieldInfo.get("doc_values")));
        indexField.setDynamic(BuildTool.parseBoolean(fieldInfo.get("doc_values")));
        indexField.setEnabled(BuildTool.parseBoolean(fieldInfo.get("enabled")));
        indexField.setFielddata(BuildTool.parseBoolean(fieldInfo.get("fielddata")));
        indexField.setFormat((String)fieldInfo.get("format"));
        indexField.setIgnoreMalformed(BuildTool.parseBoolean(fieldInfo.get("ignore_malformed")));
        indexField.setIncludeInAll(BuildTool.parseBoolean(fieldInfo.get("include_in_all")));
        indexField.setIndexOptions((String)fieldInfo.get("index_options"));
        indexField.setIndex(BuildTool.parseBoolean(fieldInfo.get("index")));
        indexField.setFields((Map)fieldInfo.get("fields"));
        indexField.setNorms(BuildTool.parseBoolean(fieldInfo.get("norms")));
        indexField.setNullValue(fieldInfo.get("null_value"));
        indexField.setPositionIncrementGap((Integer)fieldInfo.get("position_increment_gap"));
        indexField.setProperties((Map)fieldInfo.get("properties"));
        indexField.setSearchAnalyzer((String)fieldInfo.get("search_analyzer"));
        indexField.setSimilarity((String)fieldInfo.get("similarity"));
        indexField.setStore(BuildTool.parseBoolean(fieldInfo.get("store")));
        indexField.setTermVector((String)fieldInfo.get("term_vector"));
        fields.add(indexField);
        BuildTool.handleFields(indexField.getFields(), fieldName, fields);
        return indexField;
    }

    public static Object getId(Object bean, ClassUtil.ClassInfo beanInfo) {
        ClassUtil.PropertieDescription pkProperty = beanInfo.getEsIdProperty();
        if (pkProperty == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, pkProperty.getName());
    }

    public static Object getEsRetryOnConflict(Object bean, ClassUtil.ClassInfo beanInfo) {
        ClassUtil.PropertieDescription esRetryOnConflictProperty = beanInfo.getEsRetryOnConflictProperty();
        if (esRetryOnConflictProperty == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, esRetryOnConflictProperty.getName());
    }

    public static Object getRouting(Object bean, ClassUtil.ClassInfo beanInfo) {
        ClassUtil.PropertieDescription routingProperty = beanInfo.getEsRoutingProperty();
        if (routingProperty == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, routingProperty.getName());
    }

    public static Object getParentId(Object bean, ClassUtil.ClassInfo beanInfo) {
        ClassUtil.PropertieDescription pkProperty = beanInfo.getEsParentProperty();
        if (pkProperty == null) {
            return null;
        }
        return beanInfo.getPropertyValue(bean, pkProperty.getName());
    }
}

