/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.entity.suggest;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.suggest.TermRestResponse;
import org.frameworkset.spi.remote.http.BaseResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchTermResponseHandler
extends BaseResponseHandler
implements ResponseHandler<TermRestResponse> {
    private static Logger logger = LoggerFactory.getLogger(ElasticSearchTermResponseHandler.class);

    public TermRestResponse handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    return (TermRestResponse)super.converJson(entity, TermRestResponse.class);
                }
                catch (Exception e) {
                    throw new ElasticSearchException(e);
                }
            }
            return null;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            throw new ElasticSearchException(EntityUtils.toString((HttpEntity)entity));
        }
        throw new ElasticSearchException("Unexpected response status: " + status);
    }
}

