/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.AggHit;
import org.frameworkset.elasticsearch.entity.BaseSearchHit;
import org.frameworkset.elasticsearch.entity.DoubleAggHit;
import org.frameworkset.elasticsearch.entity.DoubleAggRangeHit;
import org.frameworkset.elasticsearch.entity.ESAggDatas;
import org.frameworkset.elasticsearch.entity.ESBaseData;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.ESId;
import org.frameworkset.elasticsearch.entity.FloatAggHit;
import org.frameworkset.elasticsearch.entity.FloatAggRangeHit;
import org.frameworkset.elasticsearch.entity.InnerSearchHit;
import org.frameworkset.elasticsearch.entity.InnerSearchHits;
import org.frameworkset.elasticsearch.entity.LongAggHit;
import org.frameworkset.elasticsearch.entity.LongAggRangeHit;
import org.frameworkset.elasticsearch.entity.MGetDocs;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.entity.SearchHit;
import org.frameworkset.elasticsearch.handler.ESAggBucketHandle;
import org.frameworkset.elasticsearch.serial.ESTypeReference;

public abstract class ResultUtil {
    public static <T> List<T> getInnerHits(Map<String, Map<String, InnerSearchHits>> innerHits, String indexType, Class<T> type) {
        InnerSearchHits ihits;
        if (innerHits == null || innerHits.size() == 0) {
            return null;
        }
        Map<String, InnerSearchHits> hits = innerHits.get(indexType);
        if (hits != null && (ihits = hits.get("hits")) != null) {
            List<InnerSearchHit> temp = ihits.getHits();
            if (temp.size() == 0) {
                return null;
            }
            if (InnerSearchHit.class.isAssignableFrom(type)) {
                return temp;
            }
            ArrayList<Object> ts = new ArrayList<Object>(temp.size());
            for (int i = 0; i < temp.size(); ++i) {
                ts.add(temp.get(i).getSource());
            }
            return ts;
        }
        return null;
    }

    public static List getInnerHits(Map<String, Map<String, InnerSearchHits>> innerHits, String indexType) {
        InnerSearchHits ihits;
        if (innerHits == null || innerHits.size() == 0) {
            return null;
        }
        Map<String, InnerSearchHits> hits = innerHits.get(indexType);
        if (hits != null && (ihits = hits.get("hits")) != null) {
            List<InnerSearchHit> temp = ihits.getHits();
            if (temp.size() == 0) {
                return null;
            }
            ArrayList<Object> ts = new ArrayList<Object>(temp.size());
            for (int i = 0; i < temp.size(); ++i) {
                ts.add(temp.get(i).getSource());
            }
            return ts;
        }
        return null;
    }

    public static Long longValue(Object num, Long defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Long) {
            return (Long)num;
        }
        if (num instanceof Double) {
            return ((Double)num).longValue();
        }
        if (num instanceof Integer) {
            return ((Integer)num).longValue();
        }
        if (num instanceof Float) {
            return ((Float)num).longValue();
        }
        if (num instanceof Short) {
            return ((Short)num).longValue();
        }
        return Long.parseLong(num.toString());
    }

    public static Integer intValue(Object num, Integer defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Integer) {
            return (Integer)num;
        }
        if (num instanceof Long) {
            return ((Long)num).intValue();
        }
        if (num instanceof Double) {
            return ((Double)num).intValue();
        }
        if (num instanceof Float) {
            return ((Float)num).intValue();
        }
        if (num instanceof Short) {
            return ((Short)num).intValue();
        }
        return Integer.parseInt(num.toString());
    }

    public static Float floatValue(Object num, Float defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Float) {
            return (Float)num;
        }
        if (num instanceof Double) {
            return Float.valueOf(((Double)num).floatValue());
        }
        if (num instanceof Integer) {
            return Float.valueOf(((Integer)num).floatValue());
        }
        if (num instanceof Long) {
            return Float.valueOf(((Long)num).floatValue());
        }
        if (num instanceof Short) {
            return Float.valueOf(((Short)num).floatValue());
        }
        return Float.valueOf(Float.parseFloat(num.toString()));
    }

    public static Double doubleValue(Object num, Double defaultValue) {
        if (num == null) {
            return defaultValue;
        }
        if (num instanceof Double) {
            return (Double)num;
        }
        if (num instanceof Float) {
            return ((Float)num).doubleValue();
        }
        if (num instanceof Integer) {
            return ((Integer)num).doubleValue();
        }
        if (num instanceof Long) {
            return ((Long)num).doubleValue();
        }
        if (num instanceof Short) {
            return ((Short)num).doubleValue();
        }
        return Double.parseDouble(num.toString());
    }

    public static String handleLuceneSpecialChars(String condition) {
        if (condition == null || condition.equals("")) {
            return condition;
        }
        condition = condition.replace(":", "/:");
        condition = condition.replace("-", "/-");
        condition = condition.replace("+", "/+");
        condition = condition.replace("&", "/&");
        condition = condition.replace("!", "/!");
        condition = condition.replace("{", "/{");
        condition = condition.replace("}", "/}");
        condition = condition.replace("(", "/(");
        condition = condition.replace(")", "/)");
        condition = condition.replace("|", "/|");
        condition = condition.replace("~", "/~");
        condition = condition.replace("*", "/*");
        condition = condition.replace("?", "/?");
        condition = condition.replace("/", "//");
        return condition;
    }

    public static String handleElasticSearchSpecialChars(String condition) {
        if (condition == null || condition.equals("")) {
            return condition;
        }
        condition = condition.replace(":", "\\:");
        condition = condition.replace("-", "\\-");
        condition = condition.replace("+", "\\+");
        condition = condition.replace("&", "\\&");
        condition = condition.replace("!", "\\!");
        condition = condition.replace("{", "\\{");
        condition = condition.replace("}", "\\}");
        condition = condition.replace("(", "\\(");
        condition = condition.replace(")", "\\)");
        condition = condition.replace("|", "\\|");
        condition = condition.replace("~", "\\~");
        condition = condition.replace("*", "\\*");
        condition = condition.replace("?", "\\?");
        condition = condition.replace("/", "\\/");
        return condition;
    }

    public static void buildLongAggHit(LongAggHit longRangeHit, Map<String, Object> bucket, String stats) {
        longRangeHit.setKey((String)bucket.get("key"));
        longRangeHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        longRangeHit.setMax(ResultUtil.longValue(stats_.get("max"), 0L));
        longRangeHit.setMin(ResultUtil.longValue(stats_.get("min"), 0L));
        longRangeHit.setAvg(ResultUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        longRangeHit.setSum(ResultUtil.longValue(stats_.get("sum"), 0L));
    }

    public static void buildFloatAggHit(FloatAggHit floatRangeHit, Map<String, Object> bucket, String stats) {
        floatRangeHit.setKey((String)bucket.get("key"));
        floatRangeHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        floatRangeHit.setMax(ResultUtil.floatValue(stats_.get("max"), Float.valueOf(0.0f)));
        floatRangeHit.setMin(ResultUtil.floatValue(stats_.get("min"), Float.valueOf(0.0f)));
        floatRangeHit.setAvg(ResultUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        floatRangeHit.setSum(ResultUtil.floatValue(stats_.get("sum"), Float.valueOf(0.0f)));
    }

    public static void buildDoubleAggHit(DoubleAggHit doubleAggHit, Map<String, Object> bucket, String stats) {
        doubleAggHit.setKey((String)bucket.get("key"));
        doubleAggHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        doubleAggHit.setMax(ResultUtil.doubleValue(stats_.get("max"), 0.0));
        doubleAggHit.setMin(ResultUtil.doubleValue(stats_.get("min"), 0.0));
        doubleAggHit.setAvg(ResultUtil.doubleValue(stats_.get("avg"), 0.0));
        doubleAggHit.setSum(ResultUtil.doubleValue(stats_.get("sum"), 0.0));
    }

    public static void buildLongAggRangeHit(LongAggRangeHit longRangeHit, Map<String, Object> bucket, String stats, String key) {
        longRangeHit.setKey(key);
        longRangeHit.setFrom(ResultUtil.longValue(bucket.get("from"), null));
        longRangeHit.setTo(ResultUtil.longValue(bucket.get("to"), null));
        longRangeHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        longRangeHit.setMax(ResultUtil.longValue(stats_.get("max"), 0L));
        longRangeHit.setMin(ResultUtil.longValue(stats_.get("min"), 0L));
        longRangeHit.setAvg(ResultUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        longRangeHit.setSum(ResultUtil.longValue(stats_.get("sum"), 0L));
    }

    public static void buildFloatAggRangeHit(FloatAggRangeHit floatRangeHit, Map<String, Object> bucket, String stats, String key) {
        floatRangeHit.setKey(key);
        floatRangeHit.setFrom(ResultUtil.floatValue(bucket.get("from"), null));
        floatRangeHit.setTo(ResultUtil.floatValue(bucket.get("to"), null));
        floatRangeHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        floatRangeHit.setMax(ResultUtil.floatValue(stats_.get("max"), Float.valueOf(0.0f)));
        floatRangeHit.setMin(ResultUtil.floatValue(stats_.get("min"), Float.valueOf(0.0f)));
        floatRangeHit.setAvg(ResultUtil.floatValue(stats_.get("avg"), Float.valueOf(0.0f)));
        floatRangeHit.setSum(ResultUtil.floatValue(stats_.get("sum"), Float.valueOf(0.0f)));
    }

    public static void buildDoubleAggRangeHit(DoubleAggRangeHit doubleRangeHit, Map<String, Object> bucket, String stats, String key) {
        doubleRangeHit.setKey(key);
        doubleRangeHit.setFrom(ResultUtil.doubleValue(bucket.get("from"), null));
        doubleRangeHit.setTo(ResultUtil.doubleValue(bucket.get("to"), null));
        doubleRangeHit.setDocCount(ResultUtil.longValue(bucket.get("doc_count"), 0L));
        Map stats_ = (Map)bucket.get(stats);
        doubleRangeHit.setMax(ResultUtil.doubleValue(stats_.get("max"), 0.0));
        doubleRangeHit.setMin(ResultUtil.doubleValue(stats_.get("min"), 0.0));
        doubleRangeHit.setAvg(ResultUtil.doubleValue(stats_.get("avg"), 0.0));
        doubleRangeHit.setSum(ResultUtil.doubleValue(stats_.get("sum"), 0.0));
    }

    public static <T extends AggHit> ESAggDatas<T> buildESAggDatas(RestResponse searchResult, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) {
        Map<String, Map<String, Object>> aggregations = searchResult.getAggregations();
        if (aggregations != null) {
            Map<String, Object> traces = aggregations.get(aggs);
            Object _buckets = traces.get("buckets");
            ESAggDatas ret = new ESAggDatas();
            ret.setAggregations(aggregations);
            ret.setTotalSize(searchResult.getSearchHits().getTotal());
            if (_buckets instanceof List) {
                List buckets = (List)_buckets;
                ArrayList<AggHit> datas = new ArrayList<AggHit>(buckets.size());
                ret.setAggDatas(datas);
                for (Map bucket : buckets) {
                    try {
                        AggHit obj = (AggHit)type.newInstance();
                        if (obj instanceof LongAggRangeHit) {
                            ResultUtil.buildLongAggRangeHit((LongAggRangeHit)obj, bucket, stats, null);
                        } else if (obj instanceof FloatAggRangeHit) {
                            ResultUtil.buildFloatAggRangeHit((FloatAggRangeHit)obj, bucket, stats, null);
                        } else if (obj instanceof DoubleAggRangeHit) {
                            ResultUtil.buildDoubleAggRangeHit((DoubleAggRangeHit)obj, bucket, stats, null);
                        } else if (obj instanceof LongAggHit) {
                            ResultUtil.buildLongAggHit((LongAggHit)obj, bucket, stats);
                        } else if (obj instanceof FloatAggHit) {
                            ResultUtil.buildFloatAggHit((FloatAggHit)obj, bucket, stats);
                        } else if (obj instanceof DoubleAggHit) {
                            ResultUtil.buildDoubleAggHit((DoubleAggHit)obj, bucket, stats);
                        }
                        if (aggBucketHandle != null) {
                            aggBucketHandle.bucketHandle(searchResult, bucket, obj, null);
                        }
                        datas.add(obj);
                    }
                    catch (InstantiationException e) {
                        throw new ElasticSearchException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ElasticSearchException(e);
                    }
                }
            } else {
                Map buckets = (Map)_buckets;
                ArrayList<AggHit> datas = new ArrayList<AggHit>(buckets.size());
                ret.setAggDatas(datas);
                Iterator iterable = buckets.entrySet().iterator();
                Map bucket = null;
                Map.Entry entry = null;
                String key = null;
                AggHit obj = null;
                while (iterable.hasNext()) {
                    entry = iterable.next();
                    key = (String)entry.getKey();
                    bucket = (Map)entry.getValue();
                    try {
                        obj = (AggHit)type.newInstance();
                        if (obj instanceof LongAggRangeHit) {
                            ResultUtil.buildLongAggRangeHit((LongAggRangeHit)obj, bucket, stats, key);
                        } else if (obj instanceof DoubleAggRangeHit) {
                            ResultUtil.buildDoubleAggRangeHit((DoubleAggRangeHit)obj, bucket, stats, key);
                        } else if (obj instanceof FloatAggRangeHit) {
                            ResultUtil.buildFloatAggRangeHit((FloatAggRangeHit)obj, bucket, stats, key);
                        }
                        if (aggBucketHandle != null) {
                            aggBucketHandle.bucketHandle(searchResult, bucket, obj, key);
                        }
                        datas.add(obj);
                    }
                    catch (InstantiationException e) {
                        throw new ElasticSearchException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ElasticSearchException(e);
                    }
                }
            }
            return ret;
        }
        return null;
    }

    public static <T> T getAggBuckets(Map<String, ?> map, String metrics, ESTypeReference<T> typeReference) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return (T)metrics_.get("buckets");
        }
        return null;
    }

    public static Map<String, Object> getAggregationMetrics(Map<String, ?> map, String metrics) {
        if (map != null) {
            return (Map)map.get(metrics);
        }
        return null;
    }

    public static <T> T getAggBuckets(Map<String, ?> map, String metrics, Class<T> typeReference) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return (T)metrics_.get("buckets");
        }
        return null;
    }

    public static Object getAggBuckets(Map<String, ?> map, String metrics) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return metrics_.get("buckets");
        }
        return null;
    }

    public static <T> T getAggAttribute(Map<String, ?> map, String metrics, String attribute, ESTypeReference<T> typeReference) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return (T)metrics_.get(attribute);
        }
        return null;
    }

    public static <T> T getAggAttribute(Map<String, ?> map, String metrics, String attribute, Class<T> typeReference) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return (T)metrics_.get(attribute);
        }
        return null;
    }

    public static Object getAggAttribute(Map<String, ?> map, String metrics, String attribute) {
        Map metrics_;
        if (map != null && (metrics_ = (Map)map.get(metrics)) != null) {
            return metrics_.get(attribute);
        }
        return null;
    }

    public static void buildESBaseData(BaseSearchHit hit, ESBaseData esBaseData) {
        esBaseData.setFields(hit.getFields());
        esBaseData.setHighlight(hit.getHighlight());
        esBaseData.setId(hit.getId());
        esBaseData.setScore(hit.getScore());
        esBaseData.setSort(hit.getSort());
        esBaseData.setType(hit.getType());
        esBaseData.setVersion(hit.getVersion());
        esBaseData.setIndex(hit.getIndex());
        esBaseData.setParent(hit.getParent());
        esBaseData.setRouting(hit.getRouting());
        esBaseData.setFound(hit.isFound());
        esBaseData.setNested(hit.getNested());
        esBaseData.setInnerHits(hit.getInnerHits());
    }

    public static void buildESId(BaseSearchHit hit, ESId esBaseData) {
        esBaseData.setId(hit.getId());
    }

    public static void injectBaseData(Object data, BaseSearchHit hit, boolean isESBaseData, boolean isESId) {
        if (isESBaseData) {
            ResultUtil.buildESBaseData(hit, (ESBaseData)data);
        } else if (isESId) {
            ResultUtil.buildESId(hit, (ESId)data);
        }
    }

    public static void injectInnerHitBaseData(Map<String, Map<String, InnerSearchHits>> innerHits) {
        for (Map.Entry<String, Map<String, InnerSearchHits>> entry : innerHits.entrySet()) {
            List<InnerSearchHit> innerSearchHits;
            Map<String, InnerSearchHits> value = entry.getValue();
            InnerSearchHits hitsEntryValue = value.get("hits");
            if (hitsEntryValue == null || (innerSearchHits = hitsEntryValue.getHits()) == null || innerSearchHits.size() <= 0) continue;
            Object source = innerSearchHits.get(0).getSource();
            boolean isESBaseData = ESBaseData.class.isAssignableFrom(source.getClass());
            boolean isESId = false;
            if (!isESBaseData) {
                isESId = ESId.class.isAssignableFrom(source.getClass());
            }
            if (!isESBaseData && !isESId) continue;
            for (int i = 0; i < innerSearchHits.size(); ++i) {
                InnerSearchHit innerSearchHit = innerSearchHits.get(i);
                source = innerSearchHit.getSource();
                if (source == null) continue;
                ResultUtil.injectBaseData(source, innerSearchHit, isESBaseData, isESId);
            }
        }
    }

    public static <T> T buildObject(RestResponse result, Class<T> type) {
        if (result == null) {
            return null;
        }
        RestResponse restResponse = result;
        List<SearchHit> searchHits = restResponse.getSearchHits().getHits();
        if (searchHits != null && searchHits.size() > 0) {
            SearchHit hit = searchHits.get(0);
            if (SearchHit.class.isAssignableFrom(type)) {
                Map<String, Map<String, InnerSearchHits>> innerHits;
                Object data = hit.getSource();
                if (data != null) {
                    boolean isESBaseData = ESBaseData.class.isAssignableFrom(data.getClass());
                    boolean isESId = false;
                    if (!isESBaseData) {
                        isESId = ESId.class.isAssignableFrom(data.getClass());
                    }
                    ResultUtil.injectBaseData(data, hit, isESBaseData, isESId);
                }
                if ((innerHits = hit.getInnerHits()) != null && innerHits.size() > 0) {
                    ResultUtil.injectInnerHitBaseData(innerHits);
                }
                return (T)hit;
            }
            boolean isESBaseData = ESBaseData.class.isAssignableFrom(type);
            boolean isESId = false;
            if (!isESBaseData) {
                isESId = ESId.class.isAssignableFrom(type);
            }
            Object data = hit.getSource();
            if (isESBaseData) {
                ResultUtil.buildESBaseData(hit, (ESBaseData)data);
            } else if (isESId) {
                ResultUtil.buildESId(hit, (ESId)data);
            }
            return (T)data;
        }
        return null;
    }

    public static <T> List<T> buildObjects(MGetDocs results, Class<T> type) {
        if (results == null) {
            return null;
        }
        List<SearchHit> hits = results.getDocs();
        if (hits == null) {
            return null;
        }
        ArrayList<T> docs = new ArrayList<T>(hits.size());
        for (SearchHit result : hits) {
            docs.add(ResultUtil.buildObject(result, type));
        }
        return docs;
    }

    public static <T> T buildObject(SearchHit result, Class<T> type) {
        SearchHit hit;
        if (result == null) {
            return null;
        }
        if (SearchHit.class.isAssignableFrom(type)) {
            Map<String, Map<String, InnerSearchHits>> innerHits;
            Object data = result.getSource();
            if (data != null) {
                boolean isESBaseData = ESBaseData.class.isAssignableFrom(data.getClass());
                boolean isESId = false;
                if (!isESBaseData) {
                    isESId = ESId.class.isAssignableFrom(data.getClass());
                }
                ResultUtil.injectBaseData(data, result, isESBaseData, isESId);
            }
            if ((innerHits = result.getInnerHits()) != null && innerHits.size() > 0) {
                ResultUtil.injectInnerHitBaseData(innerHits);
            }
            return (T)result;
        }
        boolean isESBaseData = ESBaseData.class.isAssignableFrom(type);
        boolean isESId = false;
        if (!isESBaseData) {
            isESId = ESId.class.isAssignableFrom(type);
        }
        if ((hit = result).isFound()) {
            Object data = hit.getSource();
            if (isESBaseData) {
                ResultUtil.buildESBaseData(hit, (ESBaseData)data);
            } else if (isESId) {
                ResultUtil.buildESId(hit, (ESId)data);
            }
            return (T)data;
        }
        return null;
    }

    public static <T> ESDatas<T> buildESDatas(RestResponse result, Class<T> type) {
        ESDatas<SearchHit> datas = new ESDatas<SearchHit>();
        RestResponse restResponse = result;
        datas.setRestResponse(restResponse);
        List<SearchHit> searchHits = null;
        if (restResponse.getSearchHits() != null) {
            datas.setTotalSize(restResponse.getSearchHits().getTotal());
            searchHits = restResponse.getSearchHits().getHits();
        }
        datas.setScrollId(restResponse.getScrollId());
        if (SearchHit.class.isAssignableFrom(type)) {
            datas.setAggregations(restResponse.getAggregations());
            if (searchHits != null && searchHits.size() > 0) {
                Object obj = searchHits.get(0).getSource();
                boolean isESBaseData = ESBaseData.class.isAssignableFrom(obj.getClass());
                boolean isESId = false;
                if (!isESBaseData) {
                    isESId = ESId.class.isAssignableFrom(obj.getClass());
                }
                for (int i = 0; i < searchHits.size(); ++i) {
                    Map<String, Map<String, InnerSearchHits>> innerHits;
                    SearchHit hit = searchHits.get(i);
                    Object data = hit.getSource();
                    if (data != null) {
                        ResultUtil.injectBaseData(data, hit, isESBaseData, isESId);
                    }
                    if ((innerHits = hit.getInnerHits()) == null || innerHits.size() <= 0) continue;
                    ResultUtil.injectInnerHitBaseData(innerHits);
                }
            }
            datas.setDatas(searchHits);
        } else {
            if (searchHits != null && searchHits.size() > 0) {
                ArrayList<Object> hits = new ArrayList<Object>(searchHits.size());
                boolean isESBaseData = ESBaseData.class.isAssignableFrom(type);
                boolean isESId = false;
                if (!isESBaseData) {
                    isESId = ESId.class.isAssignableFrom(type);
                }
                Object data = null;
                for (SearchHit hit : searchHits) {
                    Map<String, Map<String, InnerSearchHits>> innerHits;
                    data = hit.getSource();
                    hits.add(data);
                    if (data != null) {
                        ResultUtil.injectBaseData(data, hit, isESBaseData, isESId);
                    }
                    if ((innerHits = hit.getInnerHits()) == null || innerHits.size() <= 0) continue;
                    ResultUtil.injectInnerHitBaseData(innerHits);
                }
                datas.setDatas(hits);
            }
            datas.setAggregations(restResponse.getAggregations());
        }
        return datas;
    }
}

