/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.ElasticsearchParseException;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.DefaultApplicationContext;

public class ElasticSearchHelper {
    protected static DefaultApplicationContext context = null;
    public static final String DEFAULT_SEARCH = "elasticSearch";
    protected static ElasticSearch elasticSearchSink = null;
    private static boolean inited;
    private static long dslfileRefreshInterval;
    private static Method bootMethod;
    private static Map<String, ElasticSearch> elasticSearchMap;

    public static long getDslfileRefreshInterval() {
        return dslfileRefreshInterval;
    }

    public static void setDslfileRefreshInterval(long dslfileRefreshInterval) {
        ElasticSearchHelper.dslfileRefreshInterval = dslfileRefreshInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void booter(String[] elasticsearchServerNames, BaseApplicationContext configContext) {
        if (inited) {
            return;
        }
        inited = true;
        ElasticSearch elasticSearchSink = null;
        ElasticSearch firstElasticSearch = null;
        ElasticSearchHelper.initDslFileRefreshInterval(configContext);
        HashMap<String, ElasticSearch> elasticSearchMap = new HashMap<String, ElasticSearch>();
        for (String serverName : elasticsearchServerNames) {
            Properties elasticsearchPropes = new Properties();
            elasticsearchPropes.put("elasticsearch.client", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.client", configContext, "restful"));
            elasticsearchPropes.put("elasticUser", ElasticSearchHelper._getStringValue(serverName, "elasticUser", configContext, ""));
            elasticsearchPropes.put("elasticPassword", ElasticSearchHelper._getStringValue(serverName, "elasticPassword", configContext, ""));
            elasticsearchPropes.put("elasticsearch.rest.hostNames", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.rest.hostNames", configContext, "127.0.0.1:9200"));
            elasticsearchPropes.put("elasticsearch.dateFormat", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.dateFormat", configContext, "yyyy.MM.dd"));
            elasticsearchPropes.put("elasticsearch.timeZone", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.timeZone", configContext, "Asia/Shanghai"));
            elasticsearchPropes.put("elasticsearch.ttl", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.ttl", configContext, "2d"));
            elasticsearchPropes.put("elasticsearch.showTemplate", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.showTemplate", configContext, "false"));
            elasticsearchPropes.put("elasticsearch.httpPool", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.httpPool", configContext, serverName));
            elasticsearchPropes.put("elasticsearch.discoverHost", ElasticSearchHelper._getStringValue(serverName, "elasticsearch.discoverHost", configContext, "false"));
            ElasticSearch elasticSearch = new ElasticSearch();
            if (firstElasticSearch == null) {
                firstElasticSearch = elasticSearch;
            }
            elasticSearch.setElasticsearchPropes(elasticsearchPropes);
            elasticSearch.configureWithConfigContext(configContext);
            if (!serverName.equals("default")) {
                elasticSearchMap.put(serverName, elasticSearch);
                continue;
            }
            elasticSearchMap.put(DEFAULT_SEARCH, elasticSearch);
            elasticSearchSink = elasticSearch;
        }
        if (elasticSearchSink == null) {
            elasticSearchSink = firstElasticSearch;
        }
        ElasticSearchHelper.elasticSearchSink = elasticSearchSink;
        if (elasticSearchMap.size() > 0) {
            for (Map.Entry entry : elasticSearchMap.entrySet()) {
                final ElasticSearch elasticSearch = (ElasticSearch)((Object)entry.getValue());
                elasticSearch.start();
                BaseApplicationContext.addShutdownHook((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        elasticSearch.stop();
                    }
                });
            }
            Map<String, ElasticSearch> map = ElasticSearchHelper.elasticSearchMap;
            synchronized (map) {
                ElasticSearchHelper.elasticSearchMap.putAll(elasticSearchMap);
            }
        }
    }

    private static long _getLongValue(String poolName, String propertyName, BaseApplicationContext context, long defaultValue) throws Exception {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        long ret = Long.parseLong(_value.trim());
        return ret;
    }

    private static int _getIntValue(String poolName, String propertyName, BaseApplicationContext context, int defaultValue) throws Exception {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        int ret = Integer.parseInt(_value);
        return ret;
    }

    private static String _getStringValue(String poolName, String propertyName, BaseApplicationContext context, String defaultValue) {
        String _value = null;
        if (poolName.equals("default")) {
            _value = context.getExternalProperty(propertyName);
            if (_value == null) {
                _value = context.getExternalProperty(poolName + "." + propertyName);
            }
        } else {
            _value = context.getExternalProperty(poolName + "." + propertyName);
        }
        if (_value == null) {
            return defaultValue;
        }
        return _value;
    }

    private static void initDslFileRefreshInterval(BaseApplicationContext context) {
        try {
            long _dslfileRefreshInterval;
            dslfileRefreshInterval = _dslfileRefreshInterval = ElasticSearchHelper._getLongValue("default", "dslfile.refreshInterval", context, 5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void init() {
        if (inited) {
            return;
        }
        Map<String, ElasticSearch> map = elasticSearchMap;
        synchronized (map) {
            ElasticSearch _elasticSearchSink;
            if (inited) {
                return;
            }
            if (elasticSearchSink == null && (_elasticSearchSink = elasticSearchMap.get(DEFAULT_SEARCH)) == null && !(context = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch.xml")).isEmptyContext()) {
                ElasticSearchHelper.initDslFileRefreshInterval((BaseApplicationContext)context);
                _elasticSearchSink = (ElasticSearch)((Object)context.getTBeanObject(DEFAULT_SEARCH, ElasticSearch.class));
                if (_elasticSearchSink != null) {
                    elasticSearchMap.put(DEFAULT_SEARCH, _elasticSearchSink);
                    elasticSearchSink = _elasticSearchSink;
                }
            }
            if (context.isEmptyContext() && bootMethod != null) {
                try {
                    bootMethod.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new ElasticsearchParseException("ElasticSearch load from Boot failed:", e);
                }
                catch (InvocationTargetException e) {
                    throw new ElasticsearchParseException("ElasticSearch load from Boot failed:", e);
                }
            }
            inited = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElasticSearch getElasticSearchSink(String elasticSearch) {
        ElasticSearchHelper.init();
        if (elasticSearch == null || elasticSearch.equals("")) {
            return elasticSearchSink;
        }
        ElasticSearch elasticSearchSink = elasticSearchMap.get(elasticSearch);
        if (elasticSearchSink == null) {
            Map<String, ElasticSearch> map = elasticSearchMap;
            synchronized (map) {
                elasticSearchSink = elasticSearchMap.get(elasticSearch);
                if (elasticSearchSink != null) {
                    return elasticSearchSink;
                }
                context = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch.xml");
                elasticSearchSink = (ElasticSearch)((Object)context.getTBeanObject(elasticSearch, ElasticSearch.class));
                if (elasticSearchSink != null) {
                    elasticSearchMap.put(elasticSearch, elasticSearchSink);
                }
            }
        }
        return elasticSearchSink;
    }

    public static ElasticSearch getElasticSearchSink() {
        ElasticSearchHelper.init();
        return elasticSearchSink;
    }

    public static ClientInterface getRestClientUtil() {
        ElasticSearchHelper.init();
        return elasticSearchSink.getRestClientUtil();
    }

    public static ClientInterface getRestClientUtil(String elasticSearch) {
        ElasticSearch elasticSearchSink = ElasticSearchHelper.getElasticSearchSink(elasticSearch);
        return elasticSearchSink.getRestClientUtil();
    }

    public static ClientInterface getConfigRestClientUtil(String configFile) {
        ElasticSearchHelper.init();
        return elasticSearchSink.getConfigRestClientUtil(configFile);
    }

    public static ClientInterface getConfigRestClientUtil(String elasticSearch, String configFile) {
        ElasticSearch elasticSearchSink = ElasticSearchHelper.getElasticSearchSink(elasticSearch);
        return elasticSearchSink.getConfigRestClientUtil(configFile);
    }

    public static void addHttpServer(List<String> hosts) {
    }

    static {
        dslfileRefreshInterval = 5000L;
        try {
            Class<?> booterClass = Class.forName("org.frameworkset.elasticsearch.boot.ElasticSearchConfigBoot");
            bootMethod = booterClass.getMethod("boot", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        elasticSearchMap = new HashMap<String, ElasticSearch>();
    }
}

