/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch;

import com.frameworkset.util.SimpleStringUtil;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.ElasticSearchClientFactory;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.support.ApplicationObjectSupport;
import org.frameworkset.util.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearch
extends ApplicationObjectSupport {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearch.class);
    protected static final int defaultBatchSize = 100;
    protected final Pattern pattern = Pattern.compile("^(\\d+)(\\D*)", 2);
    protected Properties elasticsearchPropes;
    protected Properties extendElasticsearchPropes;
    protected int batchSize = 100;
    protected long ttlMs = -1L;
    protected String indexName = "trace";
    protected String indexType = "log";
    protected String elasticUser = "";
    protected String elasticPassword = "";
    protected Matcher matcher = this.pattern.matcher("");
    protected String[] restServerAddresses = null;
    protected String origineRestServerAddresses;
    protected ElasticSearchClient restClient = null;
    protected IndexNameBuilder indexNameBuilder;

    public String getOrigineRestServerAddresses() {
        return this.origineRestServerAddresses;
    }

    public void setOrigineRestServerAddresses(String origineRestServerAddresses) {
        this.origineRestServerAddresses = origineRestServerAddresses;
    }

    String[] getRestServerAddresses() {
        return this.restServerAddresses;
    }

    public FastDateFormat getIndexDateFormat() {
        return this.indexNameBuilder.getFastDateFormat();
    }

    String getIndexName() {
        return this.indexName;
    }

    String getIndexType() {
        return this.indexType;
    }

    long getTTLMs() {
        return this.ttlMs;
    }

    IndexNameBuilder getIndexNameBuilder() {
        return this.indexNameBuilder;
    }

    public ClientInterface getRestClientUtil() {
        if (this.restClient != null) {
            return this.restClient.getClientUtil(this.indexNameBuilder);
        }
        return null;
    }

    public ClientInterface getConfigRestClientUtil(String configFile) {
        if (this.restClient != null) {
            return this.restClient.getConfigClientUtil(this.indexNameBuilder, configFile);
        }
        return null;
    }

    public Object executeRequest(String path, String entity) throws Exception {
        ClientInterface clientUtil = this.getRestClientUtil();
        return clientUtil.executeRequest(path, entity);
    }

    public void configure() {
        this.configureWithConfigContext(null);
    }

    public void configureWithConfigContext(BaseApplicationContext configContext) {
        String ttl;
        if (configContext != null) {
            this.setApplicationContext(configContext);
        }
        this.origineRestServerAddresses = this.elasticsearchPropes.getProperty("elasticsearch.rest.hostNames");
        if (SimpleStringUtil.isNotEmpty((String)this.origineRestServerAddresses)) {
            this.origineRestServerAddresses = this.origineRestServerAddresses.trim();
            this.restServerAddresses = this.origineRestServerAddresses.split(",");
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("elasticsearch.indexName"))) {
            this.indexName = this.elasticsearchPropes.getProperty("elasticsearch.indexName");
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("elasticsearch.indexType"))) {
            this.indexType = this.elasticsearchPropes.getProperty("elasticsearch.indexType");
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("batchSize"))) {
            this.batchSize = Integer.parseInt(this.elasticsearchPropes.getProperty("batchSize"));
        }
        if (SimpleStringUtil.isNotEmpty((String)(ttl = this.elasticsearchPropes.getProperty("elasticsearch.ttl")))) {
            this.ttlMs = this.parseTTL(ttl);
            logger.info("elasticsearch.TTL:" + this.ttlMs + ",config value is:" + ttl);
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("elasticUser"))) {
            this.elasticUser = this.elasticsearchPropes.getProperty("elasticUser");
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("elasticPassword"))) {
            this.elasticPassword = this.elasticsearchPropes.getProperty("elasticPassword");
        }
        String indexNameBuilderClass = this.getIndexNameBuilderClass();
        try {
            Class<?> clazz = Class.forName(indexNameBuilderClass);
            this.indexNameBuilder = (IndexNameBuilder)clazz.newInstance();
            this.indexNameBuilder.configure(this.elasticsearchPropes);
            if (configContext == null) {
                this.start();
            }
        }
        catch (Exception e) {
            throw new ElasticSearchException("Could not instantiate index name builder.", e);
        }
    }

    protected String getIndexNameBuilderClass() {
        String indexNameBuilderClass = "org.frameworkset.elasticsearch.TimeBasedIndexNameBuilder";
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("indexNameBuilder"))) {
            indexNameBuilderClass = this.elasticsearchPropes.getProperty("indexNameBuilder");
        }
        return indexNameBuilderClass;
    }

    protected void start() {
        block3: {
            ElasticSearchClientFactory clientFactory = new ElasticSearchClientFactory();
            try {
                if (this.restServerAddresses != null && this.restServerAddresses.length > 0) {
                    logger.info("Start ElasticSearch rest client:" + this.origineRestServerAddresses);
                    this.restClient = clientFactory.getClient(this, "rest", this.restServerAddresses, this.elasticUser, this.elasticPassword, this.extendElasticsearchPropes);
                    this.restClient.configure(this.elasticsearchPropes);
                    this.restClient.init();
                    logger.info("ElasticSearch Transport client started.");
                }
            }
            catch (Exception ex) {
                logger.error("ElasticSearch Rest Client started failed", (Throwable)ex);
                if (this.restClient == null) break block3;
                this.restClient.close();
            }
        }
    }

    public void stop() {
        logger.info("ElasticSearch client stopping");
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    protected long parseTTL(String ttl) {
        this.matcher = this.matcher.reset(ttl);
        if (this.matcher.find()) {
            if (this.matcher.group(2).equals("ms")) {
                return Long.parseLong(this.matcher.group(1));
            }
            if (this.matcher.group(2).equals("s")) {
                return TimeUnit.SECONDS.toMillis(Integer.parseInt(this.matcher.group(1)));
            }
            if (this.matcher.group(2).equals("m")) {
                return TimeUnit.MINUTES.toMillis(Integer.parseInt(this.matcher.group(1)));
            }
            if (this.matcher.group(2).equals("h")) {
                return TimeUnit.HOURS.toMillis(Integer.parseInt(this.matcher.group(1)));
            }
            if (this.matcher.group(2).equals("d")) {
                return TimeUnit.DAYS.toMillis(Integer.parseInt(this.matcher.group(1)));
            }
            if (this.matcher.group(2).equals("w")) {
                return TimeUnit.DAYS.toMillis(7 * Integer.parseInt(this.matcher.group(1)));
            }
            if (this.matcher.group(2).equals("")) {
                logger.info("TTL qualifier is empty. Defaulting to day qualifier.");
                return TimeUnit.DAYS.toMillis(Integer.parseInt(this.matcher.group(1)));
            }
            logger.debug("Unknown TTL qualifier provided. Setting TTL to 0.");
            return 0L;
        }
        logger.info("TTL not provided. Skipping the TTL config by returning 0.");
        return -1L;
    }

    public void setElasticsearchPropes(Properties elasticsearchPropes) {
        this.elasticsearchPropes = elasticsearchPropes;
    }

    public Properties getExtendElasticsearchPropes() {
        return this.extendElasticsearchPropes;
    }
}

