package org.frameworkset.elasticsearch.handler;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.serial.ESClassType;
import org.frameworkset.elasticsearch.serial.ESSerialThreadLocal;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class ElasticSearchResponseHandler extends BaseESResponsehandler {
	private static Logger logger = LoggerFactory.getLogger(ElasticSearchResponseHandler.class);
	
	public ElasticSearchResponseHandler() {
		// TODO Auto-generated constructor stub
	}
	
	public ElasticSearchResponseHandler(ESTypeReferences<?,?> types) {
		super(types);
	}
	public ElasticSearchResponseHandler(ESClassType type) {
		super(type);
	}

	public ElasticSearchResponseHandler(Class<?> type) {
		super(type);
	}

	 @Override
     public RestResponse handleResponse(final HttpResponse response)
             throws ClientProtocolException, IOException {
         int status = response.getStatusLine().getStatusCode();

         if (status >= 200 && status < 300) {
             HttpEntity entity = response.getEntity();
             RestResponse searchResponse = null;
              
             if (entity != null ) {
	             try {	            	
	            	 ESSerialThreadLocal.setESTypeReferences(types);
	            	 return super.converJson(entity,RestResponse.class);
//	                 searchResponse = SimpleStringUtil.json2Object(entity.getContent(), RestResponse.class) ;
	             }
	             catch (Exception e){
					 throw new ElasticSearchException(e);
	             }
	             finally{
	            	 ESSerialThreadLocal.clean();
	             }
             }

             return searchResponse;

         } else {
             HttpEntity entity = response.getEntity();
             if (entity != null ) {
            	 throw new ElasticSearchException(EntityUtils.toString(entity));
//				 String content = EntityUtils.toString(entity);
//                 ErrorResponse searchResponse = null;
//                 try {
//                     searchResponse = entity != null ? SimpleStringUtil.json2Object(content, ErrorResponse.class) : null;
//                 }
//                 catch (Exception e){
//					 throw new ElasticSearchException(content,e);
//                 }
//                 return searchResponse;
             }
             else
                 throw new ElasticSearchException("Unexpected response status: " + status);
         }
     }

}
