/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ErrorWrapper;
import org.frameworkset.elasticsearch.client.TaskFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCall
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(TaskCall.class);
    private String refreshOption;
    private ClientInterface clientInterface;
    private String datas;
    private ErrorWrapper errorWrapper;
    private int taskNo;

    public TaskCall(String refreshOption, String datas, ErrorWrapper errorWrapper, int taskNo) {
        this.refreshOption = refreshOption;
        this.clientInterface = errorWrapper.getClientInterface();
        this.datas = datas;
        this.errorWrapper = errorWrapper;
        this.taskNo = taskNo;
    }

    @Override
    public void run() {
        if (!this.errorWrapper.assertCondition()) {
            if (logger.isWarnEnabled()) {
                logger.warn("Task[" + this.taskNo + "] Assert Execute Condition Failed, Ignore");
            }
            return;
        }
        try {
            if (this.refreshOption == null) {
                this.clientInterface.executeHttp("_bulk", this.datas, "post");
            } else {
                this.clientInterface.executeHttp("_bulk?" + this.refreshOption, this.datas, "post");
            }
        }
        catch (Exception e) {
            this.errorWrapper.setError(e);
            throw new TaskFailedException("Task[" + this.taskNo + "] Assert Execute Failed", e);
        }
    }
}

