/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.handle.ValueExchange;
import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.template.ESUtil;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCRestClientUtil {
    private static Logger logger = LoggerFactory.getLogger(JDBCRestClientUtil.class);
    private ClientInterface clientInterface;

    public JDBCRestClientUtil() {
        this.clientInterface = ElasticSearchHelper.getRestClientUtil();
    }

    public JDBCRestClientUtil(String esCluster) {
        this.clientInterface = ElasticSearchHelper.getRestClientUtil((String)esCluster);
    }

    /*
     * Exception decompiling
     */
    public String addDocuments(String indexName, String indexType, ESJDBC jdbcResultSet, String refreshOption, int batchsize) throws ElasticSearchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object handleDate(ResultSet row, int i) {
        Comparable<Integer> value;
        block6: {
            value = null;
            try {
                try {
                    value = row.getTimestamp(i + 1);
                    if (value != null) {
                        value = ((Timestamp)value).getTime();
                        break block6;
                    }
                    value = 0;
                }
                catch (Exception e) {
                    value = row.getDate(i + 1);
                    if (value != null) {
                        value = ((Date)value).getTime();
                        break block6;
                    }
                    value = 0;
                }
            }
            catch (Exception e) {
                value = 0;
            }
        }
        return value;
    }

    private static Object getValue(ResultSet row, int i, String colName) throws Exception {
        Object value = row.getObject(i + 1);
        return value;
    }

    private static Object getFileValue(ESJDBC jdbcResultSet, String fileName) throws SQLException {
        if (fileName != null) {
            Object id = jdbcResultSet.getResultSet().getObject(fileName);
            return id;
        }
        return null;
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, ESJDBC jdbcResultSet, String action) throws Exception {
        Object id = JDBCRestClientUtil.getFileValue(jdbcResultSet, jdbcResultSet.getEsIdField());
        Object parentId = JDBCRestClientUtil.getFileValue(jdbcResultSet, jdbcResultSet.getEsParentIdField());
        Object routing = JDBCRestClientUtil.getFileValue(jdbcResultSet, jdbcResultSet.getRoutingField());
        if (routing == null) {
            routing = jdbcResultSet.getRoutingValue();
        }
        Integer esRetryOnConflict = jdbcResultSet.getEsRetryOnConflict();
        JDBCRestClientUtil.buildMeta(writer, indexType, indexName, jdbcResultSet, action, id, parentId, routing, esRetryOnConflict);
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, ESJDBC esjdbc, String action, Object id, Object parentId, Object routing, Object esRetryOnConflict) throws Exception {
        if (id != null) {
            String versionType;
            Object version;
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            writer.write("\", \"_type\" : \"");
            writer.write(indexType);
            writer.write("\", \"_id\" : ");
            BuildTool.buildId((Object)id, (Writer)writer, (boolean)true);
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
            }
            if (routing != null) {
                writer.write(", \"_routing\" : ");
                BuildTool.buildId((Object)routing, (Writer)writer, (boolean)true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if ((version = JDBCRestClientUtil.getFileValue(esjdbc, esjdbc.getEsVersionField())) != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if ((versionType = esjdbc.getEsVersionType()) != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write(" } }\n");
        } else {
            String versionType;
            Object version;
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            writer.write("\", \"_type\" : \"");
            writer.write(indexType);
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
            }
            if (routing != null) {
                writer.write(", \"_routing\" : ");
                BuildTool.buildId((Object)routing, (Writer)writer, (boolean)true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if ((version = JDBCRestClientUtil.getFileValue(esjdbc, esjdbc.getEsVersionField())) != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if ((versionType = esjdbc.getEsVersionType()) != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write("\" } }\n");
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, ESJDBC jdbcResultSet, String action) throws Exception {
        if (jdbcResultSet != null) {
            BuildTool.buildMeta((Writer)writer, (String)indexType, (String)indexName, (Object)((Object)jdbcResultSet), (String)action);
            if (!action.equals("update")) {
                JDBCRestClientUtil.serialResult(writer, jdbcResultSet);
            } else {
                writer.write("{\"doc\":");
                JDBCRestClientUtil.serialResult(writer, jdbcResultSet);
                if (jdbcResultSet.getEsDocAsUpsert() != null) {
                    writer.write(",\"doc_as_upsert\":");
                    writer.write(String.valueOf(jdbcResultSet.getEsDocAsUpsert()));
                }
                if (jdbcResultSet.getEsReturnSource() != null) {
                    writer.write(",\"_source\":");
                    writer.write(String.valueOf(jdbcResultSet.getEsReturnSource()));
                }
                writer.write("}\n");
            }
        }
    }

    private static void serialResult(Writer writer, ESJDBC esjdbc) throws Exception {
        PoolManResultSetMetaData metaData = esjdbc.getMetaData();
        int counts = metaData.getColumnCount();
        writer.write("{");
        Boolean useJavaName = esjdbc.getUseJavaName();
        if (useJavaName == null) {
            useJavaName = true;
        }
        for (int i = 0; i < counts; ++i) {
            String colName = metaData.getColumnLabelUpperByIndex(i);
            if ("ROWNUM__".equals(colName)) continue;
            String javaName = null;
            FieldMeta fieldMeta = esjdbc.getMappingName(colName);
            if (fieldMeta != null) {
                if (fieldMeta.getIgnore() != null && fieldMeta.getIgnore().booleanValue()) continue;
                javaName = fieldMeta.getEsFieldName();
            } else {
                String string = javaName = useJavaName != false ? metaData.getColumnJavaNameByIndex(i) : colName;
            }
            if (javaName == null) {
                javaName = colName;
            }
            if (i > 0) {
                writer.write(",");
            }
            writer.write("\"");
            writer.write(javaName);
            writer.write("\":");
            Object value = JDBCRestClientUtil.getValue(esjdbc.getResultSet(), i, colName);
            if (value != null) {
                CharEscapeUtil charEscapeUtil;
                String dataStr;
                if (value instanceof String) {
                    writer.write("\"");
                    CharEscapeUtil charEscapeUtil2 = new CharEscapeUtil(writer);
                    charEscapeUtil2.writeString((String)value, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof java.util.Date) {
                    DateFormateMeta dateFormateMeta;
                    DateFormat dateFormat = null;
                    if (fieldMeta != null && (dateFormateMeta = fieldMeta.getDateFormateMeta()) != null) {
                        dateFormat = dateFormateMeta.toDateFormat();
                    }
                    if (dateFormat == null) {
                        dateFormat = esjdbc.getFormat();
                    }
                    String dataStr2 = ESUtil.getDate((java.util.Date)((java.util.Date)value), (DateFormat)dateFormat);
                    writer.write("\"");
                    writer.write(dataStr2);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Clob) {
                    dataStr = ValueExchange.getStringFromClob((Clob)((Clob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Blob) {
                    dataStr = ValueExchange.getStringFromBlob((Blob)((Blob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                writer.write(String.valueOf(value));
                continue;
            }
            writer.write("null");
        }
        writer.write("}\n");
    }
}

