/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.frameworkset.elasticsearch.client.DBESThread;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.persitent.util.JDBCResultSet;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESJDBC
extends JDBCResultSet {
    private static Logger logger = LoggerFactory.getLogger(ESJDBC.class);
    private boolean parallel;
    private int threadCount = 200;
    private int queue = Integer.MAX_VALUE;
    private String applicationPropertiesFile;
    private boolean usePool = false;
    private String esIdField;
    private String esParentIdField;
    private String routingField;
    private String routingValue;
    private Boolean esDocAsUpsert;
    private Integer esRetryOnConflict;
    private Boolean esReturnSource;
    private String esVersionField;
    private String esVersionType;
    private Boolean useJavaName;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private DateFormat format;
    private Map<String, FieldMeta> fieldMetaMap;
    private String sql;
    private String dbName;
    private String refreshOption;
    private int batchSize = 1000;
    private String index;
    private String dbDriver;
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private String validateSQL;
    private AtomicInteger rejectCounts = new AtomicInteger();
    private String indexType;

    public String getApplicationPropertiesFile() {
        return this.applicationPropertiesFile;
    }

    public void setApplicationPropertiesFile(String applicationPropertiesFile) {
        this.applicationPropertiesFile = applicationPropertiesFile;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getValidateSQL() {
        return this.validateSQL;
    }

    public void setValidateSQL(String validateSQL) {
        this.validateSQL = validateSQL;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getRefreshOption() {
        return this.refreshOption;
    }

    public void setRefreshOption(String refreshOption) {
        this.refreshOption = refreshOption;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public Integer getEsRetryOnConflict() {
        return this.esRetryOnConflict;
    }

    public void setEsRetryOnConflict(Integer esRetryOnConflict) {
        this.esRetryOnConflict = esRetryOnConflict;
    }

    public Boolean getEsDocAsUpsert() {
        return this.esDocAsUpsert;
    }

    public void setEsDocAsUpsert(Boolean esDocAsUpsert) {
        this.esDocAsUpsert = esDocAsUpsert;
    }

    public String getRoutingValue() {
        return this.routingValue;
    }

    public void setRoutingValue(String routingValue) {
        this.routingValue = routingValue;
    }

    public String getRoutingField() {
        return this.routingField;
    }

    public void setRoutingField(String routingField) {
        this.routingField = routingField;
    }

    public String getEsParentIdField() {
        return this.esParentIdField;
    }

    public void setEsParentIdField(String esParentIdField) {
        this.esParentIdField = esParentIdField;
    }

    public String getEsIdField() {
        return this.esIdField;
    }

    public void setEsIdField(String esIdField) {
        this.esIdField = esIdField;
    }

    public Boolean getEsReturnSource() {
        return this.esReturnSource;
    }

    public void setEsReturnSource(Boolean esReturnSource) {
        this.esReturnSource = esReturnSource;
    }

    public String getEsVersionField() {
        return this.esVersionField;
    }

    public void setEsVersionField(String esVersionField) {
        this.esVersionField = esVersionField;
    }

    public String getEsVersionType() {
        return this.esVersionType;
    }

    public void setEsVersionType(String esVersionType) {
        this.esVersionType = esVersionType;
    }

    public Boolean getUseJavaName() {
        return this.useJavaName;
    }

    public void setUseJavaName(Boolean useJavaName) {
        this.useJavaName = useJavaName;
    }

    public DateFormateMeta getDateFormateMeta() {
        return DateFormateMeta.buildDateFormateMeta((String)this.dateFormat, (String)this.locale, (String)this.timeZone);
    }

    public DateFormat getFormat() {
        if (this.format == null) {
            DateFormateMeta dateFormateMeta = this.getDateFormateMeta();
            if (dateFormateMeta == null) {
                dateFormateMeta = SerialUtil.getDateFormateMeta();
            }
            this.format = dateFormateMeta.toDateFormat();
        }
        return this.format;
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public Map<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    public void destroy() {
        this.format = null;
    }

    public void setFieldMetaMap(Map<String, FieldMeta> fieldMetaMap) {
        this.fieldMetaMap = fieldMetaMap;
    }

    public FieldMeta getMappingName(String colName) {
        if (this.fieldMetaMap != null) {
            return this.fieldMetaMap.get(colName);
        }
        return null;
    }

    public boolean isUsePool() {
        return this.usePool;
    }

    public void setUsePool(boolean usePool) {
        this.usePool = usePool;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public ExecutorService buildThreadPool() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.getThreadCount(), this.getThreadCount(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.getQueue()), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new DBESThread(r);
            }
        }, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                int t;
                int counts = ESJDBC.this.rejectCounts.incrementAndGet();
                if (logger.isInfoEnabled() && (t = counts / 1000) == 0) {
                    logger.info("DB to Elasticsearch Date Import Task rejected  " + counts + " times.");
                }
            }
        });
        return executor;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }
}

