/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.io;

import com.frameworkset.util.EditorInf;
import com.frameworkset.util.SimpleStringUtil;
import org.frameworkset.util.Assert;
import org.frameworkset.util.SystemPropertyUtils;
import org.frameworkset.util.io.DefaultResourceLoader;
import org.frameworkset.util.io.Resource;
import org.frameworkset.util.io.ResourceLoader;

public class ResourceEditor
implements EditorInf<Resource> {
    private final ResourceLoader resourceLoader;

    public ResourceEditor() {
        this(new DefaultResourceLoader());
    }

    public ResourceEditor(ResourceLoader resourceLoader) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders(path);
    }

    @Override
    public Resource getValueFromObject(Object fromValue) {
        return null;
    }

    @Override
    public Resource getValueFromString(String text) {
        if (SimpleStringUtil.hasText(text)) {
            String locationToUse = this.resolvePath(text).trim();
            return this.resourceLoader.getResource(locationToUse);
        }
        return null;
    }
}

