/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.annotations.wraper;

import com.frameworkset.util.SimpleStringUtil;
import java.util.Locale;
import org.frameworkset.util.annotations.AnnotationUtils;
import org.frameworkset.util.annotations.Attribute;
import org.frameworkset.util.annotations.AttributeScope;

public class AttributeWraper {
    private String name;
    private boolean required;
    private String editor;
    private AttributeScope scope;
    private String defaultvalue;
    private String dateformat;
    private Locale locale;

    public AttributeWraper(Attribute attr) {
        this.required = attr.required();
        this.name = attr.name();
        this.editor = attr.editor();
        this.scope = attr.scope();
        this.dateformat = AnnotationUtils.converDefaultValue(attr.dateformat());
        this.defaultvalue = AnnotationUtils.converDefaultValue(attr.defaultvalue());
        if (SimpleStringUtil.isNotEmpty(attr.locale())) {
            try {
                this.locale = new Locale(attr.locale());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String name() {
        return this.name;
    }

    public boolean required() {
        return this.required;
    }

    public String editor() {
        return this.editor;
    }

    public AttributeScope scope() {
        return this.scope;
    }

    public String defaultvalue() {
        return this.defaultvalue;
    }

    public String dateformat() {
        return this.dateformat;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

