/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.UUID;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.frameworkset.json.JacksonObjectMapperWrapper;
import org.frameworkset.json.JsonTypeReference;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.util.CollectionUtils;
import org.frameworkset.util.DataFormatUtil;
import org.frameworkset.util.ObjectUtils;
import org.frameworkset.util.encoder.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStringUtil {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleStringUtil.class);
    public static final String COMMA = ",";
    public static final String BLANK = "";
    private static JacksonObjectMapperWrapper objectMapper = null;
    public static final int SPLIT_ALL = 0;
    private static BitSet dontNeedEncoding;
    private static String dfltEncName;
    static final int caseDiff = 32;
    private static String ip;
    public static final int INDEX_NOT_FOUND = -1;
    public static final String EMPTY = "";
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static final char EXTENSION_SEPARATOR = '.';
    public static final String AOP_PROPERTIES_PATH = "/aop.properties";
    private static Map<String, Locale> localesIndexByString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initJacksonObjectMapperWrapper() {
        if (objectMapper != null) return;
        Class<SimpleStringUtil> clazz = SimpleStringUtil.class;
        synchronized (SimpleStringUtil.class) {
            if (objectMapper != null) return;
            objectMapper = new JacksonObjectMapperWrapper();
            objectMapper.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static JacksonObjectMapperWrapper getJacksonObjectMapper() {
        SimpleStringUtil.initJacksonObjectMapperWrapper();
        return objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getDfltEncName() {
        if (dfltEncName != null) return dfltEncName;
        Class<SimpleStringUtil> clazz = SimpleStringUtil.class;
        synchronized (SimpleStringUtil.class) {
            if (dfltEncName != null) return dfltEncName;
            dfltEncName = System.getProperty("file.encoding");
            // ** MonitorExit[var0] (shouldn't be in output)
            return dfltEncName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BitSet initDontNeedEncoding() {
        if (dontNeedEncoding != null) return dontNeedEncoding;
        Class<SimpleStringUtil> clazz = SimpleStringUtil.class;
        synchronized (SimpleStringUtil.class) {
            int i;
            if (dontNeedEncoding != null) return dontNeedEncoding;
            dontNeedEncoding = new BitSet(256);
            for (i = 97; i <= 122; ++i) {
                dontNeedEncoding.set(i);
            }
            for (i = 65; i <= 90; ++i) {
                dontNeedEncoding.set(i);
            }
            for (i = 48; i <= 57; ++i) {
                dontNeedEncoding.set(i);
            }
            dontNeedEncoding.set(32);
            dontNeedEncoding.set(45);
            dontNeedEncoding.set(95);
            dontNeedEncoding.set(46);
            dontNeedEncoding.set(42);
            // ** MonitorExit[var0] (shouldn't be in output)
            return dontNeedEncoding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getIp() {
        if (ip != null) {
            return ip;
        }
        Class<SimpleStringUtil> clazz = SimpleStringUtil.class;
        synchronized (SimpleStringUtil.class) {
            if (ip == null) {
                try {
                    InetAddress addr = InetAddress.getLocalHost();
                    String ip_ = addr.getHostAddress();
                    String address = addr.getHostName();
                    ip = ip_ + "-" + address;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ip = "";
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ip;
        }
    }

    public static String getHostIP() {
        return SimpleStringUtil.getIp();
    }

    public static String[] split(String s) {
        return SimpleStringUtil.split(s, COMMA);
    }

    public static TimeZone parseTimeZoneString(String timeZoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        if ("GMT".equals(timeZone.getID()) && !timeZoneString.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + timeZoneString + "'");
        }
        return timeZone;
    }

    public static String[] split(String s, String delimiter) {
        return SimpleStringUtil.split(s, delimiter, true);
    }

    public static String getRealPath(String contextPath, String path) {
        return SimpleStringUtil.getRealPath(contextPath, path, false);
    }

    public static void getRealPath(StringBuilder builder, String contextPath, String path) {
        SimpleStringUtil.getRealPath(builder, contextPath, path, false);
    }

    public static boolean isHttpUrl(String path) {
        if (path == null) {
            return false;
        }
        return path.startsWith("http://") || path.startsWith("https://") || path.startsWith("ftp://") || path.startsWith("tps://");
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getRealPath(String contextPath, String path, boolean usebase) {
        if (SimpleStringUtil.isHttpUrl(path)) {
            return path;
        }
        if (contextPath == null || contextPath.equals("") || contextPath.equals(FOLDER_SEPARATOR)) {
            if (usebase) {
                if (SimpleStringUtil.isEmpty(path)) {
                    return FOLDER_SEPARATOR;
                }
                return path.startsWith(FOLDER_SEPARATOR) ? path : FOLDER_SEPARATOR + path;
            }
            return path == null ? "" : path;
        }
        if (path == null || path.equals("")) {
            return contextPath;
        }
        contextPath = contextPath.replace('\\', '/');
        if ((path = path.replace('\\', '/')).startsWith(FOLDER_SEPARATOR)) {
            if (!contextPath.endsWith(FOLDER_SEPARATOR)) {
                return contextPath + path;
            }
            return contextPath.substring(0, contextPath.length() - 1) + path;
        }
        if (!contextPath.endsWith(FOLDER_SEPARATOR)) {
            return contextPath + FOLDER_SEPARATOR + path;
        }
        return contextPath + path;
    }

    public static void getRealPath(StringBuilder builder, String contextPath, String path, boolean usebase) {
        if (SimpleStringUtil.isHttpUrl(path)) {
            builder.append(path);
            return;
        }
        if (contextPath == null || contextPath.equals("") || contextPath.equals(FOLDER_SEPARATOR)) {
            if (usebase) {
                if (SimpleStringUtil.isEmpty(path)) {
                    builder.append(FOLDER_SEPARATOR);
                    return;
                }
                if (path.startsWith(FOLDER_SEPARATOR)) {
                    builder.append(path);
                } else {
                    builder.append(FOLDER_SEPARATOR).append(path);
                }
                return;
            }
            if (path != null) {
                builder.append(path);
            }
            return;
        }
        if (path == null || path.equals("")) {
            builder.append(contextPath);
            return;
        }
        contextPath = contextPath.replace('\\', '/');
        if ((path = path.replace('\\', '/')).startsWith(FOLDER_SEPARATOR)) {
            if (!contextPath.endsWith(FOLDER_SEPARATOR)) {
                builder.append(contextPath).append(path);
                return;
            }
            builder.append(contextPath.substring(0, contextPath.length() - 1)).append(path);
            return;
        }
        if (contextPath.endsWith(FOLDER_SEPARATOR)) {
            builder.append(contextPath).append(path);
            return;
        }
        builder.append(contextPath).append(FOLDER_SEPARATOR).append(path);
    }

    public static boolean containKey(String[] values, String key) {
        if (values == null || key == null) {
            return false;
        }
        boolean contain = false;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(key)) continue;
            contain = true;
            break;
        }
        return contain;
    }

    public static String getNormalPath(String parent, String file) {
        if (parent.endsWith(FOLDER_SEPARATOR) && !file.startsWith(FOLDER_SEPARATOR)) {
            return parent + file;
        }
        if (!parent.endsWith(FOLDER_SEPARATOR) && file.startsWith(FOLDER_SEPARATOR)) {
            return parent + file;
        }
        if (!parent.endsWith(FOLDER_SEPARATOR) && !file.startsWith(FOLDER_SEPARATOR)) {
            return parent + FOLDER_SEPARATOR + file;
        }
        return parent + file.substring(1);
    }

    public static String getFormatDate(java.util.Date date, String formate) {
        SimpleDateFormat dateFormat = DataFormatUtil.getSimpleDateFormat(formate);
        if (date == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public static java.util.Date stringToDate(String date) {
        if (date == null || date.trim().equals("")) {
            return null;
        }
        SimpleDateFormat format = DataFormatUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            return new java.util.Date(date);
        }
    }

    public static java.util.Date stringToDate(String date, String format_) {
        if (date == null || date.trim().equals("")) {
            return null;
        }
        SimpleDateFormat format = DataFormatUtil.getSimpleDateFormat(format_);
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            return new java.util.Date(date);
        }
    }

    public static String getFileName(String path) {
        int index = path.lastIndexOf(47);
        String fileName = "";
        if (index == -1) {
            index = path.lastIndexOf(92);
        }
        fileName = path.substring(index + 1);
        return fileName;
    }

    public static String getFileName(String prefix, String extension) throws UnsupportedEncodingException {
        String fileName = URLEncoder.encode(prefix);
        int limit = 150 - extension.length();
        if (fileName.length() > limit) {
            fileName = URLEncoder.encode(prefix.substring(0, Math.min(prefix.length(), limit / 9)));
        }
        return fileName + extension;
    }

    public static String[] dateArrayTOStringArray(java.util.Date[] dates) {
        if (dates == null) {
            return null;
        }
        SimpleDateFormat format = DataFormatUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String[] dates_s = new String[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            dates_s[i] = format.format(dates[i]);
        }
        return dates_s;
    }

    public static java.util.Date[] stringArrayTODateArray(String[] dates_s, SimpleDateFormat dateformat) {
        if (dates_s == null) {
            return null;
        }
        java.util.Date[] dates = new java.util.Date[dates_s.length];
        for (int i = 0; i < dates_s.length; ++i) {
            long dl;
            if (dateformat != null) {
                try {
                    dates[i] = dateformat.parse(dates_s[i]);
                }
                catch (ParseException e) {
                    dl = Long.parseLong(dates_s[i]);
                    dates[i] = new java.util.Date(dl);
                }
                continue;
            }
            try {
                dates[i] = new java.util.Date(dates_s[i]);
                continue;
            }
            catch (Exception e) {
                dl = Long.parseLong(dates_s[i]);
                dates[i] = new java.util.Date(dl);
            }
        }
        return dates;
    }

    public static java.util.Date[] longArrayTODateArray(long[] dates_s, SimpleDateFormat dateformat) {
        if (dates_s == null) {
            return null;
        }
        java.util.Date[] dates = new java.util.Date[dates_s.length];
        for (int i = 0; i < dates_s.length; ++i) {
            dates[i] = new java.util.Date(dates_s[i]);
        }
        return dates;
    }

    public static Date[] stringArrayTOSQLDateArray(String[] dates_s, SimpleDateFormat dateformat) {
        if (dates_s == null) {
            return null;
        }
        Date[] dates = new Date[dates_s.length];
        for (int i = 0; i < dates_s.length; ++i) {
            long dl;
            if (dateformat != null) {
                try {
                    dates[i] = new Date(dateformat.parse(dates_s[i]).getTime());
                }
                catch (ParseException e) {
                    dl = Long.parseLong(dates_s[i]);
                    dates[i] = new Date(dl);
                }
                continue;
            }
            try {
                dates[i] = new Date(new java.util.Date(dates_s[i]).getTime());
                continue;
            }
            catch (Exception e) {
                dl = Long.parseLong(dates_s[i]);
                dates[i] = new Date(dl);
            }
        }
        return dates;
    }

    public static Date[] longArrayTOSQLDateArray(long[] dates_s, SimpleDateFormat dateformat) {
        if (dates_s == null) {
            return null;
        }
        Date[] dates = new Date[dates_s.length];
        for (int i = 0; i < dates_s.length; ++i) {
            dates[i] = new Date(dates_s[i]);
        }
        return dates;
    }

    public static Timestamp[] stringArrayTOTimestampArray(String[] dates_s, SimpleDateFormat dateformat) {
        if (dates_s == null) {
            return null;
        }
        Timestamp[] dates = new Timestamp[dates_s.length];
        for (int i = 0; i < dates_s.length; ++i) {
            long dl;
            if (dateformat != null) {
                try {
                    dates[i] = new Timestamp(dateformat.parse(dates_s[i]).getTime());
                }
                catch (ParseException e) {
                    dl = Long.parseLong(dates_s[i]);
                    dates[i] = new Timestamp(dl);
                }
                continue;
            }
            try {
                dates[i] = new Timestamp(new java.util.Date(dates_s[i]).getTime());
                continue;
            }
            catch (Exception e) {
                dl = Long.parseLong(dates_s[i]);
                dates[i] = new Timestamp(dl);
            }
        }
        return dates;
    }

    public static Timestamp[] longArrayTOTimestampArray(long[] dates_s, SimpleDateFormat dateformat) {
        if (dates_s == null) {
            return null;
        }
        Timestamp[] dates = new Timestamp[dates_s.length];
        for (int i = 0; i < dates_s.length; ++i) {
            dates[i] = new Timestamp(dates_s[i]);
        }
        return dates;
    }

    public static String replace(String text, String searchString, String replacement) {
        return SimpleStringUtil.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (SimpleStringUtil.isEmpty(text) || SimpleStringUtil.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (SimpleStringUtil.isEmpty(str) || SimpleStringUtil.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = "";
        }
        boolean modified = false;
        int replaceCharsLength = replaceChars.length();
        int strLength = str.length();
        StringBuilder buf = new StringBuilder(strLength);
        for (int i = 0; i < strLength; ++i) {
            char ch = str.charAt(i);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                if (index >= replaceCharsLength) continue;
                buf.append(replaceChars.charAt(index));
                continue;
            }
            buf.append(ch);
        }
        if (modified) {
            return buf.toString();
        }
        return str;
    }

    public static String replaceAll(String val, String str1, String str2) {
        return SimpleStringUtil.replaceAll(val, str1, str2, true);
    }

    public static String replaceFirst(String val, String str1, String str2) {
        return SimpleStringUtil.replaceFirst(val, str1, str2, true);
    }

    public static String replaceFirst(String val, String str1, String str2, boolean CASE_INSENSITIVE) {
        String patternStr = str1;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = CASE_INSENSITIVE ? compiler.compile(patternStr, 0) : compiler.compile(patternStr, 1);
            Perl5Matcher matcher = new Perl5Matcher();
            return Util.substitute((PatternMatcher)matcher, (Pattern)pattern, (Substitution)new StringSubstitution(str2), (String)val);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return val;
        }
    }

    public static String replaceAll(String val, String str1, String str2, boolean CASE_INSENSITIVE) {
        String patternStr = str1;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = CASE_INSENSITIVE ? compiler.compile(patternStr, 0) : compiler.compile(patternStr, 1);
            Perl5Matcher matcher = new Perl5Matcher();
            return Util.substitute((PatternMatcher)matcher, (Pattern)pattern, (Substitution)new StringSubstitution(str2), (String)val, (int)-1);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return val;
        }
    }

    public static String replaceAll(String val, String str1, String str2, int mask) {
        String patternStr = str1;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, mask);
            Perl5Matcher matcher = new Perl5Matcher();
            return Util.substitute((PatternMatcher)matcher, (Pattern)pattern, (Substitution)new StringSubstitution(str2), (String)val, (int)-1);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return val;
        }
    }

    public static String[] split(String val, String token, boolean CASE_INSENSITIVE) {
        String patternStr = token;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = CASE_INSENSITIVE ? compiler.compile(patternStr, 0) : compiler.compile(patternStr, 1);
            Perl5Matcher matcher = new Perl5Matcher();
            ArrayList list = new ArrayList();
            SimpleStringUtil.split(list, (PatternMatcher)matcher, pattern, val, 0);
            String[] rets = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                rets[i] = (String)list.get(i);
            }
            return rets;
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return new String[]{val};
        }
    }

    public static String[] split(String val, String token, int mask) {
        String patternStr = token;
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, mask);
            Perl5Matcher matcher = new Perl5Matcher();
            ArrayList list = new ArrayList();
            SimpleStringUtil.split(list, (PatternMatcher)matcher, pattern, val, 0);
            String[] rets = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                rets[i] = (String)list.get(i);
            }
            return rets;
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return new String[]{val};
        }
    }

    private static void split(Collection results, PatternMatcher matcher, Pattern pattern, String input, int limit) {
        PatternMatcherInput pinput = new PatternMatcherInput(input);
        int beginOffset = 0;
        while (--limit != 0 && matcher.contains(pinput, pattern)) {
            MatchResult currentResult = matcher.getMatch();
            results.add(input.substring(beginOffset, currentResult.beginOffset(0)));
            beginOffset = currentResult.endOffset(0);
        }
        results.add(input.substring(beginOffset, input.length()));
    }

    public static String replaceNull(String resource) {
        return resource == null ? "" : resource;
    }

    public static void main(String[] args) {
        int maxlength = 16;
        String replace = "...";
        String outStr = "2010\u5e7402\u670804\u65e512\u65f6\u8bb8\uff0c\u4f55\u91d1\u7476\uff08\u5973\u30011987\u5e7406\u670818\u65e5\u751f\u3001\u8eab\u4efd\u8bc1\uff1a430981198706184686\u3001\u6e56\u5357\u7701\u6c85\u6c5f\u5e02\u6c85\u6c5f\u5e02\u5357\u5927\u81b3\u9547\u5eb7\u5b81\u6751\u5341\u4e8c\u6751\u6c11\u7ec424\u53f7\uff09\u62a5\u8b66\uff1a\u5176\u7ecf\u8425\u7684\u76ca\u9633\u5e02\u7535\u4fe1\u5bf9\u9762\u7684\u6674\u5929\u670d\u88c5\u5e97\u88ab\u76d7\u4e86\u3002\u63a5\u8b66\u540e\u6211\u6240\u6c11\u8b66\u7acb\u5373\u8d76\u81f3\u73b0\u573a\u4e86\u89e3\u7cfb\uff0c\u4eca\u65e5\u4e2d\u534812\u65f6\u8bb8\u4f55\u91d1\u7476\u4e0e\u6bcd\u4eb2\u9ec4\u5fd7\u5143\u5728\u5e97\u5185\u505a\u751f\u610f\uff0c\u6709\u4e24\u7537\u5b50\u8fdb\u5165\u5e97\u5185\uff0c\u5176\u4e2d\u4e00\u7537\u5b50\u4ee5\u642c\u5e97\u5185\u7684\u8bd5\u8863\u955c\u51fa\u53bb\u5438\u5f15\u6ce8\u610f\u529b\u3002\u53e6\u4e00\u7537\u5b50\u5c31\u8fdb\u884c\u76d7\u7a83\uff0c\u76d7\u53d6\u4e86\u5176\u5e97\u5185\u6536\u94f6\u53f0\u62bd\u5c49\u5185700\u5143\u4eba\u6c11\u5e01";
        System.out.println(SimpleStringUtil.getHandleString(maxlength, replace, false, false, outStr));
        outStr = "2010\u5e7402\u670807\u65e511\u65f6\u8bb8\uff0c\u5468\u7075\u9896\u62a5\u8b66\uff1a\u57282\u8def\u516c\u4ea4\u8f66\u4e0a\u88ab\u6252\u7a83\uff0c\u5e76\u6293\u83b7\u4e00\u540d\u5acc\u7591\u4eba\u3002\u6c11\u8b66\u51fa\u8b66\u540e\uff0c\u7ecf\u8c03\u67e5\uff0c\u5468\u7075\u9896\u4e8e\u5f53\u65e510\u65f640\u5206\u8bb8\u57502\u8def\u8f66\u5230\u6865\u5357\uff0c\u9014\u4e2d\u88ab\u4e8c\u540d\u7537\u5b50\u6252\u7a83\u73b0\u91d13100\u5143\u3002\u4e00\u540d\u88ab\u5f53\u573a\u6293\u83b7\uff0c\u53e6\u4e00\u540d\u5df2\u9003\u8d70\u3002 ";
        System.out.println(SimpleStringUtil.getHandleString(maxlength, replace, false, false, outStr));
    }

    public static String encode(String s, String enc) {
        if (enc == null || enc.trim().equals("")) {
            enc = SimpleStringUtil.getDfltEncName();
        }
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuilder out = new StringBuilder(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, enc);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (SimpleStringUtil.initDontNeedEncoding().get(c)) {
                if (c == 32) {
                    c = 43;
                    needToChange = true;
                }
                out.append((char)c);
                wroteUnencodedChar = true;
                continue;
            }
            try {
                char d;
                if (wroteUnencodedChar) {
                    writer = new OutputStreamWriter((OutputStream)buf, enc);
                    wroteUnencodedChar = false;
                }
                writer.write(c);
                if (c >= 55296 && c <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    writer.write(d);
                    ++i;
                }
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    public static String encode(String s) {
        return SimpleStringUtil.encode(s, SimpleStringUtil.getDfltEncName());
    }

    public static String toUTF(String inpara) {
        String rtstr = new String("");
        if (inpara == null) {
            inpara = "";
        }
        for (int i = 0; i < inpara.length(); ++i) {
            char temchr = inpara.charAt(i);
            int ascchr = temchr + '\u0000';
            rtstr = rtstr + "&#x" + Integer.toHexString(ascchr) + ";";
        }
        return rtstr;
    }

    public static String toGB2312(String inpara) {
        if (inpara == null) {
            inpara = "";
        }
        try {
            char[] temp = inpara.toCharArray();
            byte[] b = new byte[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                b[i] = (byte)temp[i];
                byte tempint = b[i];
            }
            String deststring = new String(b, "gb2312");
            return deststring;
        }
        catch (UnsupportedEncodingException e) {
            return "\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801";
        }
    }

    public List splitString(String src, int size) {
        if (src == null) {
            return null;
        }
        ArrayList<String> segs = new ArrayList<String>();
        StringBuilder seg = new StringBuilder();
        while (src.length() > size) {
        }
        if (src.length() <= size) {
            segs.add(src);
            return segs;
        }
        return null;
    }

    public String splitString(String src, int offset, int size) {
        if (src == null || src.equals("")) {
            return "";
        }
        if (offset < src.length()) {
            return src.substring(offset, size);
        }
        int n = src.length() % size;
        return (String)this.splitString(src, size).get(offset);
    }

    public static String replaceNull(String value, String nullReplace) {
        return value == null ? nullReplace : value;
    }

    public static boolean getBoolean(String value, boolean nullReplace) {
        boolean ret = false;
        ret = value == null ? nullReplace : value.trim().equalsIgnoreCase("true");
        return ret;
    }

    public static int getInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isJavascript(String nodeLink) {
        return nodeLink != null && nodeLink.toLowerCase().startsWith("javascript:");
    }

    public static String HTMLEncode(String text) {
        if (SimpleStringUtil.isEmpty(text)) {
            return text;
        }
        text = SimpleStringUtil.replaceAll(text, "&", "&amp;");
        text = SimpleStringUtil.replaceAll(text, "\"", "&quot;");
        text = SimpleStringUtil.replaceAll(text, "<", "&lt;");
        text = SimpleStringUtil.replaceAll(text, ">", "&gt;");
        text = SimpleStringUtil.replaceAll(text, "'", "&#146;");
        text = SimpleStringUtil.replaceAll(text, "\\ ", "&nbsp;");
        text = SimpleStringUtil.replaceAll(text, "\n", "<br>");
        text = SimpleStringUtil.replaceAll(text, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        return text;
    }

    public static String HTMLNoBREncode(String text) {
        if (SimpleStringUtil.isEmpty(text)) {
            return text;
        }
        text = SimpleStringUtil.replaceAll(text, "&", "&amp;");
        text = SimpleStringUtil.replaceAll(text, "\"", "&quot;");
        text = SimpleStringUtil.replaceAll(text, "<", "&lt;");
        text = SimpleStringUtil.replaceAll(text, ">", "&gt;");
        text = SimpleStringUtil.replaceAll(text, "'", "&#146;");
        text = SimpleStringUtil.replaceAll(text, "\\ ", "&nbsp;");
        return text;
    }

    public static String HTMLEncodej(String text) {
        if (SimpleStringUtil.isEmpty(text)) {
            return text;
        }
        text = SimpleStringUtil.replaceAll(text, "&amp;", "&");
        text = SimpleStringUtil.replaceAll(text, "&quot;", "\"");
        text = SimpleStringUtil.replaceAll(text, "&lt;", "<");
        text = SimpleStringUtil.replaceAll(text, "&gt;", ">");
        text = SimpleStringUtil.replaceAll(text, "&#146;", "'");
        text = SimpleStringUtil.replaceAll(text, "&nbsp;", "\\ ");
        text = SimpleStringUtil.replaceAll(text, "<br>", "\n");
        text = SimpleStringUtil.replaceAll(text, "&nbsp;&nbsp;&nbsp;&nbsp;", "\t");
        return text;
    }

    public static String HTMLNoBREncodej(String text) {
        if (SimpleStringUtil.isEmpty(text)) {
            return text;
        }
        text = SimpleStringUtil.replaceAll(text, "&amp;", "&");
        text = SimpleStringUtil.replaceAll(text, "&quot;", "\"");
        text = SimpleStringUtil.replaceAll(text, "&lt;", "<");
        text = SimpleStringUtil.replaceAll(text, "&gt;", ">");
        text = SimpleStringUtil.replaceAll(text, "&#146;", "'");
        text = SimpleStringUtil.replaceAll(text, "&nbsp;", "\\ ");
        return text;
    }

    public static String getHandleString(int maxlength, String replace, boolean htmlencode, boolean htmldecode, String outStr) {
        if (maxlength > 0 && outStr != null && outStr.length() > maxlength) {
            outStr = outStr.substring(0, maxlength);
            if (replace != null) {
                outStr = outStr + replace;
            }
        }
        if (htmlencode) {
            return SimpleStringUtil.HTMLNoBREncode(outStr);
        }
        if (htmldecode) {
            return SimpleStringUtil.HTMLNoBREncodej(outStr);
        }
        return outStr;
    }

    public static String buildStringMessage(List messages) {
        if (messages == null || messages.size() == 0) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < messages.size(); ++i) {
            if (i == 0) {
                str.append(messages.get(i));
                continue;
            }
            str.append("\\n").append(messages.get(i));
        }
        return str.toString();
    }

    public static boolean hasText(String str) {
        return SimpleStringUtil.hasText((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!SimpleStringUtil.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        String lcStr = str.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static boolean pathEquals(String path1, String path2) {
        return SimpleStringUtil.cleanPath(path1).equals(SimpleStringUtil.cleanPath(path2));
    }

    public static String cleanPath(String path) {
        int i;
        String pathToUse = SimpleStringUtil.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        String[] pathArray = SimpleStringUtil.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            if (CURRENT_PATH.equals(pathArray[i])) continue;
            if (TOP_PATH.equals(pathArray[i])) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, pathArray[i]);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return prefix + SimpleStringUtil.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return SimpleStringUtil.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(SimpleStringUtil.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int pos = 0;
            int delPos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(SimpleStringUtil.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(SimpleStringUtil.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return SimpleStringUtil.toStringArray(result);
    }

    public static String[] toStringArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static Integer[] toIntArray(Collection<Integer> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new Integer[collection.size()]);
    }

    public static String[] toStringArray(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<String> list = Collections.list(enumeration);
        return list.toArray(new String[list.size()]);
    }

    public static String[] trimArrayElements(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return new String[0];
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String element = array[i];
            result[i] = element != null ? element.trim() : null;
        }
        return result;
    }

    public static String[] removeDuplicateStrings(String[] array) {
        if (ObjectUtils.isEmpty(array)) {
            return array;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return SimpleStringUtil.toStringArray(set);
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!SimpleStringUtil.hasLength(inString) || !SimpleStringUtil.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String collectionToDelimitedString(Collection coll, String delim, String prefix, String suffix) {
        if (CollectionUtils.isEmpty(coll)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection coll, String delim) {
        return SimpleStringUtil.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(Collection coll) {
        return SimpleStringUtil.collectionToDelimitedString(coll, COMMA);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return SimpleStringUtil.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return SimpleStringUtil.toStringArray(tokens);
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            String newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = newPath + FOLDER_SEPARATOR;
            }
            return newPath + relativePath;
        }
        return relativePath;
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return SimpleStringUtil.arrayToDelimitedString(arr, COMMA);
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (ObjectUtils.isEmpty(arr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!SimpleStringUtil.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!SimpleStringUtil.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && buf.charAt(0) == leadingCharacter) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!SimpleStringUtil.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && buf.charAt(buf.length() - 1) == trailingCharacter) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!SimpleStringUtil.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static int countOccurrencesOf(String str, String sub) {
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String stripFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int sepIndex = path.lastIndexOf(46);
        return sepIndex != -1 ? path.substring(0, sepIndex) : path;
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return SimpleStringUtil.delimitedListToStringArray(str, COMMA);
    }

    public static String[] addStringToArray(String[] array, String str) {
        if (ObjectUtils.isEmpty(array)) {
            return new String[]{str};
        }
        String[] newArr = new String[array.length + 1];
        System.arraycopy(array, 0, newArr, 0, array.length);
        newArr[array.length] = str;
        return newArr;
    }

    public static String trimAllWhitespace(String str) {
        if (!SimpleStringUtil.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        int index = 0;
        while (buf.length() > index) {
            if (Character.isWhitespace(buf.charAt(index))) {
                buf.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return buf.toString();
    }

    public static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        String[] parts = SimpleStringUtil.tokenizeToStringArray(localeString, "_ ", false, false);
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        String variant = "";
        if (parts.length >= 2 && (variant = SimpleStringUtil.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country) + country.length()))).startsWith("_")) {
            variant = SimpleStringUtil.trimLeadingCharacter(variant, '_');
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    public static String toLanguageTag(Locale locale) {
        return locale.getLanguage() + (SimpleStringUtil.hasText(locale.getCountry()) ? "-" + locale.getCountry() : "");
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int sepIndex = path.lastIndexOf(46);
        return sepIndex != -1 ? path.substring(sepIndex + 1) : null;
    }

    public static InputStream getInputStream(String resourcefile, Class clazz) throws IOException {
        InputStream is = null;
        is = clazz.getResourceAsStream(resourcefile);
        if (is == null) {
            throw new FileNotFoundException(resourcefile + " cannot be opened because it does not exist");
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String resourcefile, Class clazz) throws IOException {
        InputStream is = SimpleStringUtil.getInputStream(resourcefile, clazz);
        try {
            Properties props = new Properties();
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            is.close();
        }
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public static boolean isNotEmpty(String value) {
        return value != null && !"".equals(value);
    }

    public static boolean isEmpty(Collection cl) {
        return cl == null || cl.size() == 0;
    }

    public static boolean isNotEmpty(Collection cl) {
        return !SimpleStringUtil.isEmpty(cl);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return SimpleStringUtil.isEmpty((String)obj);
        }
        if (obj instanceof Collection) {
            return SimpleStringUtil.isEmpty((Collection)obj);
        }
        if (!obj.getClass().isArray()) {
            return false;
        }
        return Array.getLength(obj) == 0;
    }

    public static boolean isNotEmpty(Object obj) {
        return !SimpleStringUtil.isEmpty(obj);
    }

    public static String formatException(Throwable exception) {
        StringWriter out = new StringWriter();
        exception.printStackTrace(new PrintWriter(out));
        String errorMessage = out.toString();
        errorMessage = errorMessage.replaceAll("\\n", "\\\\n");
        errorMessage = errorMessage.replaceAll("\\r", "\\\\r");
        return errorMessage;
    }

    public static String formatBRException(Throwable exception) {
        StringWriter out = new StringWriter();
        exception.printStackTrace(new PrintWriter(out));
        String errorMessage = out.toString();
        errorMessage = errorMessage.replaceAll("\\n", "<br/>");
        errorMessage = errorMessage.replaceAll("\\r", "<br/>");
        return errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exceptionToString(Throwable exception) {
        StringWriter out = new StringWriter();
        try {
            String errorMessage;
            exception.printStackTrace(new PrintWriter(out));
            String string = errorMessage = out.toString();
            return string;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String urlencode(String value, String charset, int encodecount) {
        if (value == null) {
            return value;
        }
        if (encodecount <= 1) {
            try {
                value = URLEncoder.encode(value, charset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (encodecount == 2) {
            try {
                value = URLEncoder.encode(URLEncoder.encode(value, charset), charset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (encodecount == 3) {
            try {
                value = URLEncoder.encode(URLEncoder.encode(URLEncoder.encode(value, charset), charset), charset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                for (int i = 0; i < encodecount; ++i) {
                    value = URLEncoder.encode(value, charset);
                }
                return value;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static String urlencode(String value, String charset) {
        return SimpleStringUtil.urlencode(value, charset, 1);
    }

    public static Locale getLocale(String locale) {
        return SimpleStringUtil.getAllLocales().get(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Locale> getAllLocales() {
        if (localesIndexByString != null) {
            return localesIndexByString;
        }
        Class<SimpleStringUtil> clazz = SimpleStringUtil.class;
        synchronized (SimpleStringUtil.class) {
            if (localesIndexByString != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return localesIndexByString;
            }
            HashMap<String, Locale> lm = new HashMap<String, Locale>();
            lm.put(String.valueOf(Locale.SIMPLIFIED_CHINESE), Locale.SIMPLIFIED_CHINESE);
            lm.put(String.valueOf(Locale.ENGLISH), Locale.ENGLISH);
            lm.put(String.valueOf(Locale.US), Locale.US);
            lm.put(String.valueOf(Locale.JAPANESE), Locale.JAPANESE);
            lm.put(String.valueOf(Locale.FRENCH), Locale.FRENCH);
            lm.put(String.valueOf(Locale.CANADA_FRENCH), Locale.CANADA_FRENCH);
            lm.put(String.valueOf(Locale.CANADA), Locale.CANADA);
            lm.put(String.valueOf(Locale.UK), Locale.UK);
            lm.put(String.valueOf(Locale.TAIWAN), Locale.TAIWAN);
            lm.put(String.valueOf(Locale.PRC), Locale.PRC);
            lm.put(String.valueOf(Locale.KOREA), Locale.KOREA);
            lm.put(String.valueOf(Locale.JAPAN), Locale.JAPAN);
            lm.put(String.valueOf(Locale.ITALY), Locale.ITALY);
            lm.put(String.valueOf(Locale.GERMANY), Locale.GERMANY);
            lm.put(String.valueOf(Locale.FRANCE), Locale.FRANCE);
            lm.put(String.valueOf(Locale.TRADITIONAL_CHINESE), Locale.TRADITIONAL_CHINESE);
            lm.put(String.valueOf(Locale.CHINESE), Locale.CHINESE);
            lm.put(String.valueOf(Locale.KOREAN), Locale.KOREAN);
            lm.put(String.valueOf(Locale.ITALIAN), Locale.ITALIAN);
            lm.put(String.valueOf(Locale.GERMAN), Locale.GERMAN);
            lm.put("ROOT", Locale.ROOT);
            localesIndexByString = lm;
            // ** MonitorExit[var0] (shouldn't be in output)
            return localesIndexByString;
        }
    }

    public static Map<String, Locale> converLocales(String locales) {
        if (locales == null || locales.trim().equals("")) {
            return null;
        }
        String[] locales_ = locales.split("\\,");
        HashMap<String, Locale> lm = new HashMap<String, Locale>();
        for (String locale : locales_) {
            if (locale.equals(Locale.SIMPLIFIED_CHINESE.toString())) {
                lm.put(locale, Locale.SIMPLIFIED_CHINESE);
                continue;
            }
            if (locale.equals(Locale.ENGLISH.toString())) {
                lm.put(locale, Locale.ENGLISH);
                continue;
            }
            if (locale.equals(Locale.US.toString())) {
                lm.put(locale, Locale.US);
                continue;
            }
            if (locale.equals(Locale.JAPANESE.toString())) {
                lm.put(locale, Locale.JAPANESE);
                continue;
            }
            if (locale.equals(Locale.FRENCH.toString())) {
                lm.put(locale, Locale.FRENCH);
                continue;
            }
            if (locale.equals(Locale.CANADA_FRENCH.toString())) {
                lm.put(locale, Locale.CANADA_FRENCH);
                continue;
            }
            if (locale.equals(Locale.CANADA.toString())) {
                lm.put(locale, Locale.CANADA);
                continue;
            }
            if (locale.equals(Locale.UK.toString())) {
                lm.put(locale, Locale.UK);
                continue;
            }
            if (locale.equals(Locale.TAIWAN.toString())) {
                lm.put(locale, Locale.TAIWAN);
                continue;
            }
            if (locale.equals(Locale.PRC.toString())) {
                lm.put(locale, Locale.PRC);
                continue;
            }
            if (locale.equals(Locale.KOREA.toString())) {
                lm.put(locale, Locale.KOREA);
                continue;
            }
            if (locale.equals(Locale.JAPAN.toString())) {
                lm.put(locale, Locale.JAPAN);
                continue;
            }
            if (locale.equals(Locale.ITALY.toString())) {
                lm.put(locale, Locale.ITALY);
                continue;
            }
            if (locale.equals(Locale.GERMANY.toString())) {
                lm.put(locale, Locale.GERMANY);
                continue;
            }
            if (locale.equals(Locale.FRANCE.toString())) {
                lm.put(locale, Locale.FRANCE);
                continue;
            }
            if (locale.equals(Locale.TRADITIONAL_CHINESE.toString())) {
                lm.put(locale, Locale.TRADITIONAL_CHINESE);
                continue;
            }
            if (locale.equals(Locale.CHINESE.toString())) {
                lm.put(locale, Locale.CHINESE);
                continue;
            }
            if (locale.equals(Locale.KOREAN.toString())) {
                lm.put(locale, Locale.KOREAN);
                continue;
            }
            if (locale.equals(Locale.ITALIAN.toString())) {
                lm.put(locale, Locale.ITALIAN);
                continue;
            }
            if (locale.equals(Locale.GERMAN.toString())) {
                lm.put(locale, Locale.GERMAN);
                continue;
            }
            logger.debug("\u4e0d\u6b63\u786e\u7684\u8bed\u8a00\u4ee3\u7801:" + locale + ",build new Locale for " + locale + CURRENT_PATH);
            lm.put(locale, new Locale(locale));
        }
        return lm;
    }

    public static <T> T json2Object(String jsonString, Class<T> toclass, boolean ALLOW_SINGLE_QUOTES) {
        return SimpleStringUtil.getJacksonObjectMapper().json2Object(jsonString, toclass, ALLOW_SINGLE_QUOTES);
    }

    public static <T> T json2ObjectWithType(String jsonString, JsonTypeReference<T> ref) {
        return SimpleStringUtil.json2ObjectWithType(jsonString, ref, true);
    }

    public static <T> T json2ObjectWithType(InputStream json, JsonTypeReference<T> ref) {
        return SimpleStringUtil.json2ObjectWithType(json, ref, true);
    }

    public static <T> T json2ObjectWithType(String jsonString, JsonTypeReference<T> ref, boolean ALLOW_SINGLE_QUOTES) {
        return SimpleStringUtil.getJacksonObjectMapper().json2ObjectWithType(jsonString, ref, ALLOW_SINGLE_QUOTES);
    }

    public static <T> T json2ObjectWithType(InputStream json, JsonTypeReference<T> ref, boolean ALLOW_SINGLE_QUOTES) {
        return SimpleStringUtil.getJacksonObjectMapper().json2ObjectWithType(json, ref, ALLOW_SINGLE_QUOTES);
    }

    public static <T> T json2Object(String jsonString, Class<T> toclass) {
        return SimpleStringUtil.getJacksonObjectMapper().json2Object(jsonString, toclass, true);
    }

    public static <T> T json2Object(InputStream jsonString, Class<T> toclass) {
        return SimpleStringUtil.getJacksonObjectMapper().json2Object(jsonString, toclass, true);
    }

    public static String object2json(Object object, boolean ALLOW_SINGLE_QUOTES) {
        return SimpleStringUtil.getJacksonObjectMapper().object2json(object, ALLOW_SINGLE_QUOTES);
    }

    public static String object2json(Object object) {
        return SimpleStringUtil.object2json(object, true);
    }

    public static void object2json(Object object, Writer writer, boolean ALLOW_SINGLE_QUOTES) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, ALLOW_SINGLE_QUOTES);
    }

    public static void object2json(Object object, Writer writer) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, true);
    }

    public static void object2json(Object object, StringBuilder builder) {
        BBossStringWriter writer = new BBossStringWriter(builder);
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, true);
    }

    public static void object2json(Object object, OutputStream writer, boolean ALLOW_SINGLE_QUOTES) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, ALLOW_SINGLE_QUOTES);
    }

    public static void object2json(Object object, OutputStream writer) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, true);
    }

    public static void object2json(Object object, File writer, boolean ALLOW_SINGLE_QUOTES) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, ALLOW_SINGLE_QUOTES);
    }

    public static void object2json(Object object, File writer) {
        SimpleStringUtil.getJacksonObjectMapper().object2json(object, writer, true);
    }

    public static byte[] object2jsonAsbyte(Object object, boolean ALLOW_SINGLE_QUOTES) {
        return SimpleStringUtil.getJacksonObjectMapper().object2jsonAsbyte(object, ALLOW_SINGLE_QUOTES);
    }

    public static byte[] object2jsonAsbyte(Object object) {
        return SimpleStringUtil.getJacksonObjectMapper().object2jsonAsbyte(object, true);
    }

    public static String tostring(Object data) {
        StringBuilder ret = new StringBuilder();
        SimpleStringUtil.tostring(ret, data);
        return ret.toString();
    }

    public static void tostring(StringBuilder ret, Object data) {
        if (data == null) {
            return;
        }
        if (!data.getClass().isArray()) {
            ret.append(data.toString());
        } else {
            int size = Array.getLength(data);
            ret.append("{");
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    ret.append(COMMA);
                }
                SimpleStringUtil.tostring(ret, Array.get(data, i));
            }
            ret.append("}");
        }
    }

    public static String formatTimeToString(long mss) {
        long days = mss / 86400000L;
        long hours = mss % 86400000L / 3600000L;
        long minutes = mss % 3600000L / 60000L;
        long seconds = mss % 60000L / 1000L;
        StringBuilder sb = new StringBuilder();
        if (days != 0L) {
            sb.append(days + "\u5929");
        }
        if (hours != 0L) {
            sb.append(hours + "\u5c0f\u65f6");
        }
        if (minutes != 0L) {
            sb.append(minutes + "\u5206\u949f");
        }
        if (seconds != 0L) {
            sb.append(seconds + "\u79d2");
        }
        return sb.toString();
    }

    public static Enumeration arryToenum(final Object[] values) {
        return new Enumeration(){
            int length;
            int count;
            {
                this.length = values != null ? values.length : 0;
                this.count = 0;
            }

            @Override
            public boolean hasMoreElements() {
                return this.count < this.length;
            }

            public Object nextElement() {
                Object element = values[this.count];
                ++this.count;
                return element;
            }
        };
    }

    public static String native2ascii(String s) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch;
            char val = ch = s.charAt(i);
            if (ch == '\r') continue;
            if (val >= '\u0000' && val < '\u0080' && ch != '\n' && ch != '\\') {
                res.append(ch);
                continue;
            }
            res.append("\\u");
            String hex = Integer.toHexString(val);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                res.append("0");
            }
            res.append(hex);
        }
        return res.toString();
    }

    public static String ascii2native(String s) {
        StringBuilder res = new StringBuilder(s.length());
        block6: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\\' && i + 1 >= s.length()) {
                res.append(ch);
                break;
            }
            if (ch != '\\') {
                res.append(ch);
                continue;
            }
            switch (s.charAt(i + 1)) {
                case 'u': {
                    res.append((char)Integer.parseInt(s.substring(i + 2, i + 6), 16));
                    i += 5;
                    continue block6;
                }
                case 'n': {
                    res.append('\n');
                    ++i;
                    continue block6;
                }
                case 't': {
                    res.append('\t');
                    ++i;
                    continue block6;
                }
                case 'r': {
                    res.append('\r');
                    ++i;
                    continue block6;
                }
            }
        }
        return res.toString();
    }

    public static final String getOS() {
        return System.getProperty("os.name");
    }

    public static final boolean isWindows() {
        return SimpleStringUtil.getOS().startsWith("Windows");
    }

    public static final boolean isLinux() {
        return SimpleStringUtil.getOS().startsWith("Linux");
    }

    public static final boolean isOSX() {
        return SimpleStringUtil.getOS().toUpperCase().contains("OS X");
    }

    public static String newStringUtf8(byte[] bytes) {
        return SimpleStringUtil.newString(bytes, Charsets.UTF_8);
    }

    private static String newString(byte[] bytes, Charset charset) {
        return bytes == null ? null : new String(bytes, charset);
    }

    public static byte[] getBytesUsAscii(String string) {
        return SimpleStringUtil.getBytes(string, Charsets.US_ASCII);
    }

    public static byte[] getBytesUtf16(String string) {
        return SimpleStringUtil.getBytes(string, Charsets.UTF_16);
    }

    public static byte[] getBytesUtf16Be(String string) {
        return SimpleStringUtil.getBytes(string, Charsets.UTF_16BE);
    }

    public static byte[] getBytesUtf16Le(String string) {
        return SimpleStringUtil.getBytes(string, Charsets.UTF_16LE);
    }

    public static byte[] getBytesUtf8(String string) {
        return SimpleStringUtil.getBytes(string, Charsets.UTF_8);
    }

    private static byte[] getBytes(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return string.getBytes(charset);
    }

    static {
        dfltEncName = null;
    }
}

