/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.ResourceInitial;
import com.frameworkset.util.UUIDResource;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonThread
extends Thread {
    private static Logger log = LoggerFactory.getLogger(DaemonThread.class);
    private long refresh_interval = 5000L;
    private Map<String, FileBean> files = new HashMap<String, FileBean>();
    private boolean started = false;
    private boolean stopped = false;
    private Object lock = new Object();

    public DaemonThread(String fileName, ResourceInitial init) {
        this(fileName, 5000L, init);
    }

    public DaemonThread(long refresh_interval, String name) {
        super(name);
        this.refresh_interval = refresh_interval;
        this.setDaemon(true);
    }

    public void addFile(String fileName, ResourceInitial init) {
        URL confURL;
        if (this.stopped) {
            return;
        }
        File file = new File(fileName);
        if (!file.exists() && (confURL = ResourceInitial.class.getClassLoader().getResource(fileName)) != null) {
            file = new File(confURL.getPath());
        }
        this.addFile(file, init);
    }

    private FileBean containFile(File file) {
        if (this.files == null || this.files.size() <= 0) {
            return null;
        }
        if (file == null) {
            return null;
        }
        FileBean f = this.files.get(file.getAbsolutePath());
        if (f == null) {
            return null;
        }
        if (f.isRemoveflag()) {
            f.setRemoveflag(false);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file, ResourceInitial init) {
        if (this.stopped) {
            return;
        }
        if (!file.exists()) {
            log.debug(file.getAbsolutePath() + " \u5bf9\u5e94\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u4fee\u6539\u68c0\u6d4b.");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            FileBean f = this.containFile(file);
            if (f == null) {
                this.files.put(file.getAbsolutePath(), new FileBean(file, init));
            } else {
                f.addResourceInit(init);
            }
            log.debug("Add file " + file.getAbsolutePath() + " to damon thread which moniting file modified.");
        }
    }

    public void removeFile(String filepath) {
        URL confURL;
        File file = new File(filepath);
        if (!file.exists() && (confURL = ResourceInitial.class.getClassLoader().getResource(filepath)) != null) {
            file = new File(confURL.getPath());
        }
        this.removeFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(File file) {
        Object object = this.lock;
        synchronized (object) {
            if (this.files == null || this.files.size() <= 0) {
                return;
            }
            if (file == null) {
                return;
            }
            FileBean f = this.files.get(file.getAbsolutePath());
            if (f != null) {
                f.setRemoveflag(true);
                log.debug("marked  file " + file.getAbsolutePath() + " to be removed from damon thread which moniting file modified.");
            }
        }
    }

    public DaemonThread(String fileName, long refresh_interval, ResourceInitial init) {
        super(fileName);
        URL confURL;
        this.refresh_interval = refresh_interval > 0L ? refresh_interval : 10000L;
        File file = new File(fileName);
        if (!file.exists() && (confURL = ResourceInitial.class.getClassLoader().getResource(fileName)) != null) {
            file = new File(confURL.getPath());
        }
        if (!file.exists()) {
            log.debug(file.getAbsolutePath() + " \u5bf9\u5e94\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u4fee\u6539\u68c0\u6d4b.");
            return;
        }
        this.files.put(file.getAbsolutePath(), new FileBean(file, init));
        log.debug("Add file " + file.getAbsolutePath() + " to damon thread which moniting file modified.");
        this.setDaemon(true);
    }

    public DaemonThread(File file, ResourceInitial init) {
        this.files.put(file.getAbsolutePath(), new FileBean(file, init));
        log.debug("Add file " + file.getAbsolutePath() + " to damon thread which moniting file modified.");
        this.setDaemon(true);
    }

    public boolean started() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("Start check files is changed or not.if some files is changed,the resources of these files will be refreshed use ResourceInit interface.");
        this.started = true;
        block11: while (!this.stopped) {
            try {
                DaemonThread.sleep(this.refresh_interval);
            }
            catch (InterruptedException ex) {
                break;
            }
            if (this.files == null || this.files.size() == 0) {
                String tname = this.getName() != null ? this.getName() : "null";
                log.debug("Thread[" + tname + "] Ignore Monitor change Files : No file to be monitor.");
                continue;
            }
            ArrayList<FileBean> changedFiles = new ArrayList<FileBean>();
            Iterator iterator = this.lock;
            synchronized (iterator) {
                try {
                    Iterator<Map.Entry<String, FileBean>> entries = this.files.entrySet().iterator();
                    while (entries.hasNext() && !this.stopped) {
                        Map.Entry<String, FileBean> entry = entries.next();
                        FileBean f = entry.getValue();
                        if (f.isRemoveflag()) continue;
                        try {
                            String filePath;
                            if (log.isDebugEnabled()) {
                                filePath = f.getFile() != null ? f.getFile().getAbsolutePath() : "";
                                log.debug("Thread[" + this.getName() + "] Check file[" + filePath + "] .");
                            }
                            if (!f.checkChanged()) continue;
                            if (log.isDebugEnabled()) {
                                filePath = f.getFile() != null ? f.getFile().getAbsolutePath() : "";
                                log.debug("Thread[" + this.getName() + "] Monitor file[" + filePath + "] changed.");
                            }
                            changedFiles.add(f);
                        }
                        catch (Exception e) {
                            String filePath = f.getFile() != null ? f.getFile().getAbsolutePath() : "null";
                            String tname = this.getName() != null ? this.getName() : "null";
                            log.debug("Thread[" + tname + "] Monitor changed file[" + filePath + "] exception:", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    log.debug("Thread[" + this.getName() + "] Monitor changed files exception:", (Throwable)e);
                }
            }
            if (changedFiles.size() <= 0) continue;
            for (FileBean f : changedFiles) {
                if (this.stopped) continue block11;
                try {
                    f.reinit();
                }
                catch (Exception e) {
                    String filePath = f.getFile() != null ? f.getFile().getAbsolutePath() : "null";
                    String tname = this.getName() != null ? this.getName() : "null";
                    log.debug("Thread[" + tname + "] Monitor changed file[" + filePath + "] exception:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.files != null) {
                this.files.clear();
            }
            this.lock.notifyAll();
        }
    }

    static class FileBean {
        private boolean removeflag = false;
        private File file;
        private long lastModifiedTime;
        private long oldModifiedTime;
        private List<ResourceInitial> inits;

        public FileBean(File file, ResourceInitial init) {
            this.file = file;
            this.inits = new ArrayList<ResourceInitial>();
            this.inits.add(init);
            this.oldModifiedTime = file.lastModified();
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public long getOldModifiedTime() {
            return this.oldModifiedTime;
        }

        public void setOldModifiedTime(long oldModifiedTime) {
            this.oldModifiedTime = oldModifiedTime;
        }

        public boolean checkChanged() {
            if (this.file == null) {
                return false;
            }
            boolean exist = this.file.exists();
            if (!exist) {
                return false;
            }
            this.lastModifiedTime = this.file.lastModified();
            return this.oldModifiedTime != this.lastModifiedTime;
        }

        public void reinit() {
            log.debug("Reload changed file\uff1a" + this.file.getAbsolutePath());
            this.oldModifiedTime = this.file.lastModified();
            try {
                for (int i = 0; this.inits != null && i < this.inits.size(); ++i) {
                    ResourceInitial init = this.inits.get(i);
                    try {
                        init.reinit();
                        continue;
                    }
                    catch (Exception e) {
                        log.debug("Reload changed file " + this.file.getAbsolutePath() + " failed:", (Throwable)e);
                    }
                }
                log.debug("Reload changed file " + this.file.getAbsolutePath() + " sucessed.");
            }
            catch (Exception e) {
                log.debug("Reload changed file " + this.file.getAbsolutePath() + " failed:", (Throwable)e);
            }
        }

        public boolean isRemoveflag() {
            return this.removeflag;
        }

        public void setRemoveflag(boolean removeflag) {
            this.removeflag = removeflag;
        }

        public void addResourceInit(ResourceInitial init) {
            if (!this.contain(init)) {
                this.inits.add(init);
            }
        }

        private boolean contain(ResourceInitial init) {
            if (init instanceof UUIDResource) {
                String uuid = ((UUIDResource)((Object)init)).getUUID();
                for (int i = 0; i < this.inits.size(); ++i) {
                    ResourceInitial initOld = this.inits.get(i);
                    if (!(initOld instanceof UUIDResource) || !((UUIDResource)((Object)initOld)).getUUID().equals(uuid)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

