/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.BeanInstantiationException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.frameworkset.util.Assert;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.ClassUtils;
import org.frameworkset.util.MethodParameter;
import org.frameworkset.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanUtils {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);
    private static final Map unknownEditorTypes = Collections.synchronizedMap(new WeakHashMap());

    public static <T> T instantiateClass(Class<T> clazz) throws BeanInstantiationException {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface()) {
            throw new BeanInstantiationException(clazz, "Specified class is an interface");
        }
        try {
            ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(clazz);
            return BeanUtils.instantiateClass(clazz, classInfo.getDefaultConstruction(), null);
        }
        catch (NoSuchMethodException ex) {
            throw new BeanInstantiationException(clazz, "No default constructor found", (Throwable)ex);
        }
    }

    public static <T> T instantiate(Class<T> clazz) throws BeanInstantiationException {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.isInterface()) {
            throw new BeanInstantiationException(clazz, "Specified class is an interface");
        }
        try {
            ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(clazz);
            return BeanUtils.instantiateClass(clazz, classInfo.getDefaultConstruction(), null);
        }
        catch (NoSuchMethodException ex) {
            throw new BeanInstantiationException(clazz, "No default constructor found", (Throwable)ex);
        }
    }

    public static Object instantiateClass(String clazz) throws BeanInstantiationException {
        Class<?> claxx;
        Assert.notNull(clazz, "Class must not be null");
        try {
            claxx = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new BeanInstantiationException(clazz, "Specified class not found", (Throwable)e);
        }
        return BeanUtils.instantiateClass(claxx);
    }

    public static Object instantiateClass(Constructor ctor, Object[] args) throws BeanInstantiationException {
        Assert.notNull(ctor, "Constructor must not be null");
        try {
            ReflectionUtils.makeAccessible(ctor);
            return ctor.newInstance(args);
        }
        catch (InstantiationException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Is it an abstract class?", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Has the class definition changed? Is the constructor accessible?", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Illegal arguments for constructor", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Constructor threw exception", ex.getTargetException());
        }
    }

    public static <T> T instantiateClass(Class<T> type, Constructor ctor, Object[] args) throws BeanInstantiationException {
        Assert.notNull(ctor, "Constructor must not be null");
        try {
            return ctor.newInstance(args);
        }
        catch (InstantiationException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Is it an abstract class?", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Has the class definition changed? Is the constructor accessible?", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Illegal arguments for constructor", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Constructor threw exception", ex.getTargetException());
        }
    }

    public static Method findMethod(Class clazz, String methodName, Class[] paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return BeanUtils.findDeclaredMethod(clazz, methodName, paramTypes);
        }
    }

    public static Method findDeclaredMethod(Class clazz, String methodName, Class[] paramTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            if (clazz.getSuperclass() != null) {
                return BeanUtils.findDeclaredMethod(clazz.getSuperclass(), methodName, paramTypes);
            }
            return null;
        }
    }

    public static Method findMethodWithMinimalParameters(Class clazz, String methodName) throws IllegalArgumentException {
        Method targetMethod = BeanUtils.doFindMethodWithMinimalParameters(clazz.getDeclaredMethods(), methodName);
        if (targetMethod == null) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz, methodName);
        }
        return targetMethod;
    }

    public static Method findDeclaredMethodWithMinimalParameters(Class clazz, String methodName) throws IllegalArgumentException {
        Method targetMethod = BeanUtils.doFindMethodWithMinimalParameters(clazz.getDeclaredMethods(), methodName);
        if (targetMethod == null && clazz.getSuperclass() != null) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz.getSuperclass(), methodName);
        }
        return targetMethod;
    }

    private static Method doFindMethodWithMinimalParameters(Method[] methods, String methodName) throws IllegalArgumentException {
        Method targetMethod = null;
        int numMethodsFoundWithCurrentMinimumArgs = 0;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            int numParams = methods[i].getParameterTypes().length;
            if (targetMethod == null || numParams < targetMethod.getParameterTypes().length) {
                targetMethod = methods[i];
                numMethodsFoundWithCurrentMinimumArgs = 1;
                continue;
            }
            if (targetMethod.getParameterTypes().length != numParams) continue;
            ++numMethodsFoundWithCurrentMinimumArgs;
        }
        if (numMethodsFoundWithCurrentMinimumArgs > 1) {
            throw new IllegalArgumentException("Cannot resolve method '" + methodName + "' to a unique method. Attempted to resolve to overloaded method with the least number of parameters, but there were " + numMethodsFoundWithCurrentMinimumArgs + " candidates.");
        }
        return targetMethod;
    }

    public static boolean isSimpleProperty(Class clazz) {
        Assert.notNull(clazz, "Class must not be null");
        return BeanUtils.isSimpleValueType(clazz) || clazz.isArray() && BeanUtils.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class clazz) {
        return ClassUtils.isPrimitiveOrWrapper(clazz) || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class);
    }

    public static boolean isAssignable(Class targetType, Class valueType) {
        return ClassUtils.isAssignable(targetType, valueType);
    }

    public static boolean isAssignable(Class type, Object value) {
        return ClassUtils.isAssignableValue(type, value);
    }

    public static MethodParameter getWriteMethodParameter(PropertyDescriptor pd) {
        return new MethodParameter(pd.getWriteMethod(), 0);
    }
}

