/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.persitent.util;

import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.util.VariableHandler;
import java.lang.ref.SoftReference;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.persitent.util.SQLUtil;

public class SQLCache {
    private Lock lock = new ReentrantLock();
    private Lock vtplLock = new ReentrantLock();
    private Map<String, VariableHandler.SQLStruction> parserSQLStructions = new HashMap<String, VariableHandler.SQLStruction>();
    private Map<String, VariableHandler.SQLStruction> parsertotalsizeSQLStructions = new HashMap<String, VariableHandler.SQLStruction>();
    private Map<String, Map<String, VariableHandler.SQLStruction>> parserTPLSQLStructions = new HashMap<String, Map<String, VariableHandler.SQLStruction>>();
    private Map<String, Map<String, VariableHandler.SQLStruction>> parserTPLTotalsizeSQLStructions = new HashMap<String, Map<String, VariableHandler.SQLStruction>>();
    protected Map<String, Map<String, SoftReference<PoolManResultSetMetaData>>> metas = new HashMap<String, Map<String, SoftReference<PoolManResultSetMetaData>>>();

    public void clear() {
        this.metas.clear();
        this.parserSQLStructions.clear();
        this.parsertotalsizeSQLStructions.clear();
        this.parserTPLSQLStructions.clear();
        this.parserTPLTotalsizeSQLStructions.clear();
    }

    private boolean needRefreshMeta(PoolManResultSetMetaData meta, ResultSetMetaData rsmetadata) throws SQLException {
        if (meta.getColumnCount() != rsmetadata.getColumnCount()) {
            return true;
        }
        String[] labels = meta.get_columnLabel();
        int[] coltypes = meta.get_columnType();
        for (int i = 0; i < labels.length; ++i) {
            if (!labels[i].equals(rsmetadata.getColumnLabel(i + 1))) {
                return true;
            }
            if (coltypes[i] == rsmetadata.getColumnType(i + 1)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolManResultSetMetaData getPoolManResultSetMetaData(DB db, String dbname, String sqlkey, ResultSetMetaData rsmetadata) throws SQLException {
        SoftReference<PoolManResultSetMetaData> wr;
        PoolManResultSetMetaData meta = null;
        Map<String, SoftReference<PoolManResultSetMetaData>> dbmetas = this.metas.get(dbname);
        if (dbmetas == null) {
            Map<String, Map<String, SoftReference<PoolManResultSetMetaData>>> map = this.metas;
            synchronized (map) {
                dbmetas = this.metas.get(dbname);
                if (dbmetas == null) {
                    dbmetas = new HashMap<String, SoftReference<PoolManResultSetMetaData>>();
                    this.metas.put(dbname, dbmetas);
                }
            }
        }
        if ((wr = dbmetas.get(sqlkey)) != null) {
            meta = wr.get();
            if (meta == null) {
                meta = PoolManResultSetMetaData.getCopy(db, rsmetadata);
                SoftReference<PoolManResultSetMetaData> wr1 = new SoftReference<PoolManResultSetMetaData>(meta);
                dbmetas.put(sqlkey, wr1);
            } else if (this.needRefreshMeta(meta, rsmetadata)) {
                meta = PoolManResultSetMetaData.getCopy(db, rsmetadata);
                wr = new SoftReference<PoolManResultSetMetaData>(meta);
                dbmetas.put(sqlkey, wr);
            }
        } else {
            meta = PoolManResultSetMetaData.getCopy(db, rsmetadata);
            wr = new SoftReference<PoolManResultSetMetaData>(meta);
            dbmetas.put(sqlkey, wr);
        }
        return meta;
    }

    public VariableHandler.SQLStruction getSQLStruction(SQLInfo sqlinfo, String newsql) {
        if (sqlinfo.getSqlutil() == null || sqlinfo.getSqlutil() == SQLUtil.getGlobalSQLUtil()) {
            return this._getVTPLSQLStruction(this.parserTPLSQLStructions, sqlinfo, newsql, "___GlobalSQLUtil_");
        }
        if (sqlinfo.istpl()) {
            return this._getVTPLSQLStruction(this.parserTPLSQLStructions, sqlinfo, newsql, sqlinfo.getSqlname());
        }
        return this._getSQLStruction(this.parserSQLStructions, sqlinfo, newsql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariableHandler.SQLStruction _getSQLStruction(Map<String, VariableHandler.SQLStruction> parserSQLStructions, SQLInfo sqlinfo, String newsql) {
        String key = sqlinfo.getSqlname();
        VariableHandler.SQLStruction sqlstruction = parserSQLStructions.get(key);
        if (sqlstruction == null) {
            try {
                this.lock.lock();
                sqlstruction = parserSQLStructions.get(key);
                if (sqlstruction == null) {
                    sqlstruction = VariableHandler.parserSQLStruction((String)newsql);
                    parserSQLStructions.put(key, sqlstruction);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return sqlstruction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariableHandler.SQLStruction _getVTPLSQLStruction(Map<String, Map<String, VariableHandler.SQLStruction>> parserTPLSQLStructions, SQLInfo sqlinfo, String newsql, String okey) {
        VariableHandler.SQLStruction urlStruction;
        String ikey = newsql;
        Map<String, VariableHandler.SQLStruction> sqlstructionMap = parserTPLSQLStructions.get(okey);
        if (sqlstructionMap == null) {
            try {
                this.vtplLock.lock();
                sqlstructionMap = parserTPLSQLStructions.get(okey);
                if (sqlstructionMap == null) {
                    sqlstructionMap = new WeakHashMap<String, VariableHandler.SQLStruction>();
                    parserTPLSQLStructions.put(okey, sqlstructionMap);
                }
            }
            finally {
                this.vtplLock.unlock();
            }
        }
        if ((urlStruction = sqlstructionMap.get(ikey)) == null) {
            try {
                this.vtplLock.lock();
                urlStruction = sqlstructionMap.get(ikey);
                if (urlStruction == null) {
                    urlStruction = VariableHandler.parserSQLStruction((String)newsql);
                    sqlstructionMap.put(ikey, urlStruction);
                }
            }
            finally {
                this.vtplLock.unlock();
            }
        }
        return urlStruction;
    }

    public VariableHandler.SQLStruction getTotalsizeSQLStruction(SQLInfo totalsizesqlinfo, String newtotalsizesql) {
        if (totalsizesqlinfo.getSqlutil() == null || totalsizesqlinfo.getSqlutil() == SQLUtil.getGlobalSQLUtil()) {
            return this._getVTPLSQLStruction(this.parserTPLTotalsizeSQLStructions, totalsizesqlinfo, newtotalsizesql, "___GlobalSQLUtil_");
        }
        if (totalsizesqlinfo.istpl()) {
            return this._getVTPLSQLStruction(this.parserTPLTotalsizeSQLStructions, totalsizesqlinfo, newtotalsizesql, totalsizesqlinfo.getSqlname());
        }
        return this._getSQLStruction(this.parsertotalsizeSQLStructions, totalsizesqlinfo, newtotalsizesql);
    }
}

