/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.doclet;

import com.frameworkset.orm.ORMappingException;
import com.frameworkset.orm.ORMappingManager;
import com.frameworkset.orm.engine.model.Column;
import com.frameworkset.orm.engine.model.Database;
import com.frameworkset.orm.engine.model.Table;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xjavadoc.SourceSet;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XField;
import xjavadoc.XJavaDoc;
import xjavadoc.XTag;
import xjavadoc.filesystem.FileSourceSet;

public class HandlerORMapping {
    private static Logger log = LoggerFactory.getLogger(HandlerORMapping.class);
    private final XJavaDoc _xJavaDoc = new XJavaDoc();
    private File srcDir;
    private Collection allClasses = null;

    public static void main(String[] args) {
        HandlerORMapping handlerormapping = new HandlerORMapping();
        String str = null;
        try {
            str = handlerormapping.restoreFromXml("d:/schemas").getAnonymityDatabase().toString();
        }
        catch (ORMappingException oRMappingException) {
            // empty catch block
        }
        log.debug(str);
    }

    public void init(String relativeSrcdir) {
        long start = System.currentTimeMillis();
        this.srcDir = new File(System.getProperty("basedir"), relativeSrcdir);
        log.debug("Load java source in " + this.srcDir.getAbsolutePath());
        this._xJavaDoc.reset(true);
        this._xJavaDoc.addSourceSet((SourceSet)new FileSourceSet(this.srcDir));
        this.allClasses = this._xJavaDoc.getSourceClasses();
        long end = System.currentTimeMillis();
        log.debug("Load java source complete! Total cost:" + (end - start) / 1000L + " seconds");
    }

    public void initByCompletePath(String srcdir) {
        long start = System.currentTimeMillis();
        log.debug("Load java source in " + srcdir);
        this.srcDir = new File(srcdir);
        this._xJavaDoc.reset(true);
        this._xJavaDoc.addSourceSet((SourceSet)new FileSourceSet(this.srcDir));
        this.allClasses = this._xJavaDoc.getSourceClasses();
        long end = System.currentTimeMillis();
        log.debug("Load java source complete! Total cost:" + (end - start) / 1000L + " seconds");
    }

    public void execute() {
        ORMappingManager.getInstance().lock();
        log.debug("Handler ORMapping start...");
        long start = System.currentTimeMillis();
        if (this.allClasses == null) {
            log.debug("No java source in dir:" + this.srcDir.getAbsoluteFile());
            return;
        }
        Iterator it = this.allClasses.iterator();
        XClass xclass = null;
        while (it.hasNext()) {
            Table table = null;
            xclass = (XClass)it.next();
            if (!this.needHandler(xclass)) continue;
            log.debug("Start parseing " + xclass.getQualifiedName() + ".....");
            Database dataBase = null;
            String dbName = null;
            String dbType = null;
            String tableName = null;
            String tableSchema = null;
            XDoc doc = xclass.getDoc();
            XTag databaseTag = doc.getTag("database");
            XTag tableTag = doc.getTag("table");
            if (databaseTag == null && tableTag == null) {
                dataBase = ORMappingManager.getInstance().creatAnonymityDataBase();
            } else {
                if (databaseTag != null) {
                    dbName = databaseTag.getAttributeValue("name");
                    dbType = databaseTag.getAttributeValue("type");
                    tableName = databaseTag.getAttributeValue("table");
                }
                if (tableTag != null) {
                    tableName = tableTag.getAttributeValue("name");
                    tableSchema = tableTag.getAttributeValue("schema");
                }
                dataBase = databaseTag == null && tableTag != null ? (tableSchema != null ? ORMappingManager.getInstance().creatDataBase(tableSchema) : ORMappingManager.getInstance().creatDefaultDataBase()) : ORMappingManager.getInstance().creatDataBase(dbName, dbType);
            }
            try {
                log.debug("Parseing table ....." + tableName);
                table = ORMappingManager.getInstance().creatTable(tableName);
                table.setDatabase(dataBase);
                table.setBaseClass(xclass.getSuperclass().getQualifiedName());
                table.setJavaName(xclass.getQualifiedName());
                table.setPackage(xclass.getContainingPackage().getName());
                for (XField field : xclass.getFields()) {
                    XTag columnTag;
                    XDoc fdoc = field.getDoc();
                    if (fdoc == null || (columnTag = fdoc.getTag("table.column")) == null) continue;
                    String columnName = columnTag.getAttributeValue("name");
                    String columnDescription = columnTag.getAttributeValue("description");
                    String columnPrimarykey = columnTag.getAttributeValue("primaryKey");
                    String columnRequired = columnTag.getAttributeValue("required");
                    String columnType = columnTag.getAttributeValue("type");
                    Column column = ORMappingManager.getInstance().creatColumn(columnName);
                    column.setTable(table);
                    column.setDescription(columnDescription);
                    if (columnPrimarykey != null) {
                        column.setPrimaryKey(new Boolean(columnPrimarykey));
                    }
                    if (columnRequired != null) {
                        column.setNotNull(new Boolean(columnRequired));
                    }
                    column.setType(columnType);
                    column.setJavaName(field.getName());
                    log.debug("Parseing table column '" + columnName + "' with field '" + field.getName() + "'");
                    column.setJavaType(field.getType().getQualifiedName());
                    table.addColumn(column);
                }
                dataBase.addTable(table);
                log.debug("Complete parseing " + xclass.getQualifiedName() + ".");
            }
            catch (ORMappingException ex) {
                ex.printStackTrace();
            }
        }
        ORMappingManager.getInstance().unlock();
        long end = System.currentTimeMillis();
        log.debug("Complete parseing all java sources! Total cost:" + (end - start) + " ms");
    }

    private boolean needHandler(XClass xclass) {
        boolean need = false;
        if (xclass == null || xclass.getFields() == null || xclass.getFields().size() == 0) {
            need = false;
        } else {
            for (XField field : xclass.getFields()) {
                if (field.getDoc().getTag("table.column") == null) continue;
                need = true;
                break;
            }
        }
        return need;
    }

    private String getPackage(XClass xclass) {
        String name = xclass.getModifiers();
        return null;
    }

    public boolean cache() {
        try {
            ORMappingManager.getInstance().cache();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean cache(String cachePath) {
        try {
            ORMappingManager.getInstance().cache(cachePath);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public ORMappingManager restore() {
        try {
            return ORMappingManager.restore();
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public ORMappingManager restore(String path) {
        try {
            return ORMappingManager.restore(path);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public boolean cachetoXml(String xmlDir) {
        try {
            ORMappingManager.getInstance().cacheToXml(xmlDir);
            return true;
        }
        catch (ORMappingException ex) {
            return false;
        }
    }

    public ORMappingManager restoreFromXml(String xmlDir) {
        return ORMappingManager.getInstance().restoreFromXml(xmlDir);
    }
}

