/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.sql;

import com.frameworkset.common.poolman.management.BaseTableManager;
import com.frameworkset.common.poolman.sql.PrimaryKey;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeyCache {
    private static Logger log = LoggerFactory.getLogger(PrimaryKeyCache.class);
    private String dbname;
    private Map id_tables;
    private static final PrimaryKey NULL_ = new PrimaryKey();

    public PrimaryKeyCache(String dbname) {
        this.dbname = dbname;
        this.id_tables = new ConcurrentHashMap(new HashMap());
    }

    public void addIDTable(PrimaryKey primaryKey) {
        if (!this.id_tables.containsKey(primaryKey.getTableName())) {
            this.id_tables.put(primaryKey.getTableName(), primaryKey);
        }
    }

    public PrimaryKey getIDTable(String tableName) {
        return this.getIDTable(null, tableName);
    }

    public PrimaryKey getIDTable(Connection con, String tableName) {
        PrimaryKey key = (PrimaryKey)this.id_tables.get(tableName.toLowerCase());
        if (key != null) {
            if (key == NULL_) {
                return null;
            }
            return key;
        }
        key = this.loaderPrimaryKey(con, tableName);
        return key;
    }

    public String getDbname() {
        return this.dbname;
    }

    public PrimaryKey loaderPrimaryKey(String tableName) {
        return this.loaderPrimaryKey(null, tableName);
    }

    public PrimaryKey loaderPrimaryKey(Connection con, String tableName) {
        try {
            log.debug("\u5f00\u59cb\u88c5\u8f7d\u8868\u3010" + tableName + "\u3011\u7684\u4e3b\u952e\u4fe1\u606f\u5230\u7f13\u51b2\u3002");
            PrimaryKey key = BaseTableManager.getPoolTableInfo(this.dbname, con, tableName);
            if (key != null) {
                this.id_tables.put(key.getTableName().trim().toLowerCase(), key);
                log.debug("\u5b8c\u6210\u88c5\u8f7d\u8868\u3010" + tableName + "\u3011\u7684\u4e3b\u952e\u4fe1\u606f\u3002");
            } else {
                this.id_tables.put(tableName.trim().toLowerCase(), NULL_);
                log.debug("\u5b8c\u6210\u88c5\u8f7d\u8868\u3010" + tableName + "\u3011\u7684\u4e3b\u952e\u4fe1\u606f,NULL_,");
            }
            return key;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public void destroy() {
        if (this.id_tables != null) {
            this.id_tables.clear();
            this.id_tables = null;
        }
    }

    public void reset() {
        if (this.id_tables != null) {
            this.id_tables.clear();
        }
    }
}

