/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.NewSQLInfo;
import com.frameworkset.common.poolman.Record;
import com.frameworkset.common.poolman.ResultMap;
import com.frameworkset.common.poolman.handle.ResultSetHandler;
import com.frameworkset.common.poolman.handle.RowHandler;
import com.frameworkset.common.poolman.handle.XMLRowHandler;
import com.frameworkset.common.poolman.interceptor.InterceptorInf;
import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.orm.transaction.JDBCTransaction;
import com.frameworkset.orm.transaction.TXConnection;
import com.frameworkset.orm.transaction.TransactionException;
import com.frameworkset.orm.transaction.TransactionManager;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.frameworkset.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementInfo {
    private static final Logger log = LoggerFactory.getLogger(StatementInfo.class);
    private String dbname;
    private String sql;
    private NewSQLInfo newsqlinfo;
    private long totalsize = -1L;
    private String totalsizesql;
    private boolean goNative;
    private long offset = -1L;
    private int maxsize = -1;
    private boolean robotquery = true;
    private Connection con;
    private List statements;
    private JDBCTransaction tx = null;
    private boolean outcon = false;
    private String rownum;
    private boolean prepared = false;
    private DB.PagineSql paginesql;
    private String pagineOrderBy;
    List resultSets;
    private boolean oldautocommit = true;
    private boolean needTransaction = false;
    private PoolManResultSetMetaData meta = null;
    private InterceptorInf interceptorInf;
    private DB dbadapter;
    private JDBCPool pool;
    private int rowcount = 0;
    private boolean RETURN_GENERATED_KEYS;

    public void setPagineOrderBy(String pagineOrderBy) {
        this.pagineOrderBy = pagineOrderBy;
    }

    public StatementInfo(String dbname_, NewSQLInfo sql_, boolean goNative_, Connection con_, boolean needTransaction) {
        this(dbname_, sql_, goNative_, -1L, -1, SQLUtil.isRobotQuery(dbname_), con_, needTransaction, null, false);
    }

    public StatementInfo(String dbname_, NewSQLInfo sql_, boolean goNative_, long offset_, int maxsize_, boolean robotquery_, Connection con_, String rownum, boolean prepared) {
        this(dbname_, sql_, goNative_, offset_, maxsize_, robotquery_, con_, false, rownum, prepared);
    }

    public StatementInfo(String dbname_, NewSQLInfo sql_, boolean goNative_, long offset_, int maxsize_, boolean robotquery_, Connection con_, boolean needTransaction, String rownum, boolean prepared) {
        this.dbname = dbname_;
        if (this.dbname == null) {
            this.dbname = SQLManager.getInstance().getDefaultDBName();
        }
        this.newsqlinfo = sql_;
        this.pool = SQLUtil.getSQLManager().getPool(this.dbname);
        this.interceptorInf = this.pool.getInterceptor();
        this.dbadapter = this.pool.getDbAdapter();
        if (sql_ != null) {
            this.sql = this.interceptorInf.convertSQL(sql_.getNewsql(), this.dbadapter.getDBTYPE(), dbname_);
        }
        this.goNative = goNative_;
        this.offset = offset_;
        this.maxsize = maxsize_;
        this.robotquery = robotquery_;
        this.con = con_;
        this.outcon = con_ != null;
        this.statements = new ArrayList();
        this.rownum = rownum;
        this.prepared = prepared;
        this.resultSets = new ArrayList();
        this.needTransaction = needTransaction;
    }

    public static List<Object> getGeneratedKeys(PreparedStatement statement) throws Exception {
        ResultSet keys = null;
        Object key = null;
        try {
            keys = statement.getGeneratedKeys();
            ArrayList<Object> morekeys = null;
            while (keys.next()) {
                if (morekeys == null) {
                    morekeys = new ArrayList<Object>();
                }
                key = keys.getObject(1);
                morekeys.add(key);
            }
            ArrayList<Object> arrayList = morekeys;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (keys != null) {
                try {
                    keys.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public StatementInfo(String dbname_, NewSQLInfo sql_, boolean goNative_, long offset_, int maxsize_, boolean robotquery_, Connection con_, String rownum) {
        this(dbname_, sql_, goNative_, offset_, maxsize_, robotquery_, con_, rownum, false);
    }

    public StatementInfo(String dbname_, NewSQLInfo sql_, boolean goNative_, long offset_, int maxsize_, boolean robotquery_, Connection con_, boolean neadTransaction, String rownum) {
        this(dbname_, sql_, goNative_, offset_, maxsize_, robotquery_, con_, rownum, false);
    }

    public void init() throws Exception {
        block10: {
            if (!this.outcon) {
                this.tx = TransactionManager.getTransaction();
                if (this.tx == null) {
                    this.con = SQLUtil.getSQLManager().requestConnection(this.dbname);
                    if (this.needTransaction) {
                        this.oldautocommit = this.con.getAutoCommit();
                        this.con.setAutoCommit(false);
                    }
                    break block10;
                }
                try {
                    this.con = this.tx.getConnection(this.dbname);
                    break block10;
                }
                catch (TransactionException e) {
                    try {
                        this.tx.setRollbackOnly();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            if (this.con != null && this.con instanceof TXConnection) {
                this.tx = TransactionManager.getTransaction();
            }
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt = this.con.createStatement(resultSetType, resultSetConcurrency);
        this.statements.add(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement() throws SQLException {
        return this._prepareStatement(false);
    }

    private PreparedStatement _prepareStatement(boolean isquery) throws SQLException {
        int fetchsize;
        PreparedStatement pstmt = this.con.prepareStatement(this.sql, this.getScrollType(this.dbname), this.getCursorType(this.dbname));
        if (isquery && (fetchsize = this.pool.getJDBCPoolMetadata().getQueryfetchsize()) > 0) {
            pstmt.setFetchSize(fetchsize);
        }
        this.statements.add(pstmt);
        return pstmt;
    }

    public PreparedStatement prepareQueryStatement() throws SQLException {
        return this._prepareStatement(true);
    }

    private PreparedStatement _prepareStatement(String sql, boolean isquery) throws SQLException {
        int fetchsize;
        if (this.dbname == null) {
            this.dbname = SQLManager.getInstance().getDefaultDBName();
        }
        sql = this.interceptorInf.convertSQL(sql, this.dbadapter.getDBTYPE(), this.dbname);
        PreparedStatement pstmt = this.con.prepareStatement(sql, this.getScrollType(this.dbname), this.getCursorType(this.dbname));
        if (isquery && (fetchsize = this.pool.getJDBCPoolMetadata().getQueryfetchsize()) > 0) {
            pstmt.setFetchSize(fetchsize);
        }
        this.statements.add(pstmt);
        return pstmt;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this._prepareStatement(sql, false);
    }

    public PreparedStatement prepareStatement(String sql, boolean getgenkeys) throws SQLException {
        if (this.dbname == null) {
            this.dbname = SQLManager.getInstance().getDefaultDBName();
        }
        sql = this.interceptorInf.convertSQL(sql, this.dbadapter.getDBTYPE(), this.dbname);
        if (!getgenkeys) {
            PreparedStatement pstmt = this.con.prepareStatement(sql, this.getScrollType(this.dbname), this.getCursorType(this.dbname));
            this.statements.add(pstmt);
            return pstmt;
        }
        if (this.RETURN_GENERATED_KEYS) {
            PreparedStatement pstmt = this.con.prepareStatement(sql, 1);
            this.statements.add(pstmt);
            return pstmt;
        }
        PreparedStatement pstmt = this.con.prepareStatement(sql, this.getScrollType(this.dbname), this.getCursorType(this.dbname));
        this.statements.add(pstmt);
        return pstmt;
    }

    public PreparedStatement preparePagineStatement(boolean showsql) throws SQLException {
        this.paginesql = new DB.PagineSql(this.sql, true);
        if (this.rownum == null) {
            this.paginesql = this.getDBPagineSql(true);
            if (log.isInfoEnabled() && showsql && this.paginesql != null) {
                log.info("Execute JDBC prepared pagine query statement:{}", (Object)this.paginesql.getSql());
            }
        } else {
            this.paginesql = this.getDBPagineSqlForOracle(true);
        }
        return this._prepareStatement(this.paginesql.getSql(), true);
    }

    public PreparedStatement prepareCountStatement(boolean showsql) throws SQLException {
        String countsql = null;
        countsql = this.totalsizesql == null ? this.countSql() : this.totalsizesql;
        if (log.isInfoEnabled() && showsql) {
            log.info("Execute JDBC prepared pagine query count statement:{}", (Object)countsql);
        }
        return this.prepareStatement(countsql);
    }

    public String countSql() throws SQLException {
        String selectCount = "select count(1) from (" + this.sql + ") countsql_daul_forpagination";
        return selectCount;
    }

    public void addResultSet(ResultSet rs) {
        if (rs != null) {
            this.resultSets.add(rs);
        }
    }

    public void absolute(ResultSet rs) throws SQLException {
        if (!this.paginesql.isRebuilded() && rs != null && this.getOffset() > 0L) {
            rs.absolute((int)this.getOffset());
        }
    }

    public DB.PagineSql paginesql(boolean prepared) {
        if (this.paginesql == null) {
            this.paginesql = this.rownum == null ? (this.isRobotquery() ? this.getDBPagineSql(prepared) : new DB.PagineSql(this.getSql(), prepared)) : this.getDBPagineSqlForOracle(prepared);
        }
        return this.paginesql;
    }

    public void errorHandle(Exception sqle) throws SQLException {
        if (this.outcon) {
            if (this.tx != null && this.con != null && this.con instanceof TXConnection) {
                try {
                    this.tx.setRollbackOnly();
                }
                catch (Exception exception) {}
            }
        } else if (this.tx != null) {
            try {
                this.tx.setRollbackOnly();
            }
            catch (Exception exception) {}
        } else if (this.con != null && this.needTransaction) {
            try {
                this.con.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.con.setAutoCommit(this.oldautocommit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sqle instanceof SQLException) {
            throw (SQLException)sqle;
        }
        if (sqle instanceof TransactionException) {
            Throwable e = ((TransactionException)((Object)sqle)).getCause();
            if (e == null) {
                throw new NestedSQLException(sqle.getMessage(), sqle);
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new NestedSQLException(sqle.getMessage(), sqle);
        }
        throw new NestedSQLException(sqle.getMessage(), sqle);
    }

    public void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        rs = null;
    }

    public void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement = null;
    }

    public void dofinally() {
        try {
            int i;
            if (this.resultSets != null && this.resultSets.size() > 0) {
                for (i = 0; i < this.resultSets.size(); ++i) {
                    try {
                        this.closeResultSet((ResultSet)this.resultSets.get(i));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.resultSets = null;
            }
            if (this.statements != null && this.statements.size() > 0) {
                for (i = 0; i < this.statements.size(); ++i) {
                    try {
                        this.closeStatement((Statement)this.statements.get(i));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.statements = null;
            }
            try {
                if (!this.outcon && this.tx == null && this.con != null) {
                    this.con.close();
                    this.con = null;
                }
                this.con = null;
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSql() {
        return this.sql;
    }

    public boolean isGoNative() {
        return this.goNative;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getMaxsize() {
        return this.maxsize;
    }

    public boolean isRobotquery() {
        return this.robotquery;
    }

    public void setOffset(long offset) {
        this.offset = offset > 0L ? offset : 0L;
    }

    public void commit() throws SQLException {
        if (!this.outcon && this.tx == null && this.needTransaction) {
            this.con.commit();
        }
    }

    public Record[] buildCommonResult(Statement s) throws SQLException {
        Record[] results = new Record[]{new Record(1)};
        String str = "Rows Affected";
        int num = s.getUpdateCount();
        switch (num) {
            case 0: {
                results[0].put(str, "No rows affected");
                break;
            }
            case 1: {
                results[0].put(str, "1 row affected");
                break;
            }
            default: {
                results[0].put(str, num + " rows affected");
            }
        }
        return results;
    }

    public Object[] buildResultForObjectArray(ResultSet res, int containersize, boolean ispagine, Class objectType, RowHandler rowHandler) throws SQLException {
        int i;
        Object[] temp;
        int rowcount = 0;
        if (this.meta == null) {
            this.cacheResultSetMetaData(res, ispagine);
        }
        Object[] results = new Object[containersize];
        boolean go = true;
        go = ispagine ? res.next() && rowcount < this.getMaxsize() : res.next();
        boolean ismap = Map.class.isAssignableFrom(objectType);
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo((Class)objectType);
        while (go) {
            if (rowcount == results.length) {
                temp = new Object[results.length + 10];
                for (int t = 0; t < results.length; ++t) {
                    temp[t] = results[t];
                }
                results = temp;
            }
            Object record = ResultMap.buildValueObject(res, objectType, this, rowHandler, ismap, beanInfo);
            results[rowcount] = record;
            ++rowcount;
            if (ispagine) {
                go = res.next() && rowcount < this.getMaxsize();
                continue;
            }
            go = res.next();
        }
        if (results[0] == null) {
            return null;
        }
        temp = null;
        for (i = 0; i < results.length; ++i) {
            if (results[i] == null) {
                temp = new Object[i];
                break;
            }
            temp = new Object[results.length];
        }
        for (i = 0; i < temp.length; ++i) {
            temp[i] = results[i];
        }
        results = temp;
        temp = null;
        return results;
    }

    public <T> List<T> buildResultForList(ResultSet res, int containersize, boolean ispagine, Class<T> objectType, RowHandler rowHandler) throws SQLException {
        int rowcount = 0;
        if (this.meta == null) {
            this.cacheResultSetMetaData(res, ispagine);
        }
        ArrayList<T> results = new ArrayList<T>(containersize);
        boolean go = true;
        go = ispagine ? res.next() && rowcount < this.getMaxsize() : res.next();
        boolean ismap = Map.class.isAssignableFrom(objectType);
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(objectType);
        while (go) {
            T record = ResultMap.buildValueObject(res, objectType, this, rowHandler, ismap, beanInfo);
            results.add(record);
            ++rowcount;
            if (ispagine) {
                go = res.next() && rowcount < this.getMaxsize();
                continue;
            }
            go = res.next();
        }
        return results;
    }

    public int buildResult(ResultSet res, boolean ispagine, RowHandler rowHandler) throws SQLException {
        this.rowcount = 0;
        if (this.meta == null) {
            this.cacheResultSetMetaData(res, ispagine);
        }
        if (!(rowHandler instanceof ResultSetHandler)) {
            boolean go = true;
            go = ispagine ? res.next() && this.rowcount < this.getMaxsize() : res.next();
            while (go) {
                ResultMap.buildRecord(res, this, rowHandler, this.dbadapter);
                ++this.rowcount;
                if (ispagine) {
                    go = res.next() && this.rowcount < this.getMaxsize();
                    continue;
                }
                go = res.next();
            }
        } else {
            try {
                ((ResultSetHandler)rowHandler).handleResult(res, this);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NestedSQLException(e);
            }
        }
        return this.rowcount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildResultForXml(ResultSet res, int containersize, boolean ispagine, Class objectType, RowHandler rowHandler) throws SQLException {
        StringBuilder results = new StringBuilder();
        RowHandler xhdl = null;
        try {
            boolean isxmlhandler = false;
            if (rowHandler == null) {
                xhdl = new XMLRowHandler();
                xhdl.init(this, this.getMeta(), this.getDbname());
                rowHandler = xhdl;
                isxmlhandler = true;
            } else if (rowHandler instanceof XMLRowHandler) {
                isxmlhandler = true;
                xhdl = (XMLRowHandler)rowHandler;
                xhdl.init(this, this.getMeta(), this.getDbname());
            }
            if (!isxmlhandler) {
                results.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
                results.append("<records>\r\n");
            } else {
                results.append("<?xml version=\"").append(((XMLRowHandler)xhdl).getVersion()).append("\" encoding=\"").append(((XMLRowHandler)xhdl).getEncoding()).append("\"?>\r\n");
                results.append("<").append(((XMLRowHandler)xhdl).getRootName()).append(">\r\n");
            }
            this.rowcount = 0;
            if (this.meta == null) {
                this.cacheResultSetMetaData(res, ispagine);
            }
            boolean go = true;
            go = ispagine ? res.next() && this.rowcount < this.getMaxsize() : res.next();
            while (go) {
                StringBuilder record = ResultMap.buildSingleRecordXMLString(res, this, rowHandler, this.dbadapter);
                results.append((CharSequence)record);
                ++this.rowcount;
                if (ispagine) {
                    go = res.next() && this.rowcount < this.getMaxsize();
                    continue;
                }
                go = res.next();
            }
            if (!isxmlhandler) {
                results.append("\r\n").append("</records>");
            } else {
                results.append("\r\n").append("</").append(((XMLRowHandler)xhdl).getRootName()).append(">");
            }
        }
        finally {
            if (xhdl != null) {
                xhdl.destroy();
            }
        }
        return results.toString();
    }

    public Record[] buildResult(ResultSet res, int containersize, boolean ispagine) throws SQLException {
        int i;
        Record[] temp;
        int rowcount = 0;
        if (this.meta == null) {
            this.cacheResultSetMetaData(res, ispagine);
        }
        Record[] results = new Record[containersize];
        boolean go = true;
        go = ispagine ? res.next() && rowcount < this.getMaxsize() : res.next();
        while (go) {
            Record record;
            if (rowcount == results.length) {
                temp = new Record[results.length + 10];
                for (int t = 0; t < results.length; ++t) {
                    temp[t] = results[t];
                }
                results = temp;
            }
            results[rowcount] = record = ResultMap.buildMap(res, this, this.dbadapter);
            ++rowcount;
            if (ispagine) {
                go = res.next() && rowcount < this.getMaxsize();
                continue;
            }
            go = res.next();
        }
        if (results[0] == null) {
            return null;
        }
        temp = null;
        for (i = 0; i < results.length; ++i) {
            if (results[i] == null) {
                temp = new Record[i];
                break;
            }
            temp = new Record[results.length];
        }
        for (i = 0; i < temp.length; ++i) {
            temp[i] = results[i];
        }
        results = temp;
        temp = null;
        return results;
    }

    public <T> ResultMap buildResultMap(ResultSet res, Class<T> objectType, RowHandler rowhandler, int containersize, boolean ispagine, int result_type) throws SQLException {
        ResultMap resultMap = new ResultMap();
        if (result_type == ResultMap.type_maparray || result_type == ResultMap.type_objectarray && Map.class.isAssignableFrom(objectType)) {
            Record[] results = this.buildResult(res, containersize, ispagine);
            resultMap.setCommonresult(results);
            if (results != null) {
                resultMap.setSize(results.length);
            }
        } else if (result_type == ResultMap.type_list) {
            List<T> results = this.buildResultForList(res, containersize, ispagine, objectType, rowhandler);
            resultMap.setCommonresult(results);
            if (results != null) {
                resultMap.setSize(results.size());
            }
        } else if (result_type == ResultMap.type_objcet) {
            if (!ispagine && res.next()) {
                ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(objectType);
                boolean ismap = Map.class.isAssignableFrom(objectType);
                T result = ResultMap.buildValueObject(res, objectType, this, rowhandler, ismap, beanInfo);
                resultMap.setCommonresult(result);
                if (result != null) {
                    resultMap.setSize(1);
                }
            }
        } else if (result_type == ResultMap.type_objectarray) {
            Object[] results = this.buildResultForObjectArray(res, containersize, ispagine, objectType, rowhandler);
            resultMap.setCommonresult(results);
            if (results != null) {
                resultMap.setSize(results.length);
            }
        } else if (result_type == ResultMap.type_xml) {
            if (rowhandler == null) {
                rowhandler = new XMLRowHandler();
            }
            resultMap.setCommonresult(this.buildResultForXml(res, containersize, ispagine, objectType, rowhandler));
            resultMap.setSize(this.getRowcount());
        } else if (result_type == ResultMap.type_null) {
            if (rowhandler == null) {
                throw new NestedSQLException("rowhandler == null");
            }
            this.rowcount = this.buildResult(res, ispagine, rowhandler);
            resultMap.setSize(this.getRowcount());
        }
        return resultMap;
    }

    public static long rebuildOffset(long offset, int pagesize, long totalSize) {
        long offset_ = offset;
        if (totalSize > 0L) {
            if (offset > 0L) {
                if (totalSize <= offset) {
                    offset_ = totalSize - (long)pagesize - 1L;
                }
            } else {
                offset_ = 0L;
            }
        }
        return offset_;
    }

    public long rebuildOffset(long totalSize) {
        this.setOffset(StatementInfo.rebuildOffset(this.getOffset(), this.getMaxsize(), totalSize));
        return this.getOffset();
    }

    public void resetPostion(PreparedStatement statement, int startidx, int endidx, long offset) throws SQLException {
        this.dbadapter.resetPostion(statement, startidx, endidx, this.getOffset(), this.getMaxsize());
    }

    public DB.PagineSql getDBPagineSql(boolean prepared) {
        if (this.pagineOrderBy == null || this.pagineOrderBy.trim().equals("")) {
            return this.dbadapter.getDBPagineSql(this.sql, this.offset, this.maxsize, prepared);
        }
        return this.dbadapter.getDBPagineSql(this.sql, this.offset, this.maxsize, prepared, this.pagineOrderBy);
    }

    public DB.PagineSql getDBPagineSqlForOracle(boolean prepared) {
        return this.dbadapter.getOracleDBPagineSql(this.sql, this.offset, this.maxsize, this.rownum, prepared);
    }

    public String getDbname() {
        return this.dbname;
    }

    public Connection getCon() {
        return this.con;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void cacheResultSetMetaData(ResultSet rs, boolean pagine) throws SQLException {
        String key = this.getSql();
        if (pagine) {
            key = key + "__pagine";
        }
        this.meta = this.pool.getJDBCPoolMetadata().cachequerymetadata() ? this.newsqlinfo.getPoolManResultSetMetaData(this.pool.getDbAdapter(), this.dbname, key, rs.getMetaData()) : PoolManResultSetMetaData.getCopy(this.pool.getDbAdapter(), rs.getMetaData());
    }

    public PoolManResultSetMetaData getMeta() {
        return this.meta;
    }

    public Statement createStatement() throws SQLException {
        Statement stmt = this.con.createStatement(this.getScrollType(this.dbname), this.getCursorType(this.dbname));
        this.statements.add(stmt);
        return stmt;
    }

    public CallableStatement prepareCallableStatement() throws SQLException {
        CallableStatement cstmt = this.con.prepareCall(this.getSql(), this.getScrollType(this.dbname), this.getCursorType(this.dbname));
        this.statements.add(cstmt);
        return cstmt;
    }

    public static void main(String[] args) {
        Record[] t;
        Record[] tt = t = new Record[10];
        System.out.println(t == tt);
    }

    public int getRowcount() {
        return this.rowcount;
    }

    public int getCursorType(String dbname) {
        try {
            return this.dbadapter.getCusorType(this.pool.getDriver());
        }
        catch (Exception e) {
            log.error(dbname, (Throwable)e);
            JDBCPool pool = SQLUtil.getSQLManager().getPool(null);
            return pool.getDbAdapter().getCusorType(pool.getDriver());
        }
    }

    public int getScrollType(String dbname) {
        try {
            return this.dbadapter.getSCROLLType(this.pool.getDriver());
        }
        catch (Exception e) {
            log.error(dbname, (Throwable)e);
            JDBCPool pool = SQLUtil.getSQLManager().getPool(null);
            return pool.getDbAdapter().getSCROLLType(pool.getDriver());
        }
    }

    public long getTotalsize() {
        return this.totalsize;
    }

    public void setTotalsize(long totalsize) {
        this.totalsize = totalsize;
    }

    public String getTotalsizesql() {
        return this.totalsizesql;
    }

    public void setTotalsizesql(String totalsizesql) {
        this.totalsizesql = totalsizesql;
    }

    public DB.PagineSql getPaginesql() {
        return this.paginesql;
    }

    public void setRETURN_GENERATED_KEYS(boolean rETURN_GENERATED_KEYS) {
        this.RETURN_GENERATED_KEYS = rETURN_GENERATED_KEYS;
    }

    public boolean isRETURN_GENERATED_KEYS() {
        return this.RETURN_GENERATED_KEYS;
    }

    public DB getDbadapter() {
        return this.dbadapter;
    }
}

