/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.adapter;

import com.frameworkset.orm.adapter.DB;
import com.frameworkset.orm.adapter.DBAxion;
import com.frameworkset.orm.adapter.DBCloudscape;
import com.frameworkset.orm.adapter.DBDB2400;
import com.frameworkset.orm.adapter.DBDB2App;
import com.frameworkset.orm.adapter.DBDB2Net;
import com.frameworkset.orm.adapter.DBDerby;
import com.frameworkset.orm.adapter.DBElasticsearch;
import com.frameworkset.orm.adapter.DBH2;
import com.frameworkset.orm.adapter.DBHive;
import com.frameworkset.orm.adapter.DBHypersonicSQL;
import com.frameworkset.orm.adapter.DBInformix;
import com.frameworkset.orm.adapter.DBInstantDB;
import com.frameworkset.orm.adapter.DBInterbase;
import com.frameworkset.orm.adapter.DBMM;
import com.frameworkset.orm.adapter.DBMSSQL;
import com.frameworkset.orm.adapter.DBMariaDB;
import com.frameworkset.orm.adapter.DBNone;
import com.frameworkset.orm.adapter.DBOdbc;
import com.frameworkset.orm.adapter.DBOracle;
import com.frameworkset.orm.adapter.DBPostgres;
import com.frameworkset.orm.adapter.DBSQLiteXerial;
import com.frameworkset.orm.adapter.DBSapDB;
import com.frameworkset.orm.adapter.DBSybase;
import com.frameworkset.orm.adapter.DBWeblogic;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBFactory {
    private static Logger log = LoggerFactory.getLogger(DBFactory.class);
    private static Map<String, Class> adapters = Collections.synchronizedMap(new HashMap(40));
    public static final String DBDB2400 = "as400";
    public static final String DBDB2App = "db2app";
    public static final String DBDB2Net = "db2net";
    public static final String DBCloudscape = "cloudscape";
    public static final String DBHypersonicSQL = "hypersonic";
    public static final String DBInterbase = "interbase";
    public static final String DBInstantDB = "instantdb";
    public static final String DBMSSQL = "mssql";
    public static final String DBMMysql = "mysql";
    public static final String DBMariaDB = "mariadb";
    public static final String DBOracle = "oracle";
    public static final String DBPostgres = "postgresql";
    public static final String DBSapDB = "sapdb";
    public static final String DBSybase = "sybase";
    public static final String DBWeblogic = "weblogic";
    public static final String DBAxion = "axion";
    public static final String DBInformix = "informix";
    public static final String DBOdbc = "odbc";
    public static final String DBAccess = "msaccess";
    public static final String DBDerby = "derby";
    public static final String DBHive = "hive";
    public static final String DBNone = "";
    public static final String SQLITEX = "sqlitex";

    public static DB create(String driver) throws InstantiationException {
        Class adapterClass;
        if (driver == null || driver.trim().equals(DBNone)) {
            driver = DBNone;
        }
        if ((adapterClass = adapters.get(driver)) != null) {
            try {
                DB adapter = (DB)adapterClass.newInstance();
                if (driver.indexOf(".") < 0) {
                    adapter.setDbtype(driver);
                } else {
                    adapter.setDbtype(DBFactory.lookupdbtype(adapterClass, driver));
                }
                return adapter;
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException("Could not instantiate adapter for JDBC driver: " + driver + ": Assure that adapter bytecodes are in your classpath");
            }
        }
        throw new InstantiationException("Unknown JDBC driver: " + driver + ": Check your configuration file");
    }

    private static String lookupdbtype(Class dbadaptor, String dbtype) {
        for (Map.Entry<String, Class> entry : adapters.entrySet()) {
            String key = entry.getKey();
            Class value = entry.getValue();
            if (dbadaptor != value || key.indexOf(".") >= 0) continue;
            return key;
        }
        return dbtype;
    }

    private static void replaceOthers(Class newclz, String newkey, Class defaultclazz) {
        for (Map.Entry<String, Class> entry : adapters.entrySet()) {
            String key = entry.getKey();
            Class value = entry.getValue();
            if (defaultclazz != value || newkey.equals(key)) continue;
            log.debug("Use custom adapter[" + newclz + "] to replace default adapter[" + defaultclazz + "] for db[" + key + "]");
            adapters.put(key, newclz);
        }
    }

    public static void addDBAdaptors(Map<String, String> adaptors) {
        if (adaptors == null || adaptors.size() == 0) {
            return;
        }
        for (Map.Entry<String, String> entry : adaptors.entrySet()) {
            Class<?> newclz;
            String key = entry.getKey();
            String value = entry.getValue();
            Class defaultclazz = adapters.get(key);
            if (defaultclazz != null) {
                log.debug("Use custom adapter[" + value + "] to replace default adapter[" + defaultclazz + "] for db[" + key + "]");
                try {
                    newclz = Class.forName(value);
                    DBFactory.replaceOthers(newclz, key, defaultclazz);
                    adapters.put(key, newclz);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                continue;
            }
            log.debug("Add custom adapter[" + value + "] with db[" + key + "]");
            try {
                newclz = Class.forName(value);
                adapters.put(key, newclz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        adapters.put("com.ibm.as400.access.AS400JDBCDriver", DBDB2400.class);
        adapters.put("COM.ibm.db2.jdbc.app.DB2Driver", DBDB2App.class);
        adapters.put("COM.ibm.db2.jdbc.net.DB2Driver", DBDB2Net.class);
        adapters.put("COM.cloudscape.core.JDBCDriver", DBCloudscape.class);
        adapters.put("org.hsql.jdbcDriver", DBHypersonicSQL.class);
        adapters.put("org.hsqldb.jdbcDriver", DBHypersonicSQL.class);
        adapters.put("interbase.interclient.Driver", DBInterbase.class);
        adapters.put("org.enhydra.instantdb.jdbc.idbDriver", DBInstantDB.class);
        adapters.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", DBMSSQL.class);
        adapters.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", DBMSSQL.class);
        adapters.put("net.sourceforge.jtds.jdbc.Driver", DBMSSQL.class);
        adapters.put("com.jnetdirect.jsql.JSQLDriver", DBMSSQL.class);
        adapters.put("org.gjt.mm.mysql.Driver", DBMM.class);
        adapters.put("com.mysql.jdbc.Driver", DBMM.class);
        adapters.put("org.elasticsearch.xpack.sql.jdbc.jdbc.JdbcDriver", DBMM.class);
        adapters.put("elasticsearch", DBElasticsearch.class);
        adapters.put("org.mariadb.jdbc.Driver", DBElasticsearch.class);
        adapters.put("oracle.jdbc.driver.OracleDriver", DBOracle.class);
        adapters.put("oracle.jdbc.OracleDriver", DBOracle.class);
        adapters.put("org.postgresql.Driver", DBPostgres.class);
        adapters.put("com.sap.dbtech.jdbc.DriverSapDB", DBSapDB.class);
        adapters.put("com.sybase.jdbc.SybDriver", DBSybase.class);
        adapters.put("com.sybase.jdbc2.jdbc.SybDriver", DBSybase.class);
        adapters.put("weblogic.jdbc.pool.Driver", DBWeblogic.class);
        adapters.put("org.axiondb.jdbc.AxionDriver", DBAxion.class);
        adapters.put("com.informix.jdbc.IfxDriver", DBInformix.class);
        adapters.put("sun.jdbc.odbc.JdbcOdbcDriver", DBOdbc.class);
        adapters.put("com.ibm.db2.jcc.DB2Driver", DBDerby.class);
        adapters.put("org.apache.derby.jdbc.EmbeddedDriver", DBDerby.class);
        adapters.put("org.apache.derby.jdbc.ClientDriver", DBDerby.class);
        adapters.put(DBDB2400, DBDB2400.class);
        adapters.put(DBDB2App, DBDB2App.class);
        adapters.put(DBDB2Net, DBDB2Net.class);
        adapters.put(DBCloudscape, DBCloudscape.class);
        adapters.put(DBHypersonicSQL, DBHypersonicSQL.class);
        adapters.put(DBInterbase, DBInterbase.class);
        adapters.put(DBInstantDB, DBInstantDB.class);
        adapters.put(DBMSSQL, DBMSSQL.class);
        adapters.put(DBMMysql, DBMM.class);
        adapters.put(DBMariaDB, DBMariaDB.class);
        adapters.put(DBOracle, DBOracle.class);
        adapters.put(DBPostgres, DBPostgres.class);
        adapters.put(DBSapDB, DBSapDB.class);
        adapters.put(DBSybase, DBSybase.class);
        adapters.put(DBWeblogic, DBWeblogic.class);
        adapters.put(DBAxion, DBAxion.class);
        adapters.put(DBInformix, DBInformix.class);
        adapters.put(DBOdbc, DBOdbc.class);
        adapters.put(DBAccess, DBOdbc.class);
        adapters.put(DBDerby, DBDerby.class);
        adapters.put(SQLITEX, DBSQLiteXerial.class);
        adapters.put("org.sqlite.JDBC", DBSQLiteXerial.class);
        adapters.put("org.h2.Driver", DBH2.class);
        adapters.put("h2", DBH2.class);
        adapters.put(DBNone, DBNone.class);
        adapters.put("org.apache.hive.jdbc.HiveDriver", DBHive.class);
        adapters.put(DBHive, DBHive.class);
    }
}

