/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import com.frameworkset.common.poolman.CallableParam;
import com.frameworkset.common.poolman.CallableParams;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.NewSQLInfo;
import com.frameworkset.common.poolman.Param;
import com.frameworkset.common.poolman.Params;
import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.ResultMap;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.RowHandler;
import com.frameworkset.common.poolman.handle.XMLMark;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableDBUtil
extends PreparedDBUtil {
    public static int CALL_PROCEDURE = 0;
    public static int CALL_FUNCTION = 1;
    private static Logger log = LoggerFactory.getLogger(CallableDBUtil.class);
    private ResultMap callableResult;

    @Override
    protected Param buildParam() {
        return this.buildCallableParam();
    }

    @Override
    protected Params buildParams() {
        return this.buildCallableParams(CALL_PROCEDURE);
    }

    protected Params buildCallableParams(int calltype) {
        CallableParams temp_ = new CallableParams();
        temp_.call_type = calltype;
        return temp_;
    }

    protected CallableParam buildCallableParam() {
        return new CallableParam();
    }

    private void addCallableParam(int index, int sqlType, String method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.sqlType = sqlType;
        param.index = index;
        param.method = method;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(int index, int sqlType, String typeName, String method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.sqlType = sqlType;
        param.index = index;
        param.method = method;
        param.typeName = typeName;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(int index, int sqlType, int scale, String method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.sqlType = sqlType;
        param.index = index;
        param.method = method;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(String paramName, int sqlType, String method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = paramName;
        param.sqlType = sqlType;
        param.method = method;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(String parameterName, int sqlType, String typeName, String method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = parameterName;
        param.sqlType = sqlType;
        param.typeName = typeName;
        param.method = method;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(String paramName, int sqlType, int scale, String method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = paramName;
        param.sqlType = sqlType;
        param.scale = scale;
        param.method = method;
        param.isOut = true;
        ((CallableParams)this.Params).callParams.add(param);
        ((CallableParams)this.Params).outParams.add(param);
    }

    private void addCallableParam(String paramName, Object value, int scale, String method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = paramName;
        param.data = value;
        param.scale = scale;
        param.method = method;
        ((CallableParams)this.Params).callParams.add(param);
    }

    private void addCallableParam(String parameterName, Object value, String method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = parameterName;
        param.data = value;
        param.method = method;
        ((CallableParams)this.Params).callParams.add(param);
    }

    private void addCallableParam(String parameterName, Object value, int targetSqlType, int scale, String method) throws SQLException {
        CallableParam param = this.buildCallableParam();
        param.parameterName = parameterName;
        param.data = value;
        param.sqlType = targetSqlType;
        param.scale = scale;
        param.method = method;
        ((CallableParams)this.Params).callParams.add(param);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.addCallableParam(parameterIndex, sqlType, "registerOutParameter(int parameterIndex, int sqlType)");
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.addCallableParam(parameterIndex, sqlType, scale, "registerOutParameter(int parameterIndex, int sqlType, int scale)");
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    public String getString(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getString(parameterIndex);
        }
        return null;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBoolean(parameterIndex);
        }
        throw new SQLException("getBoolean(" + parameterIndex + ") failed:value=null.");
    }

    public byte getByte(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getByte(parameterIndex);
        }
        throw new SQLException("getByte(" + parameterIndex + ") failed:value=null.");
    }

    public short getShort(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getShort(parameterIndex);
        }
        throw new SQLException("getShort(" + parameterIndex + ") failed:value=null.");
    }

    public int getInt(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getInt(parameterIndex);
        }
        throw new SQLException("getInt(" + parameterIndex + ") failed:value=null.");
    }

    public long getLong(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getLong(parameterIndex);
        }
        throw new SQLException("getInt(" + parameterIndex + ") failed:value=null.");
    }

    public float getFloat(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getFloat(parameterIndex);
        }
        throw new SQLException("getFloat(" + parameterIndex + ") failed:value=null.");
    }

    public double getDouble(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDouble(parameterIndex);
        }
        throw new SQLException("getDouble(" + parameterIndex + ") failed:value=null.");
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBigDecimal(parameterIndex, scale);
        }
        return null;
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBytes(parameterIndex);
        }
        return null;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDate(parameterIndex);
        }
        return null;
    }

    public Time getTime(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTime(parameterIndex);
        }
        return null;
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTimestamp(parameterIndex);
        }
        return null;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getObject(parameterIndex);
        }
        return null;
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBigDecimal(parameterIndex);
        }
        return null;
    }

    public Object getObject(int i, Map map) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getObject(i, map);
        }
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getRef(i);
        }
        return null;
    }

    public Blob getBlob(int i) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBlob(i);
        }
        return null;
    }

    public Clob getClob(int i) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getClob(i);
        }
        return null;
    }

    public Array getArray(int i) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getArray(i);
        }
        return null;
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDate(parameterIndex, cal);
        }
        return null;
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTime(parameterIndex, cal);
        }
        return null;
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTimestamp(parameterIndex, cal);
        }
        return null;
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.addCallableParam(paramIndex, sqlType, typeName, "registerOutParameter (int paramIndex, int sqlType, String typeName)");
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.addCallableParam(parameterName, sqlType, "registerOutParameter(String parameterName, int sqlType)");
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.addCallableParam(parameterName, sqlType, scale, "registerOutParameter(String parameterName, int sqlType)");
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.addCallableParam(parameterName, sqlType, typeName, "registerOutParameter (String parameterName, int sqlType, String typeName)");
    }

    public URL getURL(int parameterIndex) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getURL(parameterIndex);
        }
        return null;
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        this.addCallableParam(parameterName, val, "setURL(String parameterName, java.net.URL val)");
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.addCallableParam(parameterName, new Integer(sqlType), "setNull(String parameterName, int sqlType)");
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.addCallableParam(parameterName, new Boolean(x), "setBoolean(String parameterName, boolean x)");
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.addCallableParam(parameterName, new Byte(x), "setByte(String parameterName, byte x)");
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.addCallableParam(parameterName, new Short(x), "setShort(String parameterName, short x)");
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.addCallableParam(parameterName, new Integer(x), "setInt(String parameterName, int x)");
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.addCallableParam(parameterName, new Long(x), "setLong(String parameterName, long x)");
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.addCallableParam(parameterName, new Float(x), "setFloat(String parameterName, float x)");
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.addCallableParam(parameterName, new Double(x), "setDouble(String parameterName, double x)");
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.addCallableParam(parameterName, x, "setBigDecimal(String parameterName, BigDecimal x)");
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.addCallableParam(parameterName, x, "setString(String parameterName, String x)");
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.addCallableParam(parameterName, x, "setBytes(String parameterName, byte x[])");
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.addCallableParam(parameterName, x, "setDate(String parameterName, java.sql.Date x)");
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.addCallableParam(parameterName, x, "setTime(String parameterName, java.sql.Time x)");
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.addCallableParam(parameterName, x, "setTimestamp(String parameterName, java.sql.Timestamp x)");
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{x, new Integer(length)}, "setAsciiStream(String parameterName, java.io.InputStream x, int length)");
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{x, new Integer(length)}, "setBinaryStream(String parameterName, java.io.InputStream x, int length)");
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.addCallableParam(parameterName, x, targetSqlType, scale, "setObject(String parameterName, Object x, int targetSqlType, int scale)");
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.addCallableParam(parameterName, x, targetSqlType, "setObject(String parameterName, Object x, int targetSqlType)");
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.addCallableParam(parameterName, x, "setObject(String parameterName, Object x)");
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{reader, new Integer(length)}, "setCharacterStream(String parameterName,java.io.Reader reader,int length)");
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{x, cal}, "setDate(String parameterName, java.sql.Date x, Calendar cal)");
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{x, cal}, "setTime(String parameterName, java.sql.Time x, Calendar cal)");
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{x, cal}, "setTimestamp(String parameterName, java.sql.Timestamp x, Calendar cal)");
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.addCallableParam(parameterName, new Object[]{new Integer(sqlType), typeName}, "setNull(String parameterName, int sqlType, String typeName)");
    }

    public String getString(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getString(parameterName);
        }
        return null;
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBoolean(parameterName);
        }
        throw new SQLException("getBoolean(" + parameterName + ") failed:value=null.");
    }

    public byte getByte(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getByte(parameterName);
        }
        throw new SQLException("getByte(" + parameterName + ") failed:value=null.");
    }

    public short getShort(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getShort(parameterName);
        }
        throw new SQLException("getShort(" + parameterName + ") failed:value=null.");
    }

    public int getInt(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getInt(parameterName);
        }
        throw new SQLException("getInt(" + parameterName + ") failed:value=null.");
    }

    public long getLong(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getLong(parameterName);
        }
        throw new SQLException("getInt(" + parameterName + ") failed:value=null.");
    }

    public float getFloat(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getFloat(parameterName);
        }
        throw new SQLException("getFloat(" + parameterName + ") failed:value=null.");
    }

    public double getDouble(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDouble(parameterName);
        }
        throw new SQLException("getDouble(" + parameterName + ") failed:value=null.");
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBytes(parameterName);
        }
        return null;
    }

    public Date getDate(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDate(parameterName);
        }
        return null;
    }

    public Time getTime(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTime(parameterName);
        }
        return null;
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTimestamp(parameterName);
        }
        return null;
    }

    public Object getObject(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getObject(parameterName);
        }
        return null;
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBigDecimal(parameterName);
        }
        return null;
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getObject(parameterName, map);
        }
        return null;
    }

    public Ref getRef(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getRef(parameterName);
        }
        return null;
    }

    public Blob getBlob(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getBlob(parameterName);
        }
        return null;
    }

    public Clob getClob(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getClob(parameterName);
        }
        return null;
    }

    public Array getArray(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getArray(parameterName);
        }
        return null;
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getDate(parameterName, cal);
        }
        return null;
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTime(parameterName, cal);
        }
        return null;
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getTimestamp(parameterName, cal);
        }
        return null;
    }

    public URL getURL(String parameterName) throws SQLException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            return this.callableResult.getOrigineprocresult().getURL(parameterName);
        }
        return null;
    }

    public void getFile(int index, File file) throws SQLException, IOException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            this.callableResult.getOrigineprocresult().getFile(index, file);
        }
    }

    public void getFile(String parameterName, File file) throws SQLException, IOException {
        if (this.callableResult != null && this.callableResult.getOrigineprocresult() != null) {
            this.callableResult.getOrigineprocresult().getFile(parameterName, file);
        }
    }

    public void prepareCallable(String sql) {
        this.Params = this.buildCallableParams(CALL_PROCEDURE);
        this.Params.prepareSqlifo = new NewSQLInfo(sql);
    }

    public void prepareCallable(String preparedDBName, String sql) {
        this.prepareDBName = preparedDBName;
        this.Params = this.buildCallableParams(CALL_PROCEDURE);
        this.Params.prepareSqlifo = new NewSQLInfo(sql);
    }

    private void prepareCallable(String sql, int calltype) throws SQLException {
        if (calltype != CALL_FUNCTION && calltype != CALL_PROCEDURE) {
            throw new SQLException("CALL_TYPE error: Must be CALL_FUNCTION or CALL_PROCEDURE.");
        }
        this.Params = this.buildCallableParams(calltype);
        this.Params.prepareSqlifo = new NewSQLInfo(sql);
    }

    private void prepareCallable(String preparedDBName, String sql, int calltype) throws SQLException {
        if (calltype != CALL_FUNCTION && calltype != CALL_PROCEDURE) {
            throw new SQLException("CALL_TYPE error: Must be CALL_FUNCTION or CALL_PROCEDURE.");
        }
        this.prepareDBName = preparedDBName;
        this.Params = this.buildCallableParams(calltype);
        this.Params.prepareSqlifo = new NewSQLInfo(sql);
    }

    public void executeCallable() throws SQLException {
        this.executeCallable(null, Map.class, null);
    }

    public String executeCallableForXML() throws SQLException {
        return this.executeCallableForXML(null, null);
    }

    public String executeCallableForXML(RowHandler rowhandler) throws SQLException {
        return this.executeCallableForXML(null, rowhandler);
    }

    public String executeCallableForXML(Connection con) throws SQLException {
        return this.executeCallableForXML(con, null);
    }

    public String executeCallableForXML(Connection con, RowHandler rowhandler) throws SQLException {
        this.executeCallable(con, XMLMark.class, rowhandler);
        if (this.callableResult != null) {
            return (String)this.callableResult.getCommonresult();
        }
        return null;
    }

    public Object executeCallableForObject(Class objectClass, RowHandler rowHandler) throws SQLException {
        return this.executeCallableForObject(null, objectClass, rowHandler);
    }

    public Object executeCallableForObject(Class objectClass) throws SQLException {
        return this.executeCallableForObject(null, objectClass);
    }

    public Object executeCallableForObject(Connection con, Class objectClass) throws SQLException {
        return this.executeCallableForObject(con, objectClass, null);
    }

    public Object executeCallableForObject(Connection con, Class objectClass, RowHandler rowHandler) throws SQLException {
        this.executeCallable(con, objectClass, rowHandler);
        if (this.callableResult != null) {
            return this.callableResult.getCommonresult();
        }
        return null;
    }

    public void executeCallable(Connection con) throws SQLException {
        this.executeCallable(con, Map.class, null);
    }

    public void executeCallable(RowHandler rowHander) throws SQLException {
        this.executeCallable(null, Map.class, rowHander);
    }

    public void executeCallable(Connection con, RowHandler rowHander) throws SQLException {
        this.executeCallable(con, Map.class, rowHander);
    }

    protected void executeCallable(Connection con_, Class objectclass, RowHandler rowHander) throws SQLException {
        if (this.Params == null || !(this.Params instanceof CallableParams)) {
            throw new SQLException("Callable statement do not been set corrected.");
        }
        StatementInfo stmtInfo = null;
        CallableStatement cstmt = null;
        if (objectclass == null) {
            objectclass = Map.class;
        }
        ArrayList resources = null;
        try {
            stmtInfo = new StatementInfo(this.prepareDBName, this.Params.prepareSqlifo, false, con_, false);
            stmtInfo.init();
            CallableParams _params = (CallableParams)this.Params;
            cstmt = stmtInfo.prepareCallableStatement();
            resources = new ArrayList();
            super.setUpParams(this.Params, cstmt, resources);
            this.setUpCallableParams(_params, cstmt);
            if (log.isInfoEnabled() && CallableDBUtil.showsql(stmtInfo.getDbname())) {
                log.info("Execute JDBC callable statement:{}", (Object)stmtInfo.getSql());
            }
            boolean success = cstmt.execute();
            if (_params.outParams.size() > 0) {
                this.callableResult = new ResultMap();
            }
            if (_params.call_type == CALL_FUNCTION) {
                if (success) {
                    ResultSet res = cstmt.getResultSet();
                    stmtInfo.addResultSet(res);
                }
                if (this.callableResult != null) {
                    this.callableResult.handle(cstmt, null, objectclass, _params, stmtInfo, rowHander);
                }
            } else if (this.callableResult != null) {
                this.callableResult.handle(cstmt, null, objectclass, _params, stmtInfo, rowHander);
            }
        }
        catch (Exception e) {
            try {
                String error = "Execute " + this.Params.prepareSqlifo.getNewsql() + " on " + this.prepareDBName + " failed:" + e.getMessage();
                System.out.println(error);
                log.error(error, (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new NestedSQLException(e.getMessage(), e);
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
            }
            stmtInfo = null;
            if (this.Params != null) {
                this.Params.clear();
            }
            this.releaseResources(resources);
            resources = null;
        }
    }

    public Object getFunctionResult() {
        if (this.callableResult != null) {
            return this.callableResult.getFunctionResult();
        }
        return null;
    }

    protected void setUpCallableParams(CallableParams params, CallableStatement cstmt) throws SQLException {
        for (int i = 0; i < params.callParams.size(); ++i) {
            Object value;
            CallableParam param = (CallableParam)params.callParams.get(i);
            if (param.method.equals("registerOutParameter(int parameterIndex, int sqlType)")) {
                cstmt.registerOutParameter(param.index, param.sqlType);
                continue;
            }
            if (param.method.equals("registerOutParameter(int parameterIndex, int sqlType, int scale)")) {
                cstmt.registerOutParameter(param.index, param.sqlType, param.scale);
                continue;
            }
            if (param.method.equals("registerOutParameter (int paramIndex, int sqlType, String typeName)")) {
                cstmt.registerOutParameter(param.index, param.sqlType, param.typeName);
                continue;
            }
            if (param.method.equals("registerOutParameter(String parameterName, int sqlType)")) {
                cstmt.registerOutParameter(param.parameterName, param.sqlType);
                continue;
            }
            if (param.method.equals("registerOutParameter(String parameterName, int sqlType, int scale)")) {
                cstmt.registerOutParameter(param.parameterName, param.sqlType, param.scale);
                continue;
            }
            if (param.method.equals("registerOutParameter (String parameterName, int sqlType, String typeName)")) {
                cstmt.registerOutParameter(param.parameterName, param.sqlType, param.typeName);
                continue;
            }
            if (param.method.equals("setAsciiStream(String parameterName, java.io.InputStream x, int length)")) {
                value = (Object[])param.data;
                cstmt.setAsciiStream(param.parameterName, (InputStream)value[0], (int)((Integer)value[1]));
                continue;
            }
            if (param.method.equals("setBigDecimal(String parameterName, BigDecimal x)")) {
                value = (BigDecimal)param.data;
                cstmt.setBigDecimal(param.parameterName, (BigDecimal)value);
                continue;
            }
            if (param.method.equals("setBinaryStream(String parameterName, java.io.InputStream x, int length)")) {
                value = (Object[])param.data;
                cstmt.setBinaryStream(param.parameterName, (InputStream)value[0], (int)((Integer)value[1]));
                continue;
            }
            if (param.method.equals("setBoolean(String parameterName, boolean x)")) {
                cstmt.setBoolean(param.parameterName, (boolean)((Boolean)param.data));
                continue;
            }
            if (param.method.equals("setByte(String parameterName, byte x)")) {
                cstmt.setByte(param.parameterName, (byte)((Byte)param.data));
                continue;
            }
            if (param.method.equals("setBytes(String parameterName, byte x[])")) {
                cstmt.setBytes(param.parameterName, (byte[])param.data);
                continue;
            }
            if (param.method.equals("setCharacterStream(String parameterName,java.io.Reader reader,int length)")) {
                value = (Object[])param.data;
                cstmt.setCharacterStream(param.parameterName, (Reader)value[0], (int)((Integer)value[1]));
                continue;
            }
            if (param.method.equals("setDate(String parameterName, java.sql.Date x)")) {
                cstmt.setDate(param.parameterName, (Date)param.data);
                continue;
            }
            if (param.method.equals("setDate(String parameterName, java.sql.Date x, Calendar cal)")) {
                value = (Object[])param.data;
                cstmt.setDate(param.parameterName, (Date)value[0], (Calendar)value[1]);
                continue;
            }
            if (param.method.equals("setDouble(String parameterName, double x)")) {
                cstmt.setDouble(param.parameterName, (double)((Double)param.data));
                continue;
            }
            if (param.method.equals("setFloat(String parameterName, float x)")) {
                cstmt.setFloat(param.parameterName, ((Float)param.data).floatValue());
                continue;
            }
            if (param.method.equals("setInt(String parameterName, int x)")) {
                cstmt.setInt(param.parameterName, (int)((Integer)param.data));
                continue;
            }
            if (param.method.equals("setLong(String parameterName, long x)")) {
                cstmt.setLong(param.parameterName, (long)((Long)param.data));
                continue;
            }
            if (param.method.equals("setNull(String parameterName, int sqlType)")) {
                cstmt.setNull(param.parameterName, (int)((Integer)param.data));
                continue;
            }
            if (param.method.equals("setNull(String parameterName, int sqlType, String typeName)")) {
                value = (Object[])param.data;
                cstmt.setNull(param.parameterName, (int)((Integer)value[0]), (String)value[1]);
                continue;
            }
            if (param.method.equals("setObject(String parameterName, Object x)")) {
                cstmt.setObject(param.parameterName, param.data);
                continue;
            }
            if (param.method.equals("setObject(String parameterName, Object x, int targetSqlType)")) {
                cstmt.setObject(param.parameterName, param.data, param.sqlType);
                continue;
            }
            if (param.method.equals("setObject(String parameterName, Object x, int targetSqlType, int scale)")) {
                cstmt.setObject(param.parameterName, param.data, param.sqlType, param.scale);
                continue;
            }
            if (param.method.equals("setShort(String parameterName, short x)")) {
                cstmt.setShort(param.parameterName, (short)((Short)param.data));
                continue;
            }
            if (param.method.equals("setString(String parameterName, String x)")) {
                cstmt.setString(param.parameterName, (String)param.data);
                continue;
            }
            if (param.method.equals("setTime(String parameterName, java.sql.Time x)")) {
                cstmt.setTime(param.parameterName, (Time)param.data);
                continue;
            }
            if (param.method.equals("setTime(String parameterName, java.sql.Time x, Calendar cal)")) {
                value = (Object[])param.data;
                cstmt.setTime(param.parameterName, (Time)value[0], (Calendar)value[1]);
                continue;
            }
            if (param.method.equals("setTimestamp(String parameterName, java.sql.Timestamp x)")) {
                cstmt.setTimestamp(param.parameterName, (Timestamp)param.data);
                continue;
            }
            if (param.method.equals("setTimestamp(String parameterName, java.sql.Timestamp x, Calendar cal)")) {
                value = (Object[])param.data;
                cstmt.setTimestamp(param.parameterName, (Timestamp)value[0], (Calendar)value[1]);
                continue;
            }
            if (!param.method.equals("setURL(String parameterName, java.net.URL val)")) continue;
            cstmt.setURL(param.parameterName, (URL)param.data);
        }
    }
}

