/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support.validate;

import java.util.List;
import org.frameworkset.spi.support.validate.ObjectError;
import org.frameworkset.util.Assert;
import org.frameworkset.util.ObjectUtils;

public class FieldError
extends ObjectError {
    private final String field;
    private final Class type;
    private List<FieldError> errors;
    private final Object rejectedValue;
    private final boolean bindingFailure;

    public Class getType() {
        return this.type;
    }

    public FieldError(String objectName, String field, String defaultMessage) {
        this(objectName, field, null, null, false, null, null, defaultMessage);
    }

    public FieldError(String objectName, String field, Object rejectedValue, Class type, boolean bindingFailure, String[] codes, Object[] arguments, String defaultMessage) {
        super(objectName, codes, arguments, defaultMessage);
        Assert.notNull((Object)field, (String)"Field must not be null");
        this.field = field;
        this.rejectedValue = rejectedValue;
        this.bindingFailure = bindingFailure;
        this.type = type;
    }

    public String getField() {
        return this.field;
    }

    public Object getRejectedValue() {
        return this.rejectedValue;
    }

    public boolean isBindingFailure() {
        return this.bindingFailure;
    }

    @Override
    public String toString() {
        return "Field error in object '" + this.getObjectName() + "' on field '" + this.field + "': rejected value [" + this.rejectedValue + "]; " + this.resolvableToString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        FieldError otherError = (FieldError)other;
        return this.getField().equals(otherError.getField()) && ObjectUtils.nullSafeEquals((Object)this.getRejectedValue(), (Object)otherError.getRejectedValue()) && this.isBindingFailure() == otherError.isBindingFailure();
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 29 * hashCode + this.getField().hashCode();
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getRejectedValue());
        hashCode = 29 * hashCode + (this.isBindingFailure() ? 1 : 0);
        return hashCode;
    }
}

