/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi;

import java.io.InputStream;
import java.net.URL;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.BeanDestroyHook;
import org.frameworkset.spi.assemble.ServiceProviderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationContext
extends BaseApplicationContext {
    private static Logger log = LoggerFactory.getLogger(DefaultApplicationContext.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultApplicationContext getApplicationContext(String configfile) {
        DefaultApplicationContext instance;
        if (configfile == null || configfile.equals("")) {
            log.debug("configfile is null or empty.default Config File[" + ServiceProviderManager.defaultConfigFile + "] will be used. ");
            configfile = ServiceProviderManager.defaultConfigFile;
        }
        if ((instance = (DefaultApplicationContext)applicationContexts.get(configfile)) != null) {
            instance.initApplicationContext();
            return instance;
        }
        Object object = lock;
        synchronized (object) {
            instance = (DefaultApplicationContext)applicationContexts.get(configfile);
            if (instance != null) {
                return instance;
            }
            instance = new DefaultApplicationContext(configfile);
            BaseApplicationContext.addShutdownHook(new BeanDestroyHook(instance));
            applicationContexts.put(configfile, instance);
        }
        instance.initApplicationContext();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultApplicationContext getApplicationContext(URL configfile) {
        if (configfile == null || configfile.equals("")) {
            throw new IllegalArgumentException("configfile is null");
        }
        String conf = configfile.getFile();
        DefaultApplicationContext instance = (DefaultApplicationContext)applicationContexts.get(conf);
        if (instance != null) {
            instance.initApplicationContext();
            return instance;
        }
        Object object = lock;
        synchronized (object) {
            instance = (DefaultApplicationContext)applicationContexts.get(conf);
            if (instance != null) {
                return instance;
            }
            instance = new DefaultApplicationContext(configfile);
            BaseApplicationContext.addShutdownHook(new BeanDestroyHook(instance));
            applicationContexts.put(conf, instance);
        }
        instance.initApplicationContext();
        return instance;
    }

    protected DefaultApplicationContext(String configfile) {
        super(configfile);
    }

    protected DefaultApplicationContext(String configfile, boolean isfile, boolean init) {
        super(configfile, isfile, init);
    }

    protected DefaultApplicationContext(String configfile, boolean isfile, String charset, boolean init) {
        super(configfile, isfile, charset, init);
    }

    protected DefaultApplicationContext(String docbaseType, String docbase, String configfile) {
        super(docbaseType, docbase, configfile);
    }

    protected DefaultApplicationContext(String docbaseType, String docbase, String configfile, boolean isfile) {
        super(docbaseType, docbase, configfile, isfile, true);
    }

    public DefaultApplicationContext(URL file, String path) {
        super(file, path);
    }

    public DefaultApplicationContext(InputStream instream, boolean isfile, boolean init) {
        super(instream, isfile, init);
    }

    public DefaultApplicationContext(URL configfile) {
        super("classpath::", "", configfile, true);
    }
}

