/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tea;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TeaResponse {
    private HttpURLConnection conn;
    public int statusCode;
    public String statusMessage;
    public HashMap<String, String> headers = new HashMap();

    public TeaResponse() {
    }

    public TeaResponse(HttpURLConnection conn) throws IOException {
        this.conn = conn;
        this.statusCode = conn.getResponseCode();
        this.statusMessage = conn.getResponseMessage();
        Map<String, List<String>> headers = conn.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (null == key) continue;
            List<String> values = entry.getValue();
            StringBuilder builder = new StringBuilder(values.get(0));
            for (int i = 1; i < values.size(); ++i) {
                builder.append(",");
                builder.append(values.get(i));
            }
            this.headers.put(key.toLowerCase(), builder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseBody() throws IOException {
        InputStream content;
        try {
            content = this.conn.getInputStream();
        }
        catch (IOException e) {
            content = this.conn.getErrorStream();
        }
        try {
            int read;
            if (null == content) {
                String e = String.format("{\"message\":\"%s\"}", this.statusMessage);
                return e;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            while ((read = content.read(buff)) != -1) {
                os.write(buff, 0, read);
            }
            String string = new String(os.toByteArray());
            return string;
        }
        finally {
            this.conn.disconnect();
        }
    }

    public InputStream getResponse() throws IOException {
        return this.conn.getInputStream();
    }
}

