/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.teautil;

import com.aliyun.tea.utils.StringUtils;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.UUID;

public class Common {
    private static final String defaultUserAgent;

    public static byte[] toBytes(String str) throws UnsupportedEncodingException {
        return str.getBytes("UTF-8");
    }

    public static String toString(byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes, "UTF-8");
    }

    public static Object parseJSON(String json) {
        return new Gson().fromJson(json, Map.class);
    }

    public static Map<String, Object> assertAsMap(Object object) {
        if (null != object && Map.class.isAssignableFrom(object.getClass())) {
            return (Map)object;
        }
        throw new RuntimeException("The value is not a object");
    }

    public static byte[] readAsBytes(InputStream stream) throws IOException {
        if (null == stream) {
            return new byte[0];
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int read;
        while ((read = stream.read(buff)) != -1) {
            os.write(buff, 0, read);
        }
        return os.toByteArray();
    }

    public static String readAsString(InputStream stream) throws IOException {
        return new String(Common.readAsBytes(stream), "UTF-8");
    }

    public static Object readAsJSON(InputStream stream) throws IOException {
        String body = Common.readAsString(stream);
        return Common.parseJSON(body);
    }

    public static String getNonce() {
        StringBuffer uniqueNonce = new StringBuffer();
        UUID uuid = UUID.randomUUID();
        uniqueNonce.append(uuid.toString());
        uniqueNonce.append(System.currentTimeMillis());
        uniqueNonce.append(Thread.currentThread().getId());
        return uniqueNonce.toString();
    }

    public static String getDateUTCString() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(new Date());
    }

    public static String defaultString(String str, String defaultStr) {
        if (!StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        return defaultStr;
    }

    public static Number defaultNumber(Number number, Number defaultNumber) {
        if (number != null && number.doubleValue() >= 0.0) {
            return number;
        }
        return defaultNumber;
    }

    public static String toFormString(Map<String, ?> map) throws UnsupportedEncodingException {
        if (null == map) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8"));
        }
        return result.toString();
    }

    public static String toJSONString(Object object) {
        return new Gson().toJson(object);
    }

    public static boolean empty(String str) {
        return StringUtils.isEmpty((CharSequence)str);
    }

    public static boolean equalString(String str, String val) {
        if (str == null || val == null) {
            return false;
        }
        return str.equals(val);
    }

    public static boolean equalNumber(Number num, Number val) {
        if (num == null || val == null) {
            return false;
        }
        return num.doubleValue() == val.doubleValue();
    }

    public static boolean isUnset(Object object) {
        return null == object;
    }

    public static Map<String, String> stringifyMapValue(Map<String, ?> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null == map) {
            return null;
        }
        map.forEach((key, value) -> result.put((String)key, String.valueOf(value)));
        return result;
    }

    public static String getUserAgent(String val) throws Exception {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return defaultUserAgent;
        }
        return defaultUserAgent + " " + val;
    }

    public static boolean is2xx(Number code) throws Exception {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 200 && code.intValue() < 300;
    }

    public static boolean is3xx(Number code) throws Exception {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 300 && code.intValue() < 400;
    }

    public static boolean is4xx(Number code) throws Exception {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 400 && code.intValue() < 500;
    }

    public static boolean is5xx(Number code) throws Exception {
        if (null == code) {
            return false;
        }
        return code.intValue() >= 500 && code.intValue() < 600;
    }

    static {
        Properties sysProps = System.getProperties();
        String coreVersion = "";
        Properties props = new Properties();
        try {
            props.load(Common.class.getClassLoader().getResourceAsStream("project.properties"));
            coreVersion = props.getProperty("sdk.project.version");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        defaultUserAgent = String.format("AlibabaCloud (%s; %s) Java/%s %s/%s TeaDSL/1", sysProps.getProperty("os.name"), sysProps.getProperty("os.arch"), sysProps.getProperty("java.runtime.version"), "tea-util", coreVersion);
    }
}

