/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.impl.conn;

import com.alibaba.schedulerx.shade.org.apache.commons.logging.Log;
import com.aliyun.log.thirdparty.org.apache.http.annotation.Immutable;
import com.aliyun.log.thirdparty.org.apache.http.util.Args;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

@Immutable
public class Wire {
    private final Log log;
    private final String id;

    public Wire(Log log2, String id) {
        this.log = log2;
        this.id = id;
    }

    public Wire(Log log2) {
        this(log2, "");
    }

    private void wire(String header, InputStream instream) throws IOException {
        int ch;
        StringBuilder buffer = new StringBuilder();
        while ((ch = instream.read()) != -1) {
            if (ch == 13) {
                buffer.append("[\\r]");
                continue;
            }
            if (ch == 10) {
                buffer.append("[\\n]\"");
                buffer.insert(0, "\"");
                buffer.insert(0, header);
                this.log.debug(this.id + " " + buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (ch < 32 || ch > 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() > 0) {
            buffer.append('\"');
            buffer.insert(0, '\"');
            buffer.insert(0, header);
            this.log.debug(this.id + " " + buffer.toString());
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    public void output(InputStream outstream) throws IOException {
        Args.notNull(outstream, "Output");
        this.wire(">> ", outstream);
    }

    public void input(InputStream instream) throws IOException {
        Args.notNull(instream, "Input");
        this.wire("<< ", instream);
    }

    public void output(byte[] b, int off, int len2) throws IOException {
        Args.notNull(b, "Output");
        this.wire(">> ", new ByteArrayInputStream(b, off, len2));
    }

    public void input(byte[] b, int off, int len2) throws IOException {
        Args.notNull(b, "Input");
        this.wire("<< ", new ByteArrayInputStream(b, off, len2));
    }

    public void output(byte[] b) throws IOException {
        Args.notNull(b, "Output");
        this.wire(">> ", new ByteArrayInputStream(b));
    }

    public void input(byte[] b) throws IOException {
        Args.notNull(b, "Input");
        this.wire("<< ", new ByteArrayInputStream(b));
    }

    public void output(int b) throws IOException {
        this.output(new byte[]{(byte)b});
    }

    public void input(int b) throws IOException {
        this.input(new byte[]{(byte)b});
    }

    public void output(String s2) throws IOException {
        Args.notNull(s2, "Output");
        this.output(s2.getBytes());
    }

    public void input(String s2) throws IOException {
        Args.notNull(s2, "Input");
        this.input(s2.getBytes());
    }
}

