/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.client.methods;

import com.aliyun.log.thirdparty.org.apache.http.Header;
import com.aliyun.log.thirdparty.org.apache.http.HttpEntity;
import com.aliyun.log.thirdparty.org.apache.http.HttpEntityEnclosingRequest;
import com.aliyun.log.thirdparty.org.apache.http.HttpHost;
import com.aliyun.log.thirdparty.org.apache.http.HttpRequest;
import com.aliyun.log.thirdparty.org.apache.http.ProtocolVersion;
import com.aliyun.log.thirdparty.org.apache.http.RequestLine;
import com.aliyun.log.thirdparty.org.apache.http.annotation.NotThreadSafe;
import com.aliyun.log.thirdparty.org.apache.http.client.methods.HttpUriRequest;
import com.aliyun.log.thirdparty.org.apache.http.message.AbstractHttpMessage;
import com.aliyun.log.thirdparty.org.apache.http.message.BasicRequestLine;
import com.aliyun.log.thirdparty.org.apache.http.params.HttpParams;
import com.aliyun.log.thirdparty.org.apache.http.util.Args;
import java.net.URI;

@NotThreadSafe
public class HttpRequestWrapper
extends AbstractHttpMessage
implements HttpUriRequest {
    private final HttpRequest original;
    private final HttpHost target;
    private final String method;
    private RequestLine requestLine;
    private ProtocolVersion version;
    private URI uri;

    private HttpRequestWrapper(HttpRequest request2, HttpHost target) {
        this.original = Args.notNull(request2, "HTTP request");
        this.target = target;
        this.version = this.original.getRequestLine().getProtocolVersion();
        this.method = this.original.getRequestLine().getMethod();
        this.uri = request2 instanceof HttpUriRequest ? ((HttpUriRequest)request2).getURI() : null;
        this.setHeaders(request2.getAllHeaders());
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : this.original.getProtocolVersion();
    }

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
        this.requestLine = null;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
        this.requestLine = null;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void abort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    @Override
    public RequestLine getRequestLine() {
        if (this.requestLine == null) {
            String requestUri = this.uri != null ? this.uri.toASCIIString() : this.original.getRequestLine().getUri();
            if (requestUri == null || requestUri.isEmpty()) {
                requestUri = "/";
            }
            this.requestLine = new BasicRequestLine(this.method, requestUri, this.getProtocolVersion());
        }
        return this.requestLine;
    }

    public HttpRequest getOriginal() {
        return this.original;
    }

    public HttpHost getTarget() {
        return this.target;
    }

    public String toString() {
        return this.getRequestLine() + " " + this.headergroup;
    }

    public static HttpRequestWrapper wrap(HttpRequest request2) {
        return HttpRequestWrapper.wrap(request2, null);
    }

    public static HttpRequestWrapper wrap(HttpRequest request2, HttpHost target) {
        Args.notNull(request2, "HTTP request");
        if (request2 instanceof HttpEntityEnclosingRequest) {
            return new HttpEntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request2, target);
        }
        return new HttpRequestWrapper(request2, target);
    }

    @Override
    @Deprecated
    public HttpParams getParams() {
        if (this.params == null) {
            this.params = this.original.getParams().copy();
        }
        return this.params;
    }

    static class HttpEntityEnclosingRequestWrapper
    extends HttpRequestWrapper
    implements HttpEntityEnclosingRequest {
        private HttpEntity entity;

        HttpEntityEnclosingRequestWrapper(HttpEntityEnclosingRequest request2, HttpHost target) {
            super(request2, target);
            this.entity = request2.getEntity();
        }

        @Override
        public HttpEntity getEntity() {
            return this.entity;
        }

        @Override
        public void setEntity(HttpEntity entity) {
            this.entity = entity;
        }

        @Override
        public boolean expectContinue() {
            Header expect = this.getFirstHeader("Expect");
            return expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
        }
    }
}

